/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        11.01.2009
 Description:    Ansteuerung des MAX7456

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#include "pal.h"   
#include "font.h"

volatile unsigned int display_memory_address = 0;

//----------------------------------------------------------------------------
// 
unsigned char pal_data_write (unsigned char a,unsigned char b)
{ 
    PAL_CS_LOW;
    
    for(unsigned long a=0;a<50;a++){asm("nop");};   
    SPDR = a;
    while(!(SPSR & (1<<SPIF)))
	
    for(unsigned long a=0;a<50;a++){asm("nop");};
    SPDR = b;
    while(!(SPSR & (1<<SPIF)))
    
    
    for(unsigned long a=0;a<50;a++){asm("nop");}; 
    PAL_CS_HIGH;
    return(SPDR);
}

//----------------------------------------------------------------------------
void pal_write_P (const char *Buffer,...)
{
	va_list ap;
	va_start (ap, Buffer);	
	
	int format_flag;
	char str_buffer[10];
	char str_null_buffer[10];
	char move = 0;
	char Base = 0;
	int tmp = 0;
	char by;
	char *ptr;
		
	//Ausgabe der Zeichen
    for(;;)
	{
		by = pgm_read_byte(Buffer++);
		if(by==0) break; // end of format string
            
		if (by == '%')
		{
            by = pgm_read_byte(Buffer++);
			if (isdigit(by)>0)
				{
                                 
 				str_null_buffer[0] = by;
				str_null_buffer[1] = '\0';
				move = atoi(str_null_buffer);
                by = pgm_read_byte(Buffer++);
				}

			switch (by)
				{
                case 's':
                    ptr = va_arg(ap,char *);
                    while(*ptr) { pal_write_char(*ptr++); }
                    break;
				case 'b':
					Base = 2;
					goto ConversionLoop;
				case 'c':
					//Int to char
					format_flag = va_arg(ap,int);
					pal_write_char (format_flag++);
					break;
				case 'i':
					Base = 10;
					goto ConversionLoop;
				case 'o':
					Base = 8;
					goto ConversionLoop;
				case 'x':
					Base = 16;
					//****************************
					ConversionLoop:
					//****************************
					itoa(va_arg(ap,int),str_buffer,Base);
					int b=0;
					while (str_buffer[b++] != 0){};
					b--;
					if (b<move)
						{
						move -=b;
						for (tmp = 0;tmp<move;tmp++)
							{
							str_null_buffer[tmp] = '0';
							}
						//tmp ++;
						str_null_buffer[tmp] = '\0';
						strcat(str_null_buffer,str_buffer);
						strcpy(str_buffer,str_null_buffer);
						}
					pal_write_str (str_buffer);
					move =0;
					break;
				}
			
			}	
		else
		{
            pal_write_char(by);
		}
	}
	va_end(ap);
}

//----------------------------------------------------------------------------
//Ausgabe eines Strings
void pal_write_char(char by)
{
    pal_data_write (0x05,(display_memory_address&0xFF00)>>8);
    pal_data_write (0x06,(display_memory_address&0x00FF));
    if (by == 32) by = 0;
    if (by >= 48 && by <= 57) by -= 44;
    if (by == 58) by = 15;
    if (by >= 65 && by <= 90) by -= 49;
    if (by >= 97 && by <= 122) by -= 55;
    pal_data_write (0x07,by);
    display_memory_address++;
    return;
}

//----------------------------------------------------------------------------
//Ausgabe eines Strings
void pal_write_str(char *str)
{
	while (*str)
	{
        pal_write_char(*str++);
	}
}

//----------------------------------------------------------------------------
//Init Pal
void pal_init (void)
{   
    //Setup Serial Peripheral Interface
    DDRB |= (1<<PB3)|(1<<PB5)|(1<<PB2); 
    
    //CS Signal
    DDRB |= (1<<PB1);
    PAL_CS_HIGH;
    
    //Setup Serial Peripheral Interface (SPI) 
    SPCR |= (1<<SPE)|(1<<MSTR)|(1<<SPR0);
 
    //Programmieren des Zeichensatzes 
    for(unsigned char count = 0;count <91;count++)
    {
        unsigned int tmp = ((unsigned int)&FONT)+(64*count);
        unsigned char Index;
        pal_data_write(VIDEO_MODE_0_WRITE,0x00);
     
        pal_data_write(FM_ADDRH_WRITE,count);  
        for(Index = 0x00; Index < 0x36; Index++)
        {
            pal_data_write(FM_ADDRL_WRITE,Index);
            pal_data_write(FM_DATA_IN_WRITE,pgm_read_byte(tmp+Index));     
        }
        pal_data_write(FM_MODE_WRITE, 0xA0);
        //for(unsigned long a=0;a<100000;a++){asm("nop");};
        while ((pal_data_write(STATUS_READ,0) & 0x20) != 0x00);
    }
       
    pal_data_write (0x00,0x48);
    pal_data_write (0x04,0x04);
    pal_data_write (0x05,(display_memory_address&0xFF00)>>8);
    pal_data_write (0x06,(display_memory_address&0x00FF));

	return;
}

//----------------------------------------------------------------------------
//Display Lschen
void pal_clear (void)
{ 
    display_memory_address = 0x00;
    for(unsigned int a= 0;a<480;a++)
    {
        pal_data_write (0x05,(display_memory_address&0xFF00)>>8);
        pal_data_write (0x06,(display_memory_address&0x00FF));
        pal_data_write (0x07,0);
        display_memory_address++;
    }
}
