/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class AnalisysParametersDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    static final long serialVersionUID = 10L;
    public static final int MISC_PARAMETERS_NUMBER = 4;
    public static final int LT_PARAMETER_INDEX = 0;
    public static final int RT_PARAMETER_INDEX = 1;
    public static final int ET_PARAMETER_INDEX = 2;
    public static final int BC_PARAMETER_INDEX = 3;
    private static final String[] parametersString = new String[]{"LT_STRING", "RT_STRING", "ET_STRING", "BC_STRING"};
    private static final String[] parametersDimensionString = new String[]{"dB", "dB", "dB", "dB"};
    private static final float[][] parametersMinMax = new float[][]{{0.0f, 65.0f}, {-65.0f, 0.0f}, {0.0f, 65.0f}, {-90.0f, -40.0f}};
    private JLabel[] labelMiscParameters;
    private ParametersTextField[] textFieldMiscParameters;
    private JLabel[] labelMiscParametersDimension;
    private JButton cancelButton;
    private JButton okButton;
    private MainClass mainClass;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private int buttonWidth;
    private JPanel dialogPane;

    AnalisysParametersDialog(Frame owner, MainClass mClass) {
        super(owner);
        this.mainClass = mClass;
        this.dialogPane = new JPanel();
        this.setContentPane(this.dialogPane);
        this.setModal(true);
        this.setTitle(this.mainClass.getResourceString("Analisys_parameters"));
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.setResizable(false);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 0.7;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.labelMiscParameters = new JLabel[4];
        this.textFieldMiscParameters = new ParametersTextField[4];
        this.labelMiscParametersDimension = new JLabel[4];
        int i = 0;
        while (i < this.labelMiscParameters.length) {
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.6;
            this.labelMiscParameters[i] = new JLabel();
            this.labelMiscParameters[i].setText(this.mainClass.getResourceString(parametersString[i]));
            this.labelMiscParameters[i].setHorizontalAlignment(4);
            this.gbLayout.setConstraints(this.labelMiscParameters[i], this.gbConstraints);
            this.add(this.labelMiscParameters[i]);
            this.textFieldMiscParameters[i] = new ParametersTextField();
            this.textFieldMiscParameters[i].addPropertyChangeListener("value", this);
            this.textFieldMiscParameters[i].setMinValue(parametersMinMax[i][0]);
            this.textFieldMiscParameters[i].setMaxValue(parametersMinMax[i][1]);
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.3;
            this.gbLayout.setConstraints(this.textFieldMiscParameters[i], this.gbConstraints);
            this.textFieldMiscParameters[i].setEditable(true);
            this.textFieldMiscParameters[i].setHorizontalAlignment(4);
            this.add(this.textFieldMiscParameters[i]);
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.2;
            this.labelMiscParametersDimension[i] = new JLabel();
            this.labelMiscParametersDimension[i].setText(parametersDimensionString[i]);
            this.gbLayout.setConstraints(this.labelMiscParametersDimension[i], this.gbConstraints);
            this.add(this.labelMiscParametersDimension[i]);
            ++i;
        }
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.okButton.setText(this.mainClass.getResourceString("ok"));
        this.okButton.setName("okButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.okButton, this.gbConstraints);
        this.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText(this.mainClass.getResourceString("cancel"));
        this.cancelButton.setName("cancelButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.cancelButton, this.gbConstraints);
        this.add(this.cancelButton);
        this.pack();
        this.dialogPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AnalisysParametersDialog.this.reallocButtons();
            }
        });
        this.buttonWidth = 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof ParametersTextField) {
            ParametersTextField prmFld = (ParametersTextField)source;
            float value = ((Float)prmFld.getValue()).floatValue();
            if (prmFld.getMinValue() > value) {
                prmFld.setValue(Float.valueOf(prmFld.getMinValue()));
            }
            if (prmFld.getMaxValue() < value) {
                prmFld.setValue(Float.valueOf(prmFld.getMaxValue()));
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (b) {
            this.setTitle(String.valueOf(this.mainClass.getResourceString("Analisys_parameters")) + " - " + sorFile.getFileName());
            this.reallocButtons();
        }
        this.updateView();
        this.cancelButton.requestFocus();
        super.setVisible(b);
    }

    private void reallocButtons() {
        if (this.buttonWidth == 0) {
            Component comp;
            int maxWidth = 0;
            Component[] componentArray = this.dialogPane.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                comp = componentArray[n2];
                if (comp instanceof JButton || comp instanceof JToggleButton) {
                    maxWidth = Math.max(maxWidth, comp.getWidth());
                }
                ++n2;
            }
            componentArray = this.dialogPane.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                comp = componentArray[n2];
                if (comp instanceof JButton || comp instanceof JToggleButton) {
                    GridBagConstraints tmpConstraints = this.gbLayout.getConstraints(comp);
                    tmpConstraints.ipadx = Math.max(0, maxWidth - comp.getWidth());
                    this.gbLayout.setConstraints(comp, tmpConstraints);
                }
                ++n2;
            }
            this.dialogPane.validate();
            this.buttonWidth = maxWidth;
        }
    }

    public void updateView() {
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        this.textFieldMiscParameters[0].setValue(Float.valueOf((float)sorFile.fxdParams.lossThreshold / 1000.0f));
        this.textFieldMiscParameters[1].setValue(Float.valueOf((float)(-sorFile.fxdParams.reflectanceThreshold) / 1000.0f));
        this.textFieldMiscParameters[2].setValue(Float.valueOf((float)sorFile.fxdParams.endOfFiberThreshold / 1000.0f));
        this.textFieldMiscParameters[3].setValue(Float.valueOf((float)(-sorFile.fxdParams.backscatterCoefficient) / 10.0f));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (this.okButton == src) {
            SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
            if (sorFile == null) {
                return;
            }
            sorFile.fxdParams.lossThreshold = Math.round(((Float)this.textFieldMiscParameters[0].getValue()).floatValue() * 1000.0f);
            sorFile.fxdParams.reflectanceThreshold = Math.round(((Float)this.textFieldMiscParameters[1].getValue()).floatValue() * -1000.0f);
            sorFile.fxdParams.endOfFiberThreshold = Math.round(((Float)this.textFieldMiscParameters[2].getValue()).floatValue() * 1000.0f);
            sorFile.fxdParams.backscatterCoefficient = (short)Math.round(((Float)this.textFieldMiscParameters[3].getValue()).floatValue() * -10.0f);
            this.setVisible(false);
        } else if (this.cancelButton == src) {
            this.updateView();
            this.setVisible(false);
        }
    }

    private class ParametersTextField
    extends JFormattedTextField {
        static final long serialVersionUID = 11L;
        private float maxValue;
        private float minValue;

        public void setMaxValue(float val) {
            this.maxValue = val;
        }

        public void setMinValue(float val) {
            this.minValue = val;
        }

        public float getMaxValue() {
            return this.maxValue;
        }

        public float getMinValue() {
            return this.minValue;
        }
    }
}

