/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OTDRParametersDialog
extends JDialog
implements ActionListener,
ItemListener,
FocusListener {
    static final long serialVersionUID = 25L;
    static DialogElement[] dialogElements = new DialogElement[]{new DialogElement(JComboBox.class, "OpticalFiberType", ""), new DialogElement(JComboBox.class, "LMax", "km"), new DialogElement(JComboBox.class, "ResolutionDL", "m"), new DialogElement(JComboBox.class, "PulseWidth", "ns"), new DialogElement(JTextField.class, "BackscatterCoefficient", "dB"), new DialogElement(JTextField.class, "RefractiveIndexN", ""), new DialogElement(JComboBox.class, "NAVR", ""), new DialogElement(JComboBox.class, "TAVR", ""), new DialogElement(JCheckBox.class, "ISLP", ""), new DialogElement(JCheckBox.class, "ISHR", ""), new DialogElement(JCheckBox.class, "ISFL", "")};
    public static final int PDE_FIBER_TYPE = 0;
    public static final int PDE_L_MAX = 1;
    public static final int PDE_RES = 2;
    public static final int PDE_PULSE = 3;
    public static final int PDE_BC = 4;
    public static final int PDE_N = 5;
    public static final int PDE_NAVR = 6;
    public static final int PDE_TAVR = 7;
    public static final int PDE_ISLP = 8;
    public static final int PDE_ISHR = 9;
    public static final int PDE_ISFL = 10;
    public static final String onString = "ON";
    public static final String offString = "OFF";
    private MainClass mainClass;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private OTDRModuleParameters bakOTDRModuleParameters;

    OTDRParametersDialog(MainClass mClass) {
        super(mClass.mainFrame);
        this.mainClass = mClass;
        this.setModal(true);
        this.setTitle(this.mainClass.getResourceString("OTDRParametersDialogCaption"));
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.setResizable(false);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(2, 2, 2, 2);
        ButtonGroup bgAveraging = new ButtonGroup();
        int i = 0;
        while (i < dialogElements.length) {
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = 8 != i && 9 != i && 10 != i ? -1 : 0;
            this.gbConstraints.weightx = 1.0;
            if (6 != i && 7 != i && 8 != i && 9 != i && 10 != i) {
                JLabel tmpLabel = new JLabel();
                tmpLabel.setName(OTDRParametersDialog.dialogElements[i].captionID);
                tmpLabel.setText(this.mainClass.getResourceString(OTDRParametersDialog.dialogElements[i].captionID));
                tmpLabel.setHorizontalAlignment(4);
                this.gbLayout.setConstraints(tmpLabel, this.gbConstraints);
                this.add(tmpLabel);
            } else {
                JCheckBox tmpCheckBox = new JCheckBox();
                tmpCheckBox.setName(OTDRParametersDialog.dialogElements[i].captionID);
                tmpCheckBox.setText(this.mainClass.getResourceString(OTDRParametersDialog.dialogElements[i].captionID));
                tmpCheckBox.setHorizontalAlignment(2);
                this.gbLayout.setConstraints(tmpCheckBox, this.gbConstraints);
                this.add(tmpCheckBox);
                if (6 == i || 7 == i) {
                    bgAveraging.add(tmpCheckBox);
                }
            }
            this.gbConstraints.gridwidth = -1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 1.0;
            if (JTextField.class == OTDRParametersDialog.dialogElements[i].clss) {
                JTextField tmpTextField = new JTextField();
                tmpTextField.setName(OTDRParametersDialog.dialogElements[i].captionID);
                tmpTextField.setEditable(true);
                tmpTextField.addFocusListener(this);
                this.gbLayout.setConstraints(tmpTextField, this.gbConstraints);
                this.add(tmpTextField);
            } else if (JComboBox.class == OTDRParametersDialog.dialogElements[i].clss) {
                JComboBox tmpComboBox = new JComboBox();
                tmpComboBox.setName(OTDRParametersDialog.dialogElements[i].captionID);
                tmpComboBox.setEnabled(true);
                tmpComboBox.setEditable(false);
                this.gbLayout.setConstraints(tmpComboBox, this.gbConstraints);
                this.add(tmpComboBox);
            }
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 1.0;
            JLabel labelUnits = new JLabel();
            labelUnits.setName(OTDRParametersDialog.dialogElements[i].unitsID);
            labelUnits.setText(" " + this.mainClass.getResourceString(OTDRParametersDialog.dialogElements[i].unitsID));
            labelUnits.setHorizontalAlignment(2);
            this.gbLayout.setConstraints(labelUnits, this.gbConstraints);
            this.add(labelUnits);
            ++i;
        }
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(10, 0, 20, 0);
        this.buttonsPanel = new JPanel();
        this.gbLayout.setConstraints(this.buttonsPanel, this.gbConstraints);
        this.add(this.buttonsPanel);
        this.buttonsPanel.setLayout(this.gbLayout);
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbConstraints.anchor = 13;
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.okButton.setText(this.mainClass.getResourceString("ok"));
        this.gbLayout.setConstraints(this.okButton, this.gbConstraints);
        this.buttonsPanel.add(this.okButton);
        this.gbConstraints.anchor = 10;
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText(this.mainClass.getResourceString("cancel"));
        this.gbLayout.setConstraints(this.cancelButton, this.gbConstraints);
        this.buttonsPanel.add(this.cancelButton);
        this.gbConstraints.anchor = 17;
        this.defaultButton = new JButton();
        this.defaultButton.addActionListener(this);
        this.defaultButton.setText(this.mainClass.getResourceString("default"));
        this.gbLayout.setConstraints(this.defaultButton, this.gbConstraints);
        this.buttonsPanel.add(this.defaultButton);
        this.pack();
    }

    private void resizeButtons() {
        Component comp;
        int maxButtonWidth = 0;
        Component[] componentArray = this.buttonsPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            comp = componentArray[n2];
            if (comp instanceof JButton) {
                maxButtonWidth = Math.max(comp.getWidth(), maxButtonWidth);
            }
            ++n2;
        }
        componentArray = this.buttonsPanel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            GridBagConstraints tmpConstraints;
            comp = componentArray[n2];
            if (comp instanceof JButton && (tmpConstraints = this.gbLayout.getConstraints(comp)) != null) {
                tmpConstraints.ipadx = Math.max(0, maxButtonWidth - comp.getWidth());
                this.gbLayout.setConstraints(comp, tmpConstraints);
            }
            ++n2;
        }
        this.buttonsPanel.validate();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.bakOTDRModuleParameters = this.mainClass.getOTDRModuleParameters().clone();
            this.resizeButtons();
            this.updateView();
        }
        super.setVisible(b);
    }

    public void updateView() {
        if (!this.mainClass.getTL1RTUClient().isConnected()) {
            return;
        }
        Component[] componentArray = this.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JCheckBox) {
                JCheckBox tmpCheckBox = (JCheckBox)comp;
                tmpCheckBox.removeItemListener(this);
                boolean check = false;
                if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[6].captionID) == 0) {
                    if (this.mainClass.getOTDRModuleParameters().isTA.toUpperCase().compareTo(offString) == 0) {
                        check = true;
                    }
                } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[7].captionID) == 0) {
                    if (this.mainClass.getOTDRModuleParameters().isTA.toUpperCase().compareTo(onString) == 0) {
                        check = true;
                    }
                } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[8].captionID) == 0) {
                    if (this.mainClass.getOTDRModuleParameters().isLP.toUpperCase().compareTo(onString) == 0) {
                        check = true;
                    }
                } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[9].captionID) == 0) {
                    if (this.mainClass.getOTDRModuleParameters().isHR.toUpperCase().compareTo(onString) == 0) {
                        check = true;
                    }
                } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[10].captionID) == 0 && this.mainClass.getOTDRModuleParameters().isFl.toUpperCase().compareTo(onString) == 0) {
                    check = true;
                }
                tmpCheckBox.setSelected(check);
                tmpCheckBox.addItemListener(this);
            } else if (comp instanceof JTextField) {
                JTextField tmpTextField = (JTextField)comp;
                if (tmpTextField.getName().compareTo(OTDRParametersDialog.dialogElements[4].captionID) == 0) {
                    tmpTextField.setText(this.mainClass.getOTDRModuleParameters().bC);
                } else if (tmpTextField.getName().compareTo(OTDRParametersDialog.dialogElements[5].captionID) == 0) {
                    tmpTextField.setText(this.mainClass.getOTDRModuleParameters().rI);
                }
            } else if (comp instanceof JComboBox) {
                JComboBox tmpComboBox = (JComboBox)comp;
                tmpComboBox.removeItemListener(this);
                String currentItem = null;
                String[] cbItemsArray = null;
                if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[0].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().wLList;
                    currentItem = this.mainClass.getOTDRModuleParameters().wL;
                } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[1].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().lMaxList;
                    currentItem = this.mainClass.getOTDRModuleParameters().lMax;
                } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[2].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().resList;
                    currentItem = this.mainClass.getOTDRModuleParameters().res;
                } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[3].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().plsList;
                    currentItem = this.mainClass.getOTDRModuleParameters().pls;
                } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[6].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().navrList;
                    currentItem = this.mainClass.getOTDRModuleParameters().nAvr;
                    if (this.mainClass.getOTDRModuleParameters().isTA.toUpperCase().compareTo(offString) == 0) {
                        tmpComboBox.setEnabled(true);
                    } else {
                        tmpComboBox.setEnabled(false);
                    }
                } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[7].captionID) == 0) {
                    cbItemsArray = this.mainClass.getOTDRModuleParameters().tavrList;
                    currentItem = this.mainClass.getOTDRModuleParameters().tAvr;
                    if (this.mainClass.getOTDRModuleParameters().isTA.toUpperCase().compareTo(offString) == 0) {
                        tmpComboBox.setEnabled(false);
                    } else {
                        tmpComboBox.setEnabled(true);
                    }
                }
                tmpComboBox.removeAllItems();
                if (cbItemsArray != null) {
                    int l = 0;
                    while (l < cbItemsArray.length) {
                        tmpComboBox.addItem(cbItemsArray[l]);
                        ++l;
                    }
                    if (currentItem != null) {
                        tmpComboBox.setSelectedItem(currentItem);
                    }
                }
                tmpComboBox.addItemListener(this);
            }
            ++n2;
        }
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component source = (Component)e.getSource();
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        MainClass.QDEBUG("action for %s\n", source.getName());
        if (source == this.okButton) {
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.mainClass.setOTDRModuleParameters(this.bakOTDRModuleParameters.clone());
            this.mainClass.getTL1RTUClient().queueSetAllPrm();
            this.setVisible(false);
        } else if (source == this.defaultButton) {
            this.mainClass.setOTDRModuleParameters(this.mainClass.getOTDRModuleParameters().getDefaultOTDRModuleParameters().clone());
            this.mainClass.getTL1RTUClient().queueSetAllPrm();
            this.updateView();
        }
        this.setCursor(oldCursor);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JComboBox tmpComboBox;
        Object source = e.getSource();
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (source instanceof JCheckBox) {
            JCheckBox tmpCheckBox = (JCheckBox)source;
            String tmpParam = offString;
            if (tmpCheckBox.isSelected()) {
                MainClass.QDEBUG("selected %s\n", tmpCheckBox.getName());
                if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[7].captionID) == 0) {
                    this.mainClass.getOTDRModuleParameters().isTA = onString;
                    this.mainClass.getTL1RTUClient().changeIsTAvr();
                    this.updateView();
                } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[6].captionID) == 0) {
                    this.mainClass.getOTDRModuleParameters().isTA = offString;
                    this.mainClass.getTL1RTUClient().changeIsTAvr();
                    this.updateView();
                }
                tmpParam = onString;
            }
            if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[8].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().isLP = tmpParam;
                this.mainClass.getTL1RTUClient().changeLP();
                this.updateView();
            } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[9].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().isHR = tmpParam;
                this.mainClass.getTL1RTUClient().changeHR();
                this.updateView();
            } else if (tmpCheckBox.getName().compareTo(OTDRParametersDialog.dialogElements[10].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().isFl = tmpParam;
                this.mainClass.getTL1RTUClient().changeFL();
                this.updateView();
            }
        } else if (source instanceof JComboBox && (tmpComboBox = (JComboBox)source).getSelectedItem() == e.getItem()) {
            String sItem = (String)tmpComboBox.getSelectedItem();
            MainClass.QDEBUG("ID = %d, itemStateChanged for %s, item %s\n", e.getID(), tmpComboBox.getName(), e.getItem().toString());
            if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[0].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().wL = sItem;
                this.mainClass.getTL1RTUClient().changeWL();
            } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[1].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().lMax = sItem;
                this.mainClass.getTL1RTUClient().changeLMax();
                this.updateView();
            } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[2].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().res = sItem;
                this.mainClass.getTL1RTUClient().changeRes();
                this.updateView();
            } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[3].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().pls = sItem;
                this.mainClass.getTL1RTUClient().changePls();
            } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[6].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().nAvr = sItem;
                this.mainClass.getTL1RTUClient().changeNAvr();
                this.updateView();
            } else if (tmpComboBox.getName().compareTo(OTDRParametersDialog.dialogElements[7].captionID) == 0) {
                this.mainClass.getOTDRModuleParameters().tAvr = sItem;
                this.mainClass.getTL1RTUClient().changeTAvr();
                this.updateView();
            }
        }
        this.setCursor(oldCursor);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (source instanceof JTextField) {
            JTextField tmpTextField = (JTextField)source;
            String sVal = tmpTextField.getText();
            sVal = sVal.replace(",", ".");
            if (tmpTextField.getName().compareTo(OTDRParametersDialog.dialogElements[5].captionID) == 0) {
                try {
                    float oldVal = Float.valueOf(this.mainClass.getOTDRModuleParameters().rI).floatValue();
                    float val = Float.valueOf(sVal).floatValue();
                    if (val < 1.0f) {
                        val = 1.0f;
                    }
                    if (val > 2.0f) {
                        val = 2.0f;
                    }
                    sVal = String.format("%.5f", Float.valueOf(val));
                    this.mainClass.getOTDRModuleParameters().rI = sVal = sVal.replace(",", ".");
                    if (oldVal != val) {
                        this.mainClass.getTL1RTUClient().changeRI();
                    }
                    this.updateView();
                }
                catch (Exception exception) {
                    System.out.printf("Exception: %s\n", exception.getMessage());
                    sVal = this.mainClass.getOTDRModuleParameters().rI;
                }
            } else if (tmpTextField.getName().compareTo(OTDRParametersDialog.dialogElements[4].captionID) == 0) {
                try {
                    float oldVal = Float.valueOf(this.mainClass.getOTDRModuleParameters().bC).floatValue();
                    float val = Float.valueOf(sVal).floatValue();
                    if (val < -90.0f) {
                        val = -90.0f;
                    }
                    if (val > -40.0f) {
                        val = -40.0f;
                    }
                    sVal = String.format("%.2f", Float.valueOf(val));
                    this.mainClass.getOTDRModuleParameters().bC = sVal = sVal.replace(",", ".");
                    if (oldVal != val) {
                        this.mainClass.getTL1RTUClient().changeBC();
                    }
                }
                catch (Exception exception) {
                    System.out.printf("Exception: %s\n", exception.getMessage());
                    sVal = this.mainClass.getOTDRModuleParameters().bC;
                }
            }
            tmpTextField.setText(sVal);
        }
        this.setCursor(oldCursor);
    }

    private static class DialogElement {
        public Class<?> clss;
        public String captionID;
        public String unitsID;

        DialogElement(Class<?> cls0, String capID, String unID) {
            this.clss = cls0;
            this.captionID = capID;
            this.unitsID = unID;
        }
    }
}

