/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class OTDRProgressDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 24L;
    private MainClass mainClass;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private JProgressBar progressBar;
    private JButton button;

    public OTDRProgressDialog(MainClass mClass) {
        super(mClass.mainFrame);
        this.mainClass = mClass;
        this.setTitle(this.mainClass.getResourceString("OTDRMesaureProgressCaption"));
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(10, 10, 10, 10);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.gbLayout.setConstraints(this.progressBar, this.gbConstraints);
        this.add(this.progressBar);
        this.button = new JButton();
        this.button.addActionListener(this);
        this.button.setText(this.mainClass.getResourceString("cancel"));
        this.gbLayout.setConstraints(this.button, this.gbConstraints);
        this.add(this.button);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.mainClass.getTL1RTUClient().stopMeas();
        }
        super.setVisible(b);
    }

    public void setMinimum(int val) {
        this.progressBar.setMinimum(val);
    }

    public void setMaximum(int val) {
        this.progressBar.setMaximum(val);
    }

    public void setProgress(int val) {
        this.progressBar.setValue(val);
        String str = String.format("%3.0f%%", Float.valueOf(100.0f * (float)val / (float)this.progressBar.getMaximum()));
        this.progressBar.setString(str);
    }
}

