/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileSystemView;

public class OTDRSocket
implements OTDRIO {
    static final long serialVersionUID = 21L;
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int SO_TIMEOUT = 60000;
    public boolean inputConnectionParametersResult;
    private ConnectionParameters connectionParameters;
    private Socket socket;
    private byte[] buffer;
    private MainClass mainClass;
    private int buttonWidth;
    private JPanel dialogPane;

    public OTDRSocket(MainClass mClass) {
        this.mainClass = mClass;
        this.buffer = new byte[0x100000];
        this.connectionParameters = new ConnectionParameters();
        this.connectionParameters.host = null;
        this.connectionParameters.port = 0;
        this.inputConnectionParametersResult = false;
        this.inputConnectionParametersResult = this.inputParameters();
    }

    public OTDRSocket(MainClass mClass, String host, int port) {
        this(mClass);
        this.connectionParameters.host = host;
        this.connectionParameters.port = 0;
        this.inputConnectionParametersResult = true;
    }

    public boolean inputParameters() {
        boolean ret = false;
        OTDRSocketParametersDialog otdrSocketParametersDialog = null;
        otdrSocketParametersDialog = new OTDRSocketParametersDialog(this.mainClass.mainFrame);
        otdrSocketParametersDialog.setVisible(true);
        if (1 == otdrSocketParametersDialog.getResult()) {
            this.connectionParameters = otdrSocketParametersDialog.getConnectionParameters();
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean connect() {
        block4: {
            try {
                if (this.connectionParameters.host != null && this.connectionParameters.port != 0) break block4;
                return false;
            }
            catch (Exception e) {
                String tmpS = String.format(": %s\n", e.getMessage());
                tmpS = String.valueOf(this.mainClass.getResourceString("SOCKET_INIT_ERROR")) + tmpS;
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("CHECK_CONNECTION_PARAMETERS");
                System.out.println(tmpS);
                JOptionPane.showMessageDialog(this.mainClass.mainFrame, tmpS, "OTDR View", 0);
                return false;
            }
        }
        this.socket = new Socket();
        InetSocketAddress inetSA = new InetSocketAddress(this.connectionParameters.host, this.connectionParameters.port);
        int timeout = 1000;
        this.socket.connect(inetSA, timeout);
        this.socket.setSoTimeout(60000);
        if (this.socket.getTcpNoDelay()) {
            MainClass.QDEBUG("getTcpNoDelay ON", new Object[0]);
        }
        MainClass.QDEBUG("rBufferSize = %d, oBufferSize = %d\n", this.socket.getReceiveBufferSize(), this.socket.getSendBufferSize());
        return true;
    }

    @Override
    public void disconnect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            System.out.println("socket close error: " + e);
        }
    }

    @Override
    public void write(int b) throws OTDRIO.OTDRIOException {
        try {
            this.socket.getOutputStream().write(b);
        }
        catch (Exception e) {
            System.out.println("socket write error: " + e);
            throw new OTDRIO.OTDRIOException("Write fails");
        }
    }

    @Override
    public int read() throws OTDRIO.OTDRIOException {
        int r = -1;
        try {
            r = this.socket.getInputStream().read();
        }
        catch (Exception e) {
            System.out.println("socket read error: " + e);
            throw new OTDRIO.OTDRIOException("Read fails");
        }
        return r;
    }

    public int read1() {
        int r = -1;
        try {
            r = this.socket.getInputStream().read();
        }
        catch (Exception e) {
            System.out.println("socket read error: " + e);
        }
        return r;
    }

    @Override
    public void writeString(String s) {
        try {
            this.socket.getOutputStream().write(s.getBytes());
        }
        catch (Exception e) {
            System.out.println("socket write error: " + e);
        }
    }

    @Override
    public String readString() {
        String s = null;
        try {
            int r = this.socket.getInputStream().read(this.buffer);
            s = new String(this.buffer, 0, r);
        }
        catch (Exception e) {
            System.out.println("socket read error: " + e);
        }
        return s;
    }

    public class OTDRSocketParametersDialog
    extends JDialog
    implements ActionListener {
        static final int OK = 1;
        static final int CANCEL = 0;
        static final long serialVersionUID = 16L;
        static final String defaultHost = "192.168.1.252";
        static final int defaultPort = 24;
        private static final String connParFile = "connParFile.ser";
        ConnectionParameters connectionParameters;
        private GridBagLayout gbLayout;
        private GridBagConstraints gbConstraints;
        private JLabel hostLabel;
        private JLabel portLabel;
        private JTextField hostTextField;
        private JTextField portTextField;
        private JButton cancelButton;
        private JButton okButton;
        private JButton defaultButton;
        private int result;

        public OTDRSocketParametersDialog(Frame owner) {
            super(owner);
            this.result = 0;
            OTDRSocket.this.dialogPane = new JPanel();
            this.setContentPane(OTDRSocket.this.dialogPane);
            try {
                String defaultFolder = String.valueOf(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath()) + File.separator + OTDRSocket.this.mainClass.getResourceString("ourOwnFolderName");
                FileInputStream fi = new FileInputStream(String.valueOf(defaultFolder) + File.separator + connParFile);
                ObjectInputStream iis = new ObjectInputStream(fi);
                this.connectionParameters = (ConnectionParameters)iis.readObject();
            }
            catch (Exception e) {
                System.out.printf("can't deserialize connectionParameters:%s\n", e.getMessage());
                this.connectionParameters = new ConnectionParameters();
                this.setDefaultConnectionParameters();
            }
            this.setModal(true);
            this.setTitle(OTDRSocket.this.mainClass.getResourceString("OTDRSocketParametersDialogCaption"));
            this.setLocationRelativeTo(((OTDRSocket)OTDRSocket.this).mainClass.otdrWindow);
            this.setResizable(false);
            this.gbLayout = new GridBagLayout();
            this.setLayout(this.gbLayout);
            this.gbConstraints = new GridBagConstraints();
            this.gbConstraints.gridx = -1;
            this.gbConstraints.gridy = -1;
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridheight = 1;
            this.gbConstraints.fill = 2;
            this.gbConstraints.anchor = 11;
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 0.7;
            this.gbConstraints.ipadx = 0;
            this.gbConstraints.ipady = 0;
            this.gbConstraints.insets = new Insets(10, 10, 10, 10);
            this.hostLabel = new JLabel();
            this.hostLabel.setName("hostLabel");
            this.hostLabel.setText(OTDRSocket.this.mainClass.getResourceString("hostLabelText"));
            this.hostLabel.setHorizontalAlignment(4);
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.6;
            this.gbLayout.setConstraints(this.hostLabel, this.gbConstraints);
            this.add(this.hostLabel);
            this.hostTextField = new JTextField();
            this.hostTextField.setName("hostTextField");
            this.hostTextField.setEditable(true);
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.3;
            this.gbLayout.setConstraints(this.hostTextField, this.gbConstraints);
            this.add(this.hostTextField);
            this.portLabel = new JLabel();
            this.portLabel.setName("portLabel");
            this.portLabel.setText(OTDRSocket.this.mainClass.getResourceString("portLabelText"));
            this.portLabel.setHorizontalAlignment(4);
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.6;
            this.gbLayout.setConstraints(this.portLabel, this.gbConstraints);
            this.add(this.portLabel);
            this.portTextField = new JTextField();
            this.portTextField.setName("portTextField");
            this.portTextField.setEditable(true);
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.3;
            this.gbLayout.setConstraints(this.portTextField, this.gbConstraints);
            this.add(this.portTextField);
            this.okButton = new JButton();
            this.okButton.addActionListener(this);
            this.okButton.setText(OTDRSocket.this.mainClass.getResourceString("ok"));
            this.okButton.setName("okButton");
            this.gbConstraints.fill = 0;
            this.gbConstraints.anchor = 18;
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.5;
            this.gbLayout.setConstraints(this.okButton, this.gbConstraints);
            this.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.addActionListener(this);
            this.cancelButton.setText(OTDRSocket.this.mainClass.getResourceString("cancel"));
            this.cancelButton.setName("cancelButton");
            this.gbConstraints.fill = 0;
            this.gbConstraints.anchor = 12;
            this.gbConstraints.ipadx = 0;
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.5;
            this.gbLayout.setConstraints(this.cancelButton, this.gbConstraints);
            this.add(this.cancelButton);
            this.defaultButton = new JButton();
            this.defaultButton.addActionListener(this);
            this.defaultButton.setText(OTDRSocket.this.mainClass.getResourceString("default"));
            this.defaultButton.setName("defaultButton");
            this.gbConstraints.fill = 0;
            this.gbConstraints.anchor = 12;
            this.gbConstraints.ipadx = 0;
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.5;
            this.gbLayout.setConstraints(this.defaultButton, this.gbConstraints);
            this.add(this.defaultButton);
            this.updateView();
            OTDRSocket.this.dialogPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    OTDRSocketParametersDialog.this.reallocButtons();
                }
            });
            OTDRSocket.this.buttonWidth = 0;
        }

        public void setDefaultConnectionParameters() {
            this.connectionParameters.host = defaultHost;
            this.connectionParameters.port = 24;
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.result = 0;
                this.reallocButtons();
                this.updateView();
            }
            this.cancelButton.requestFocus();
            super.setVisible(b);
        }

        public void updateView() {
            this.hostTextField.setText(this.connectionParameters.host);
            String tmpS = String.format("%d", this.connectionParameters.port);
            this.portTextField.setText(tmpS);
            this.pack();
        }

        private void reallocButtons() {
            if (OTDRSocket.this.buttonWidth == 0) {
                Component comp;
                int maxWidth = 0;
                Component[] componentArray = OTDRSocket.this.dialogPane.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    comp = componentArray[n2];
                    if (comp instanceof JButton || comp instanceof JToggleButton) {
                        maxWidth = Math.max(maxWidth, comp.getWidth());
                    }
                    ++n2;
                }
                componentArray = OTDRSocket.this.dialogPane.getComponents();
                n = componentArray.length;
                n2 = 0;
                while (n2 < n) {
                    comp = componentArray[n2];
                    if (comp instanceof JButton || comp instanceof JToggleButton) {
                        GridBagConstraints tmpConstraints = this.gbLayout.getConstraints(comp);
                        tmpConstraints.ipadx = Math.max(0, maxWidth - comp.getWidth());
                        this.gbLayout.setConstraints(comp, tmpConstraints);
                    }
                    ++n2;
                }
                OTDRSocket.this.dialogPane.validate();
                OTDRSocket.this.buttonWidth = maxWidth;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.defaultButton) {
                this.setDefaultConnectionParameters();
                this.updateView();
            }
            if (src == this.cancelButton) {
                this.setVisible(false);
                this.connectionParameters.host = null;
                this.connectionParameters.port = 0;
            }
            if (src == this.okButton) {
                String defaultFolder = String.valueOf(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath()) + File.separator + OTDRSocket.this.mainClass.getResourceString("ourOwnFolderName");
                File ourFolder = new File(defaultFolder);
                if (!ourFolder.exists()) {
                    MainClass.QDEBUG("!ourFolder.exists, making...\n", new Object[0]);
                    ourFolder.mkdir();
                }
                MainClass.QDEBUG("defaultFolder = %s\n", defaultFolder);
                try {
                    this.connectionParameters.host = this.hostTextField.getText();
                    this.connectionParameters.port = (int)Long.parseLong(this.portTextField.getText());
                    FileOutputStream fo = new FileOutputStream(String.valueOf(defaultFolder) + File.separator + connParFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fo);
                    oos.writeObject(this.connectionParameters);
                    oos.flush();
                    this.result = 1;
                }
                catch (Exception exc) {
                    String tmpS = String.format(":\n%s", exc.getMessage());
                    tmpS = String.valueOf(OTDRSocket.this.mainClass.getResourceString("Error")) + tmpS;
                    JOptionPane.showMessageDialog(((OTDRSocket)OTDRSocket.this).mainClass.mainFrame, tmpS, "OTDR View", 0);
                    System.out.printf("Exception:%s\n", exc.getMessage());
                    this.connectionParameters.host = null;
                    this.connectionParameters.port = 0;
                }
                this.setVisible(false);
            }
        }

        public int getResult() {
            return this.result;
        }

        public ConnectionParameters getConnectionParameters() {
            return this.connectionParameters;
        }
    }
}

