/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OtdrControlPanel
extends JPanel {
    static final long serialVersionUID = 4L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private MainClass mainClass;
    public static final int MISC_PARAMETERS_NUMBER = 5;
    public static final int L_PARAMETER_INDEX = 0;
    public static final int R_PARAMETER_INDEX = 1;
    public static final int R_L_PARAMETER_INDEX = 2;
    public static final int DB_PARAMETER_INDEX = 3;
    public static final int DB_KM_PARAMETER_INDEX = 4;
    private JLabel[] labelMiscParameters;
    private JTextField[] textFieldMiscParameters;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private GridBagConstraints gbMapConstraints;
    private RfgMap rfgMap;
    private JList rfgList;
    private Vector<JCheckBox> checkboxes = new Vector();

    OtdrControlPanel(MainClass mClass) {
        this.mainClass = mClass;
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbMapConstraints = new GridBagConstraints();
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.insets = new Insets(0, 3, 0, 3);
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        this.labelMiscParameters = new JLabel[5];
        this.textFieldMiscParameters = new JTextField[5];
        int i = 0;
        while (i < 5) {
            this.gbConstraints.gridwidth = 1;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.4;
            this.labelMiscParameters[i] = new JLabel();
            this.labelMiscParameters[i].setText("");
            this.gbLayout.setConstraints(this.labelMiscParameters[i], this.gbConstraints);
            this.add(this.labelMiscParameters[i]);
            this.textFieldMiscParameters[i] = new JTextField();
            this.gbConstraints.gridwidth = 0;
            this.gbConstraints.gridx = -1;
            this.gbConstraints.weightx = 0.6;
            this.gbLayout.setConstraints(this.textFieldMiscParameters[i], this.gbConstraints);
            this.textFieldMiscParameters[i].setEditable(false);
            this.textFieldMiscParameters[i].setHorizontalAlignment(4);
            this.add(this.textFieldMiscParameters[i]);
            ++i;
        }
        this.rfgMap = new RfgMap(mClass);
        this.gbMapConstraints.anchor = 10;
        this.gbMapConstraints.fill = 1;
        this.gbMapConstraints.gridwidth = 0;
        this.gbMapConstraints.gridheight = 1;
        this.gbMapConstraints.gridx = -1;
        this.gbMapConstraints.gridy = -1;
        this.gbMapConstraints.weightx = 0.0;
        this.gbMapConstraints.weighty = 0.0;
        this.gbMapConstraints.ipadx = 0;
        this.gbMapConstraints.ipady = 0;
        this.gbMapConstraints.insets = new Insets(0, 3, 0, 3);
        this.gbLayout.setConstraints(this.rfgMap, this.gbMapConstraints);
        this.add(this.rfgMap);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.insets = new Insets(0, 3, 0, 3);
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        JLabel rfgListLabel = new JLabel();
        rfgListLabel.setHorizontalAlignment(0);
        rfgListLabel.setText(this.mainClass.getResourceString("RfgListLabelString"));
        this.gbLayout.setConstraints(rfgListLabel, this.gbConstraints);
        this.add(rfgListLabel);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 0;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.rfgList = new JList(new RfgListModel());
        this.rfgList.setSelectionMode(0);
        this.rfgList.setBackground(RfgView.COLOR_BACK);
        this.gbLayout.setConstraints(this.rfgList, this.gbConstraints);
        this.add(this.rfgList);
        this.setMiscParametersCaption(0, "L, " + this.mainClass.getResourceString("km"));
        this.setMiscParametersCaption(1, "R, " + this.mainClass.getResourceString("km"));
        this.setMiscParametersCaption(2, "R-L, " + this.mainClass.getResourceString("km"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = OtdrControlPanel.this.rfgMap.getWidth();
                int h = OtdrControlPanel.this.rfgMap.getHeight();
                super.componentResized(e);
                ((OtdrControlPanel)OtdrControlPanel.this).gbMapConstraints.ipady = Math.max(100, w - h);
                OtdrControlPanel.this.gbLayout.setConstraints(OtdrControlPanel.this.rfgMap, OtdrControlPanel.this.gbMapConstraints);
                OtdrControlPanel.this.validate();
                OtdrControlPanel.this.updateUI();
            }
        });
        this.rfgList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                Object source = e.getSource();
                if (source == OtdrControlPanel.this.rfgList && (index = OtdrControlPanel.this.rfgList.getSelectedIndex()) >= 0) {
                    if (OtdrControlPanel.this.mainClass.isTwoWayChecked()) {
                        OtdrControlPanel.this.mainClass.setTwoWayCurrentSorFileIndex(index);
                    } else {
                        OtdrControlPanel.this.mainClass.setCurrentSorFileIndex(index);
                    }
                }
            }
        });
        this.rfgList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                int index = OtdrControlPanel.this.rfgList.getSelectedIndex();
                if (index < 0 || index > OtdrControlPanel.this.mainClass.getSorFilesCount()) {
                    return;
                }
                Component comp = (Component)OtdrControlPanel.this.rfgList.getModel().getElementAt(index);
                if (!(comp instanceof JCheckBox)) {
                    return;
                }
                JCheckBox cb = (JCheckBox)comp;
                boolean isUpdateNeed = false;
                switch (keyCode) {
                    case 127: {
                        OtdrControlPanel.this.mainClass.closeSorFile(index);
                        isUpdateNeed = true;
                        break;
                    }
                    case 10: 
                    case 32: {
                        cb.doClick();
                        isUpdateNeed = true;
                    }
                }
                if (isUpdateNeed) {
                    OtdrControlPanel.this.mainClass.updateAll();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.rfgList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = OtdrControlPanel.this.rfgList.locationToIndex(e.getPoint());
                Component comp = (Component)OtdrControlPanel.this.rfgList.getModel().getElementAt(index);
                if (!(comp instanceof JCheckBox)) {
                    return;
                }
                JCheckBox cb = (JCheckBox)comp;
                if (cb.isEnabled() && (e.getX() < cb.getHorizontalTextPosition() || e.getClickCount() == 2)) {
                    cb.doClick();
                    OtdrControlPanel.this.mainClass.updateAll();
                }
            }
        });
        this.rfgList.setToolTipText(this.mainClass.getResourceString("rfgListToolTipText"));
        this.rfgList.setCellRenderer(new RfgListCellRenderer());
        this.checkboxes.removeAllElements();
        int i2 = 0;
        while (i2 < this.mainClass.getSorFilesCount()) {
            ((RfgListModel)this.rfgList.getModel()).addElement(i2);
            ++i2;
        }
    }

    public boolean isRfgChecked(int index) {
        Component comp = (Component)((RfgListModel)this.rfgList.getModel()).getElementAt(index);
        if (!(comp instanceof JCheckBox)) {
            return false;
        }
        JCheckBox cb = (JCheckBox)comp;
        return cb.isSelected();
    }

    public void setRfgChecked(int index, boolean checked) {
        Component comp = (Component)this.rfgList.getModel().getElementAt(index);
        if (!(comp instanceof JCheckBox)) {
            return;
        }
        JCheckBox cb = (JCheckBox)comp;
        cb.setSelected(checked);
        this.mainClass.updateTwoWayCheckMenuItem();
    }

    public void updateRfgList() {
        int i = 0;
        while (i < this.mainClass.getSorFilesCount()) {
            String tmpS = "";
            SorFile sorFile = this.mainClass.getSorFile(i);
            boolean enable = false;
            if (sorFile.isDataPtsPresent || sorFile.isKeyEventsPresent) {
                tmpS = sorFile.getFileName();
                enable = true;
            }
            this.checkboxes.get(i).setText(tmpS);
            this.checkboxes.get(i).setEnabled(enable);
            ++i;
        }
        this.rfgList.setSelectedIndex(this.mainClass.getCurrentSorFileIndex());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public void updateLeftCursor(float distance) {
        String tmpS = String.format("%.4f", Float.valueOf(distance));
        this.setMiscParametersValue(0, tmpS);
    }

    public void updateRightCursor(float distance) {
        String tmpS = String.format("%.4f", Float.valueOf(distance));
        this.setMiscParametersValue(1, tmpS);
    }

    public void updateRightToLeftCursor(float distance) {
        String tmpS = String.format("%.4f", Float.valueOf(distance));
        this.setMiscParametersValue(2, tmpS);
    }

    public void setMiscParametersCaption(int index, String caption) {
        if (index >= 0 && index < 5) {
            this.labelMiscParameters[index].setText(caption);
        }
    }

    public void setMiscParametersValue(int index, String value) {
        if (index >= 0 && index < 5) {
            this.textFieldMiscParameters[index].setText(value);
        }
    }

    public RfgMap getRfgMap() {
        return this.rfgMap;
    }

    class RfgListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        static final long serialVersionUID = 13L;

        RfgListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof JCheckBox)) {
                return this;
            }
            JCheckBox cb = (JCheckBox)value;
            cb.setComponentOrientation(list.getComponentOrientation());
            Color bg = null;
            Color fg = null;
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
                bg = UIManager.getColor("List.dropCellBackground");
                fg = UIManager.getColor("List.dropCellForeground");
                isSelected = true;
            }
            if (isSelected) {
                cb.setBackground(bg == null ? list.getSelectionBackground() : bg);
                cb.setForeground(fg == null ? list.getSelectionForeground() : fg);
            } else {
                cb.setBackground(list.getBackground());
                fg = RfgView.COLOR_RFG[index];
                cb.setForeground(fg);
            }
            SorFile sorFile = OtdrControlPanel.this.mainClass.getSorFile(index);
            if (sorFile.isDataPtsPresent || sorFile.isKeyEventsPresent) {
                String tmpS = sorFile.getFileName();
                if (index == OtdrControlPanel.this.mainClass.getReferenceSorFileIndex()) {
                    tmpS = String.valueOf(tmpS) + " *";
                }
                cb.setEnabled(true);
                cb.setText(tmpS);
            } else {
                cb.setEnabled(false);
                cb.setSelected(false);
                cb.setText("");
            }
            cb.setFont(list.getFont());
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = OtdrControlPanel.getNoFocusBorder();
            }
            cb.setBorder(border);
            return cb;
        }
    }

    class RfgListModel
    extends DefaultListModel {
        static final long serialVersionUID = 12L;

        RfgListModel() {
        }

        @Override
        public int getSize() {
            return OtdrControlPanel.this.mainClass.getSorFilesCount();
        }

        @Override
        public Object getElementAt(int index) {
            return OtdrControlPanel.this.checkboxes.get(index);
        }

        public void addElement(int index) {
            SorFile sorFile = OtdrControlPanel.this.mainClass.getSorFile(index);
            String sorFileString = "";
            boolean enable = false;
            if (sorFile.isDataPtsPresent || sorFile.isKeyEventsPresent) {
                sorFileString = sorFile.getFileName();
                enable = true;
            }
            JCheckBox cb = (JCheckBox)OtdrControlPanel.this.rfgList.add(new JCheckBox(sorFileString));
            cb.setEnabled(enable);
            OtdrControlPanel.this.checkboxes.addElement(cb);
        }
    }
}

