/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class OtdrEventsPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 7L;
    static final String[] eventColumnsDirect = new String[]{"eventType", "eventNumber", "eventDistance", "eventLoss", "eventReflectance", "eventAttenuationCoeff", "eventTotalLoss", "eventComment"};
    static final String[] eventColumnsTwoWay = new String[]{"eventNumber", "eventType", "eventNumber", "eventType", "eventDistance", "eventLoss", "eventLoss", "eventLossAverage", "eventAttenuationCoeff", "eventAttenuationCoeff", "eventAttenuationCoeffAverage"};
    public static final int COLUMN_EVENT_TYPE_DIRECT = 0;
    public static final int COLUMN_EVENT_NUMBER_DIRECT = 1;
    public static final int COLUMN_EVENT_DISTANCE_DIRECT = 2;
    public static final int COLUMN_EVENT_LOSS_DIRECT = 3;
    public static final int COLUMN_EVENT_REFLECTANCE_DIRECT = 4;
    public static final int COLUMN_EVENT_ATTENUATION_COEFF_DIRECT = 5;
    public static final int COLUMN_EVENT_TOTAL_LOSS_DIRECT = 6;
    public static final int COLUMN_EVENT_COMMENT_DIRECT = 7;
    public static final int COLUMN_EVENT_NUMBER1_TWO_WAY = 0;
    public static final int COLUMN_EVENT_TYPE1_TWO_WAY = 1;
    public static final int COLUMN_EVENT_NUMBER2_TWO_WAY = 2;
    public static final int COLUMN_EVENT_TYPE2_TWO_WAY = 3;
    public static final int COLUMN_EVENT_DISTANCE_TWO_WAY = 4;
    public static final int COLUMN_EVENT_LOSS1_TWO_WAY = 5;
    public static final int COLUMN_EVENT_LOSS2_TWO_WAY = 6;
    public static final int COLUMN_EVENT_LOSS_AVERAGE_TWO_WAY = 7;
    public static final int COLUMN_EVENT_ATTENUATION_COEFF1_TWO_WAY = 8;
    public static final int COLUMN_EVENT_ATTENUATION_COEFF2_TWO_WAY = 9;
    public static final int COLUMN_EVENT_ATTENUATION_COEFF_AVERAGE_TWO_WAY = 10;
    private MainClass mainClass;
    private JScrollPane eventsScrollPane;
    private JTable eventsTable;
    private JCheckBox checkBoxShowEvents;
    private JLabel labelTotalLoss;
    private JTextField textFieldTotalLoss;
    private JButton buttonDelete;
    private JLabel labelORL;
    private JTextField textFieldORL;
    private JButton buttonMarkers;
    private JButton buttonCancel;
    private JToggleButton buttonMove;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private int buttonsWidth;

    public OtdrEventsPanel(MainClass mClass) {
        this.mainClass = mClass;
        AbstractTableModel dataModel = new AbstractTableModel(){
            static final long serialVersionUID = 8L;

            @Override
            public int getColumnCount() {
                int ret = 0;
                ret = OtdrEventsPanel.this.mainClass.isTwoWayChecked() ? eventColumnsTwoWay.length : eventColumnsDirect.length;
                return ret;
            }

            @Override
            public int getRowCount() {
                short ret = 0;
                if (OtdrEventsPanel.this.mainClass.isTwoWayChecked()) {
                    ret = ((OtdrEventsPanel)OtdrEventsPanel.this).mainClass.getTwoWayKeyEvents().numberOfKeyEvents;
                } else {
                    int referenceSorFileIndex = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                    if (referenceSorFileIndex >= 0) {
                        ret = ((OtdrEventsPanel)OtdrEventsPanel.this).mainClass.getSorFile((int)referenceSorFileIndex).keyEvents.numberOfKeyEvents;
                    }
                }
                return ret;
            }

            @Override
            public String getColumnName(int column) {
                String ret = "";
                ret = OtdrEventsPanel.this.mainClass.isTwoWayChecked() ? OtdrEventsPanel.this.mainClass.getResourceString(eventColumnsTwoWay[column]) : OtdrEventsPanel.this.mainClass.getResourceString(eventColumnsDirect[column]);
                return ret;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                boolean ret = false;
                if (!OtdrEventsPanel.this.mainClass.isTwoWayChecked()) {
                    ret = 7 == col;
                }
                return ret;
            }

            @Override
            public Class<?> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public Object getValueAt(int row, int col) {
                Object ret;
                block49: {
                    int referenceSorFileIndex;
                    int eventIndex;
                    block48: {
                        ret = "";
                        eventIndex = row;
                        referenceSorFileIndex = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                        if (-1 == referenceSorFileIndex) {
                            return null;
                        }
                        if (!OtdrEventsPanel.this.mainClass.isTwoWayChecked()) break block48;
                        SorFile.KeyEvents twoWayKeyEvents = null;
                        twoWayKeyEvents = OtdrEventsPanel.this.mainClass.getTwoWayKeyEvents();
                        if (twoWayKeyEvents == null) {
                            return ret;
                        }
                        if (twoWayKeyEvents.numberOfKeyEvents - 1 < eventIndex) {
                            return ret;
                        }
                        SorFile sorFile = OtdrEventsPanel.this.mainClass.getSorFile(referenceSorFileIndex);
                        SorFile memSorFile = null;
                        int i = 0;
                        while (i < OtdrEventsPanel.this.mainClass.getSorFilesCount()) {
                            if (((OtdrEventsPanel)OtdrEventsPanel.this).mainClass.otdrControlPanel.isRfgChecked(i) && referenceSorFileIndex != i) {
                                memSorFile = OtdrEventsPanel.this.mainClass.getSorFile(i);
                                break;
                            }
                            ++i;
                        }
                        if (memSorFile == null) {
                            return ret;
                        }
                        int pulseTime1 = Math.round(sorFile.getIndexTime(sorFile.getIndexAfterPulse(true)));
                        int pulseTime2 = Math.round(memSorFile.getIndexTime(memSorFile.getIndexAfterPulse(true)));
                        SorFile.KeyEventsItem event1 = null;
                        try {
                            event1 = sorFile.keyEvents.getEventInNeighborhood(twoWayKeyEvents.events[eventIndex].eventPropagationTime, pulseTime1);
                        }
                        catch (Exception e) {
                            System.out.printf("OtdrEventsPanel: can't event1 = getEventInNeighborhood:%s\n", e.getMessage());
                        }
                        int endEventIndex = sorFile.keyEvents.numberOfKeyEvents - 1;
                        int endEventTime = sorFile.keyEvents.events[endEventIndex].eventPropagationTime;
                        int eventPropagationTime = endEventTime - twoWayKeyEvents.events[eventIndex].eventPropagationTime;
                        SorFile.KeyEventsItem event2 = null;
                        try {
                            event2 = memSorFile.keyEvents.getEventInNeighborhood(eventPropagationTime, pulseTime2);
                        }
                        catch (Exception e) {
                            System.out.printf("OtdrEventsPanel: can't event2 = getEventInNeighborhood:%s\n", e.getMessage());
                        }
                        switch (col) {
                            case 4: {
                                if (event1 != null) {
                                    int index = sorFile.getTimeIndex(event1.eventPropagationTime);
                                    float eventDistance = (float)sorFile.recalcDistance(index);
                                    ret = String.format("%.4f", Float.valueOf(eventDistance));
                                    break;
                                }
                                break block49;
                            }
                            case 1: {
                                ret = new ImageIcon();
                                if (event1 != null) {
                                    URL imageURL = event1.eventCode[1] == 69 || event1.eventCode[1] == 68 ? OtdrEventsPanel.this.mainClass.getResource("eventTableFiberEndImage") : (event1.eventCode[0] == 48 ? ((float)event1.eventLoss < 0.0f ? OtdrEventsPanel.this.mainClass.getResource("eventTableGainImage") : OtdrEventsPanel.this.mainClass.getResource("eventTableNonReflectImage")) : OtdrEventsPanel.this.mainClass.getResource("eventTableReflectImage"));
                                    if (imageURL != null) {
                                        ret = new ImageIcon(imageURL);
                                        break;
                                    }
                                }
                                break block49;
                            }
                            case 0: {
                                if (event1 != null) {
                                    ret = event1.eventNumber;
                                    break;
                                }
                                break block49;
                            }
                            case 5: {
                                if (event1 != null && event1.eventLoss != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)event1.eventLoss / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                            case 8: {
                                if (event1 != null && event1.attenuationCoefficientLeadInFiber != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)event1.attenuationCoefficientLeadInFiber / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                            case 3: {
                                ret = new ImageIcon();
                                if (event2 != null) {
                                    URL imageURL = event2.eventCode[1] == 69 || event2.eventCode[1] == 68 ? OtdrEventsPanel.this.mainClass.getResource("eventTableFiberEndImage") : (event2.eventCode[0] == 48 ? ((float)event2.eventLoss < 0.0f ? OtdrEventsPanel.this.mainClass.getResource("eventTableGainImage") : OtdrEventsPanel.this.mainClass.getResource("eventTableNonReflectImage")) : OtdrEventsPanel.this.mainClass.getResource("eventTableReflectImage"));
                                    if (imageURL != null) {
                                        ret = new ImageIcon(imageURL);
                                        break;
                                    }
                                }
                                break block49;
                            }
                            case 2: {
                                if (event2 != null) {
                                    ret = event2.eventNumber;
                                    break;
                                }
                                break block49;
                            }
                            case 6: {
                                if (event2 != null && event2.eventLoss != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)event2.eventLoss / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                            case 9: {
                                short attenuationCoefficientLeadInFiber;
                                int j;
                                if (event2 != null && (j = event2.eventNumber - 1) < memSorFile.keyEvents.numberOfKeyEvents - 1 && (attenuationCoefficientLeadInFiber = memSorFile.keyEvents.events[j + 1].attenuationCoefficientLeadInFiber) != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)attenuationCoefficientLeadInFiber / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                            case 7: {
                                if (twoWayKeyEvents.events[eventIndex].eventLoss != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)twoWayKeyEvents.events[eventIndex].eventLoss / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                            case 10: {
                                if (twoWayKeyEvents.events[eventIndex].attenuationCoefficientLeadInFiber != 0) {
                                    ret = String.format("%.3f", Float.valueOf((float)twoWayKeyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f));
                                    break;
                                }
                                break block49;
                            }
                        }
                        break block49;
                    }
                    SorFile sorFile = OtdrEventsPanel.this.mainClass.getSorFile(referenceSorFileIndex);
                    if (!sorFile.isKeyEventsPresent) {
                        return ret;
                    }
                    int index0 = sorFile.getIndexAfterPulse();
                    int index = sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].eventPropagationTime);
                    float eventDistance = (float)sorFile.recalcDistance(index);
                    switch (col) {
                        case 0: {
                            URL imageURL = sorFile.keyEvents.events[eventIndex].eventCode[1] == 69 || sorFile.keyEvents.events[eventIndex].eventCode[1] == 68 ? OtdrEventsPanel.this.mainClass.getResource("eventTableFiberEndImage") : (sorFile.keyEvents.events[eventIndex].eventCode[0] == 48 ? ((float)sorFile.keyEvents.events[eventIndex].eventLoss < 0.0f ? OtdrEventsPanel.this.mainClass.getResource("eventTableGainImage") : OtdrEventsPanel.this.mainClass.getResource("eventTableNonReflectImage")) : OtdrEventsPanel.this.mainClass.getResource("eventTableReflectImage"));
                            if (imageURL != null) {
                                ret = new ImageIcon(imageURL);
                                break;
                            }
                            ret = new ImageIcon();
                            break;
                        }
                        case 1: {
                            ret = sorFile.keyEvents.events[eventIndex].eventNumber;
                            break;
                        }
                        case 2: {
                            ret = String.format("%.4f", Float.valueOf(eventDistance));
                            break;
                        }
                        case 3: {
                            if (sorFile.keyEvents.events[eventIndex].eventLoss == 0) break;
                            ret = String.format("%.3f", Float.valueOf((float)sorFile.keyEvents.events[eventIndex].eventLoss / 1000.0f));
                            break;
                        }
                        case 4: {
                            if (sorFile.keyEvents.events[eventIndex].eventReflectance == 0) break;
                            ret = String.format("%.3f", Float.valueOf((float)sorFile.keyEvents.events[eventIndex].eventReflectance / 1000.0f));
                            break;
                        }
                        case 5: {
                            if (sorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber == 0) break;
                            ret = String.format("%.3f", Float.valueOf((float)sorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f));
                            break;
                        }
                        case 6: {
                            if (sorFile.dataPts.scaledData == null || !(eventDistance > 0.0f)) break;
                            ret = String.format("%.3f", Float.valueOf(sorFile.dataPts.scaledData[index] - sorFile.dataPts.scaledData[index0]));
                            break;
                        }
                        case 7: {
                            ret = sorFile.keyEvents.events[eventIndex].comment;
                            break;
                        }
                    }
                }
                return ret;
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                int eventIndex = row;
                if (!OtdrEventsPanel.this.mainClass.isTwoWayChecked()) {
                    int referenceSorFileIndex = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                    if (-1 == referenceSorFileIndex) {
                        return;
                    }
                    SorFile sorFile = OtdrEventsPanel.this.mainClass.getSorFile(referenceSorFileIndex);
                    if (sorFile.keyEvents.numberOfKeyEvents - 1 < eventIndex || !sorFile.isKeyEventsPresent) {
                        return;
                    }
                    if (7 == col) {
                        sorFile.keyEvents.events[eventIndex].comment = (String)aValue;
                    }
                }
            }
        };
        this.eventsTable = new JTable(dataModel){
            static final long serialVersionUID = 9L;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                int referenceSorFileIndex = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                if (-1 == referenceSorFileIndex) {
                    return;
                }
                SorFile sorFile = OtdrEventsPanel.this.mainClass.getSorFile(referenceSorFileIndex);
                RfgView rfgView = ((OtdrEventsPanel)OtdrEventsPanel.this).mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView();
                short eventIndex = (short)OtdrEventsPanel.this.getCurrentEventIndex();
                int dataIndex = sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].eventPropagationTime);
                float x = sorFile.getXStep() * (float)(dataIndex - sorFile.indexOffset);
                if (0.0f > x || (float)(rfgView.getWidth() - 1) < x) {
                    sorFile.indexOffset = dataIndex - Math.round((float)(rfgView.getWidth() / 2) / sorFile.getXStep());
                    rfgView.checkStartIndex();
                }
                rfgView.invalidateView();
                rfgView.updateUI();
                OtdrEventsPanel.this.checkButtonsEnable();
            }
        };
        class CustomTableCellRenderer
        extends DefaultTableCellRenderer {
            static final long serialVersionUID = 1L;

            CustomTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!OtdrEventsPanel.this.mainClass.isTwoWayChecked()) {
                    cell.setForeground(Color.black);
                } else if (column == 0 || 5 == column || 8 == column) {
                    int ri = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                    if (ri >= 0 && RfgView.COLOR_RFG.length > ri) {
                        Color color = new Color(RfgView.COLOR_RFG[ri].getRed() / 2, RfgView.COLOR_RFG[ri].getGreen() / 2, RfgView.COLOR_RFG[ri].getBlue() / 2);
                        cell.setForeground(color);
                    }
                } else if (2 == column || 6 == column || 9 == column) {
                    int ri = OtdrEventsPanel.this.mainClass.getReferenceSorFileIndex();
                    if (ri >= 0 && RfgView.COLOR_RFG.length > ri) {
                        int mi = -1;
                        int i = 0;
                        while (i < OtdrEventsPanel.this.mainClass.getSorFilesCount()) {
                            if (i != ri && ((OtdrEventsPanel)OtdrEventsPanel.this).mainClass.otdrControlPanel.isRfgChecked(i)) {
                                mi = i;
                                break;
                            }
                            ++i;
                        }
                        if (mi >= 0 && RfgView.COLOR_RFG.length > mi) {
                            Color color1 = new Color(RfgView.COLOR_RFG[mi].getRed() / 2, RfgView.COLOR_RFG[mi].getGreen() / 2, RfgView.COLOR_RFG[mi].getBlue() / 2);
                            cell.setForeground(color1);
                        }
                    }
                } else {
                    cell.setForeground(Color.black);
                }
                return cell;
            }
        }
        CustomTableCellRenderer renderer = new CustomTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        this.eventsTable.setDefaultRenderer(Short.class, renderer);
        this.eventsTable.setDefaultRenderer(String.class, renderer);
        if (this.mainClass.isTwoWayChecked()) {
            int i = 0;
            while (i < this.eventsTable.getColumnModel().getColumnCount()) {
                TableColumn col = this.eventsTable.getColumnModel().getColumn(i);
                if (i == 1 || i == 3 || i == 0 || i == 2) {
                    col.setPreferredWidth(16);
                } else {
                    try {
                        FontMetrics fm = this.eventsTable.getFontMetrics(this.eventsTable.getFont());
                        int width = fm.stringWidth(col.getHeaderValue().toString());
                        col.setPreferredWidth(width);
                    }
                    catch (Exception e) {
                        System.out.printf("error %s\n", e.getMessage());
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.eventsTable.getColumnModel().getColumnCount()) {
                TableColumn col = this.eventsTable.getColumnModel().getColumn(i);
                int prefferedWidth = 0;
                if (i == 0 || i == 1) {
                    prefferedWidth = 16;
                } else {
                    try {
                        FontMetrics fm = this.eventsTable.getFontMetrics(this.eventsTable.getFont());
                        prefferedWidth = fm.stringWidth(col.getHeaderValue().toString());
                    }
                    catch (Exception e) {
                        System.out.printf("error %s\n", e.getMessage());
                    }
                }
                col.setPreferredWidth(prefferedWidth);
                ++i;
            }
        }
        this.eventsTable.setRowHeight(20);
        this.eventsTable.setPreferredScrollableViewportSize(new Dimension(640, this.eventsTable.getRowHeight() * 6));
        this.eventsTable.setSelectionMode(0);
        this.eventsScrollPane = new JScrollPane(this.eventsTable);
        this.eventsScrollPane.setVerticalScrollBarPolicy(20);
        this.eventsScrollPane.setHorizontalScrollBarPolicy(30);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 1;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 0.7;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.eventsScrollPane, this.gbConstraints);
        this.add(this.eventsScrollPane);
        this.labelTotalLoss = new JLabel();
        this.labelTotalLoss.setText(this.mainClass.getResourceString("labelTotalLoss"));
        this.labelTotalLoss.setHorizontalAlignment(4);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.weightx = 0.6;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.labelTotalLoss, this.gbConstraints);
        this.add(this.labelTotalLoss);
        this.textFieldTotalLoss = new JTextField();
        this.textFieldTotalLoss.setEditable(false);
        this.textFieldTotalLoss.setHorizontalAlignment(4);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.weightx = 0.3;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.textFieldTotalLoss, this.gbConstraints);
        this.add(this.textFieldTotalLoss);
        this.buttonDelete = new JButton(this.mainClass.getResourceString("buttonDeleteEvent"));
        this.buttonDelete.addActionListener(this);
        this.buttonDelete.setName("buttonDelete");
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.weightx = 0.1;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbLayout.setConstraints(this.buttonDelete, this.gbConstraints);
        this.add(this.buttonDelete);
        this.labelORL = new JLabel();
        this.labelORL.setText(this.mainClass.getResourceString("labelORL"));
        this.labelORL.setHorizontalAlignment(4);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.weightx = 0.6;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.labelORL, this.gbConstraints);
        this.add(this.labelORL);
        this.textFieldORL = new JTextField();
        this.textFieldORL.setEditable(false);
        this.textFieldORL.setHorizontalAlignment(4);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.weightx = 0.3;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.textFieldORL, this.gbConstraints);
        this.add(this.textFieldORL);
        this.buttonMarkers = new JButton(this.mainClass.getResourceString("buttonMarkersEvent"));
        this.buttonMarkers.addActionListener(this);
        this.buttonMarkers.setName("buttonMarkers");
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.weightx = 0.1;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbLayout.setConstraints(this.buttonMarkers, this.gbConstraints);
        this.add(this.buttonMarkers);
        this.checkBoxShowEvents = new JCheckBox();
        this.checkBoxShowEvents.setText(this.mainClass.getResourceString("checkBoxShowEvents"));
        this.checkBoxShowEvents.setHorizontalAlignment(4);
        this.checkBoxShowEvents.setSelected(true);
        this.checkBoxShowEvents.addActionListener(this);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.gbLayout.setConstraints(this.checkBoxShowEvents, this.gbConstraints);
        this.add(this.checkBoxShowEvents);
        this.buttonCancel = new JButton(this.mainClass.getResourceString("cancel"));
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.setEnabled(false);
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.weightx = 0.1;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbLayout.setConstraints(this.buttonCancel, this.gbConstraints);
        this.add(this.buttonCancel);
        this.buttonMove = new JToggleButton(this.mainClass.getResourceString("buttonMoveEvent"));
        this.buttonMove.addActionListener(this);
        this.buttonMove.setName("buttonMove");
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.weightx = 0.1;
        this.gbConstraints.weighty = 0.1;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbLayout.setConstraints(this.buttonMove, this.gbConstraints);
        this.add(this.buttonMove);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (OtdrEventsPanel.this.buttonsWidth == 0) {
                    Component comp;
                    int maxWidth = 0;
                    Component[] componentArray = OtdrEventsPanel.this.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        comp = componentArray[n2];
                        if (!(comp instanceof JCheckBox) && (comp instanceof JButton || comp instanceof JToggleButton)) {
                            maxWidth = Math.max(maxWidth, comp.getWidth());
                        }
                        ++n2;
                    }
                    componentArray = OtdrEventsPanel.this.getComponents();
                    n = componentArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        comp = componentArray[n2];
                        if (!(comp instanceof JCheckBox) && (comp instanceof JButton || comp instanceof JToggleButton)) {
                            GridBagConstraints tmpConstraints = OtdrEventsPanel.this.gbLayout.getConstraints(comp);
                            tmpConstraints.ipadx = Math.max(0, maxWidth - comp.getWidth());
                            OtdrEventsPanel.this.gbLayout.setConstraints(comp, tmpConstraints);
                        }
                        ++n2;
                    }
                    OtdrEventsPanel.this.validate();
                    OtdrEventsPanel.this.updateUI();
                    OtdrEventsPanel.this.buttonsWidth = maxWidth;
                }
            }
        });
        this.buttonsWidth = 0;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.checkButtonsEnable();
        }
        super.setVisible(b);
    }

    private void showCursors(SorFile sorFile, RfgView rfgView, short eventIndex) {
        if (76 == sorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] && 83 == sorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[1]) {
            this.mainClass.setMeasureMode(MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS);
            sorFile.cursor[2].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[0]));
            sorFile.cursor[0].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[1]));
            sorFile.cursor[1].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[2]));
            sorFile.cursor[3].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[3]));
            sorFile.cursor[4].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[4]));
            sorFile.lsaLine[0] = sorFile.getLSALine(sorFile.cursor[2].getDataIndex(), sorFile.cursor[0].getDataIndex());
            sorFile.lsaLine[1] = sorFile.getLSALine(sorFile.cursor[3].getDataIndex(), sorFile.cursor[1].getDataIndex());
        } else {
            this.mainClass.setMeasureMode(MainClass.MeasureMode.MEASURE_MODE_2P_LOSS);
            sorFile.cursor[0].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[0]));
            sorFile.cursor[1].setDataIndex(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].markerLocations[1]));
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        boolean needUpdate = true;
        Object src = evt.getSource();
        RfgView rfgView = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView();
        if (src == this.checkBoxShowEvents) {
            rfgView.invalidateView();
            rfgView.updateUI();
            return;
        }
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        if (-1 == referenceSorFileIndex) {
            return;
        }
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        short eventIndex = (short)this.getCurrentEventIndex();
        if (eventIndex < 0) {
            return;
        }
        if (src == this.buttonDelete) {
            sorFile.keyEvents.deleteEvent(eventIndex);
            if (this.mainClass.isTwoWayChecked()) {
                this.mainClass.menuEventsTwoWayChanged();
                needUpdate = false;
            }
        } else if (src == this.buttonMarkers) {
            this.showCursors(sorFile, rfgView, eventIndex);
        } else if (src == this.buttonMove) {
            if (this.buttonMove.isSelected()) {
                this.showCursors(sorFile, rfgView, eventIndex);
                this.buttonMove.setText(this.mainClass.getResourceString("buttonFixEvent"));
                this.buttonCancel.setEnabled(true);
            } else {
                this.buttonMove.setText(this.mainClass.getResourceString("buttonMoveEvent"));
                sorFile.fixEvent(this.mainClass.getMeasureMode(), eventIndex);
                this.buttonCancel.setEnabled(false);
                if (this.mainClass.isTwoWayChecked()) {
                    this.mainClass.menuEventsTwoWayChanged();
                    needUpdate = false;
                }
            }
        } else if (src == this.buttonCancel) {
            this.showCursors(sorFile, rfgView, eventIndex);
            this.resetButtonMove();
        }
        if (needUpdate) {
            this.mainClass.updateOtdrControlPanel();
            rfgView.invalidateView();
            rfgView.updateUI();
            this.updateView();
        }
    }

    public void resetButtonMove() {
        if (this.buttonMove.isSelected()) {
            this.buttonMove.setSelected(false);
            this.buttonMove.setText(this.mainClass.getResourceString("buttonMoveEvent"));
            this.buttonCancel.setEnabled(false);
        }
    }

    public void setCurrentEventIndex(int eventIndex) {
        if (this.eventsTable.getRowCount() > 0 && eventIndex < this.eventsTable.getRowCount()) {
            this.eventsTable.setRowSelectionInterval(eventIndex, eventIndex);
        }
        this.checkButtonsEnable();
    }

    public int getCurrentEventIndex() {
        int ret = -1;
        if (this.eventsTable.getRowCount() > 0 && this.eventsTable.getSelectedRow() <= this.eventsTable.getRowCount() - 1) {
            ret = this.eventsTable.getSelectedRow();
        }
        return ret;
    }

    public JTable getEventsTable() {
        return this.eventsTable;
    }

    public void updateView() {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        if (-1 == referenceSorFileIndex) {
            return;
        }
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile.keyEvents != null) {
            String tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.keyEvents.endToEndLoss / 1000.0f));
            this.textFieldTotalLoss.setText(String.valueOf(tmpS) + this.mainClass.getResourceString("dB"));
            tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.keyEvents.opticalReturnLoss / 1000.0f));
            this.textFieldORL.setText(String.valueOf(tmpS) + this.mainClass.getResourceString("dB"));
        }
        this.eventsTable.updateUI();
        if (this.eventsTable.getRowCount() > 0 && (-1 == this.eventsTable.getSelectedRow() || this.eventsTable.getSelectedRow() > this.eventsTable.getRowCount() - 1)) {
            this.eventsTable.setRowSelectionInterval(0, 0);
        }
        this.checkButtonsEnable();
    }

    private void checkButtonsEnable() {
        boolean enable = true;
        if (this.buttonMove.isSelected()) {
            enable = false;
            this.mainClass.enableRFGControls(enable);
            this.eventsTable.setEnabled(enable);
            this.buttonDelete.setEnabled(enable);
            this.buttonMarkers.setEnabled(enable);
            this.buttonMove.setEnabled(true);
        } else {
            this.mainClass.enableRFGControls(true);
            this.eventsTable.setEnabled(enable);
            int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
            if (-1 == referenceSorFileIndex) {
                return;
            }
            SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
            short eventIndex = (short)this.getCurrentEventIndex();
            if (eventIndex < 0) {
                enable = false;
            } else {
                float distance = (float)sorFile.recalcDistance(sorFile.getTimeIndex(sorFile.keyEvents.events[eventIndex].eventPropagationTime));
                if (0.0f == distance) {
                    enable = false;
                }
            }
            this.buttonDelete.setEnabled(enable);
            this.buttonMarkers.setEnabled(enable);
            this.buttonMove.setEnabled(enable);
            if (!enable) {
                this.resetButtonMove();
            }
        }
    }

    public boolean isEventsOn() {
        return this.checkBoxShowEvents.isSelected();
    }
}

