/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RefractiveIndexDialog
extends JDialog
implements ActionListener,
ChangeListener {
    static final long serialVersionUID = 26L;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private MainClass mainClass;
    private JPanel dialogPane;
    private JLabel labelLeftCursor;
    private JTextField textFieldLeftCursor;
    private JLabel labelRightCursor;
    private JTextField textFieldRightCursor;
    private JLabel labelDistance;
    private JTextField textFieldDistance;
    private JLabel labelRI;
    private JSpinner spinnerRI;
    private JButton okButton;
    private JButton cancelButton;
    private int savedGroupIndex;

    RefractiveIndexDialog(Frame owner, MainClass mClass) {
        super(owner);
        Component comp;
        this.mainClass = mClass;
        this.dialogPane = new JPanel();
        this.setContentPane(this.dialogPane);
        this.setModal(true);
        this.setTitle(this.mainClass.getResourceString("SpecificationOfRefractiveIndex"));
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.setResizable(false);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 0.7;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 1;
        this.gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.labelLeftCursor = new JLabel();
        this.labelLeftCursor.setText("L, " + this.mainClass.getResourceString("km"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelLeftCursor, this.gbConstraints);
        this.add(this.labelLeftCursor);
        this.textFieldLeftCursor = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldLeftCursor, this.gbConstraints);
        this.textFieldLeftCursor.setEditable(false);
        this.textFieldLeftCursor.setHorizontalAlignment(4);
        this.add(this.textFieldLeftCursor);
        this.labelRightCursor = new JLabel();
        this.labelRightCursor.setText("R, " + this.mainClass.getResourceString("km"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelRightCursor, this.gbConstraints);
        this.add(this.labelRightCursor);
        this.textFieldRightCursor = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldRightCursor, this.gbConstraints);
        this.textFieldRightCursor.setEditable(false);
        this.textFieldRightCursor.setHorizontalAlignment(4);
        this.add(this.textFieldRightCursor);
        this.labelDistance = new JLabel();
        this.labelDistance.setText("R-L, " + this.mainClass.getResourceString("km"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelDistance, this.gbConstraints);
        this.add(this.labelDistance);
        this.textFieldDistance = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldDistance, this.gbConstraints);
        this.textFieldDistance.setEditable(false);
        this.textFieldDistance.setHorizontalAlignment(4);
        this.add(this.textFieldDistance);
        this.labelRI = new JLabel();
        this.labelRI.setText("n");
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelRI, this.gbConstraints);
        this.add(this.labelRI);
        SpinnerNumberModel sm = new SpinnerNumberModel(1.5, 1.0, 2.0, 1.0E-5);
        this.spinnerRI = new JSpinner(sm);
        this.spinnerRI.setEditor(new JSpinner.NumberEditor(this.spinnerRI, "#0.00000"));
        this.spinnerRI.addChangeListener(this);
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.spinnerRI, this.gbConstraints);
        this.add(this.spinnerRI);
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.okButton.setText(this.mainClass.getResourceString("ok"));
        this.okButton.setName("okButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.okButton, this.gbConstraints);
        this.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText(this.mainClass.getResourceString("cancel"));
        this.cancelButton.setName("cancelButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.cancelButton, this.gbConstraints);
        this.add(this.cancelButton);
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(this.getTitle()) + 50, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RefractiveIndexDialog.this.cancelActions();
            }
        });
        this.pack();
        int minButtonWidth = 0;
        Component[] componentArray = this.dialogPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            comp = componentArray[n2];
            if (comp instanceof JButton) {
                minButtonWidth = Math.max(minButtonWidth, comp.getWidth());
            }
            ++n2;
        }
        componentArray = this.dialogPane.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            comp = componentArray[n2];
            if (comp instanceof JButton) {
                GridBagConstraints tmpConstraints = this.gbLayout.getConstraints(comp);
                tmpConstraints.ipadx = Math.max(0, minButtonWidth - comp.getWidth());
                this.gbLayout.setConstraints(comp, tmpConstraints);
            }
            ++n2;
        }
        this.pack();
    }

    private void cancelActions() {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        sorFile.fxdParams.groupIndex = this.savedGroupIndex;
        this.setVisible(false);
        this.mainClass.updateOtdrControlPanel();
        this.mainClass.updateStatusBar();
        this.mainClass.otdrWindow.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (source instanceof JButton) {
            JButton button = (JButton)source;
            if ("okButton" == button.getName()) {
                this.setVisible(false);
                this.mainClass.updateOtdrControlPanel();
                this.mainClass.updateStatusBar();
                this.mainClass.otdrWindow.updateUI();
            } else if ("cancelButton" == button.getName()) {
                this.cancelActions();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof JSpinner) {
            this.updateView();
        }
    }

    public void updateView() {
        int rightCursor;
        int leftCursor;
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        double rI = Double.valueOf(this.spinnerRI.getValue().toString());
        sorFile.fxdParams.groupIndex = (int)Math.round(rI *= 100000.0);
        if (sorFile.cursor[1].getDataIndex() > sorFile.cursor[0].getDataIndex()) {
            leftCursor = sorFile.cursor[0].getDataIndex();
            rightCursor = sorFile.cursor[1].getDataIndex();
        } else {
            rightCursor = sorFile.cursor[0].getDataIndex();
            leftCursor = sorFile.cursor[1].getDataIndex();
        }
        float distanceL = (float)sorFile.recalcDistance(leftCursor);
        String tmpS = String.format("%.4f", Float.valueOf(distanceL));
        this.textFieldLeftCursor.setText(tmpS);
        float distanceR = (float)sorFile.recalcDistance(rightCursor);
        tmpS = String.format("%.4f", Float.valueOf(distanceR));
        this.textFieldRightCursor.setText(tmpS);
        float distance = Math.abs(distanceR - distanceL);
        tmpS = String.format("%.4f", Float.valueOf(distance));
        this.textFieldDistance.setText(tmpS);
    }

    @Override
    public void setVisible(boolean visible) {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (visible) {
            this.savedGroupIndex = sorFile.fxdParams.groupIndex;
            this.spinnerRI.setValue((double)sorFile.fxdParams.groupIndex / 100000.0);
            this.updateView();
        }
        super.setVisible(visible);
    }
}

