/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class RfgInformationDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 12L;
    private JTabbedPane tabbedPane;
    private JButton cancelButton;
    private JButton okButton;
    private MainClass mainClass;
    private JPanel buttonPanel;
    private int buttonsWidth;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private static final TabItem[] tiDescription = new TabItem[]{new TabItem("DescriptionDateTime", "JTextField", false), new TabItem("DescriptionCableID", "JTextField", true), new TabItem("DescriptionFiberID", "JTextField", true), new TabItem("DescriptionFiberType", "JComboBox", true), new TabItem("DescriptionOriginatingLocation", "JTextField", true), new TabItem("DescriptionTerminatingLocation", "JTextField", true), new TabItem("DescriptionCondition", "JComboBox", true), new TabItem("DescriptionTraceType", "JComboBox", true), new TabItem("DescriptionOperator", "JTextField", true), new TabItem("DescriptionComment", "JTextField", true)};
    private static final TabItem[] tiInstrument = new TabItem[]{new TabItem("InstrumentSupplierName", "JTextField", false), new TabItem("InstrumentOTDRMainframeID", "JTextField", false), new TabItem("InstrumentOTDRMainframeSN", "JTextField", false), new TabItem("InstrumentOpticalModuleID", "JTextField", false), new TabItem("InstrumentOpticalModuleSN", "JTextField", false), new TabItem("InstrumentSoftwareRevision", "JTextField", false), new TabItem("InstrumentOther", "JTextField", false)};
    private static final TabParams[] tabParams = new TabParams[]{new TabParams("Description", tiDescription), new TabParams("Instrument", tiInstrument)};

    public RfgInformationDialog(Frame owner, MainClass mClass) {
        super(owner);
        this.mainClass = mClass;
        this.setModal(true);
        this.setTitle(this.mainClass.getResourceString("Rfg_information"));
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.setResizable(false);
        this.tabbedPane = new JTabbedPane();
        this.gbLayout = new GridBagLayout();
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(2, 2, 1, 1);
        int i = 0;
        while (i < tabParams.length) {
            JPanel tPanel = new JPanel();
            tPanel.setLayout(this.gbLayout);
            tPanel.setName(RfgInformationDialog.tabParams[i].tabNameIDString);
            this.tabbedPane.add(this.mainClass.getResourceString(RfgInformationDialog.tabParams[i].tabNameIDString), tPanel);
            int j = 0;
            while (j < RfgInformationDialog.tabParams[i].tabItems.length) {
                JLabel tmpLabel = new JLabel();
                tmpLabel.setName(RfgInformationDialog.tabParams[i].tabItems[j].tabInitStringID);
                tmpLabel.setText(this.mainClass.getResourceString(RfgInformationDialog.tabParams[i].tabItems[j].tabInitStringID));
                tmpLabel.setHorizontalAlignment(4);
                this.gbConstraints.gridwidth = 1;
                this.gbConstraints.gridx = -1;
                this.gbConstraints.weightx = 0.6;
                this.gbLayout.setConstraints(tmpLabel, this.gbConstraints);
                tPanel.add(tmpLabel);
                this.gbConstraints.gridwidth = 0;
                this.gbConstraints.gridx = -1;
                this.gbConstraints.weightx = 0.4;
                if ("JTextField" == RfgInformationDialog.tabParams[i].tabItems[j].className) {
                    JTextField tmpTextField = new JTextField();
                    tmpTextField.setName(RfgInformationDialog.tabParams[i].tabItems[j].tabInitStringID);
                    tmpTextField.setEditable(RfgInformationDialog.tabParams[i].tabItems[j].isEditable);
                    tmpTextField.setText("value");
                    this.gbLayout.setConstraints(tmpTextField, this.gbConstraints);
                    tPanel.add(tmpTextField);
                } else if ("JComboBox" == RfgInformationDialog.tabParams[i].tabItems[j].className) {
                    JComboBox<String> tmpComboBox = new JComboBox<String>();
                    tmpComboBox.setName(RfgInformationDialog.tabParams[i].tabItems[j].tabInitStringID);
                    tmpComboBox.setEnabled(RfgInformationDialog.tabParams[i].tabItems[j].isEditable);
                    tmpComboBox.setEditable(false);
                    String cbItems = this.mainClass.getResourceString(String.valueOf(RfgInformationDialog.tabParams[i].tabItems[j].tabInitStringID) + "Items");
                    if (cbItems != null) {
                        String[] cbItemsArray = cbItems.split("/");
                        int l = 0;
                        while (l < cbItemsArray.length) {
                            tmpComboBox.addItem(cbItemsArray[l]);
                            ++l;
                        }
                    }
                    this.gbLayout.setConstraints(tmpComboBox, this.gbConstraints);
                    tPanel.add(tmpComboBox);
                }
                ++j;
            }
            ++i;
        }
        this.buttonPanel = new JPanel();
        GridLayout gLt = new GridLayout();
        gLt.setColumns(2);
        gLt.setRows(1);
        this.buttonPanel.setLayout(gLt);
        this.buttonPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RfgInformationDialog.this.reallocButtons();
            }
        });
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.okButton.setText(this.mainClass.getResourceString("ok"));
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText(this.mainClass.getResourceString("cancel"));
        this.buttonPanel.add(this.cancelButton);
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.pack();
        this.buttonsWidth = 0;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cancelButton) {
            this.update(true);
            this.setVisible(false);
        } else if (source == this.okButton) {
            this.update(false);
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean b) {
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (b) {
            this.setTitle(String.valueOf(this.mainClass.getResourceString("Rfg_information")) + " - " + sorFile.getFileName());
            this.reallocButtons();
            this.update(true);
        }
        super.setVisible(b);
    }

    public void update(boolean isComponents) {
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        int tabIndex = 0;
        while (tabIndex < this.tabbedPane.getComponentCount()) {
            Component cTab = this.tabbedPane.getComponent(tabIndex);
            if (cTab instanceof JPanel) {
                JPanel tPanel = (JPanel)cTab;
                Component[] componentArray = tPanel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component comp = componentArray[n2];
                    if (comp instanceof JTextField) {
                        JTextField tmpTextField = (JTextField)comp;
                        String tmpS = tmpTextField.getName();
                        tmpS = isComponents ? tmpTextField.getName() : tmpTextField.getText();
                        if ("DescriptionDateTime" == tmpTextField.getName()) {
                            if (isComponents) {
                                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy\tHH:mm:ss");
                                Date date = new Date(sorFile.fxdParams.dateTimeStamp * 1000L);
                                tmpS = formatter.format(date);
                            }
                        } else if ("DescriptionCableID" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.cableID;
                            } else {
                                sorFile.genParams.cableID = tmpS;
                            }
                        } else if ("DescriptionFiberID" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.fiberID;
                            } else {
                                sorFile.genParams.fiberID = tmpS;
                            }
                        } else if ("DescriptionOriginatingLocation" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.originatingLocation;
                            } else {
                                sorFile.genParams.originatingLocation = tmpS;
                            }
                        } else if ("DescriptionTerminatingLocation" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.terminatingLocation;
                            } else {
                                sorFile.genParams.terminatingLocation = tmpS;
                            }
                        } else if ("DescriptionOperator" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.operatorCode;
                            } else {
                                sorFile.genParams.operatorCode = tmpS;
                            }
                        } else if ("DescriptionComment" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.genParams.comment;
                            } else {
                                sorFile.genParams.comment = tmpS;
                            }
                        } else if ("InstrumentSupplierName" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.supplierName;
                            } else {
                                sorFile.supParams.supplierName = tmpS;
                            }
                        } else if ("InstrumentOTDRMainframeID" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.otdrMainFrameID;
                            } else {
                                sorFile.supParams.otdrMainFrameID = tmpS;
                            }
                        } else if ("InstrumentOTDRMainframeSN" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.otdrMainFrameSN;
                            } else {
                                sorFile.supParams.otdrMainFrameSN = tmpS;
                            }
                        } else if ("InstrumentOpticalModuleID" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.opticalModuleID;
                            } else {
                                sorFile.supParams.opticalModuleID = tmpS;
                            }
                        } else if ("InstrumentOpticalModuleSN" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.opticalModuleSN;
                            } else {
                                sorFile.supParams.opticalModuleSN = tmpS;
                            }
                        } else if ("InstrumentSoftwareRevision" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.softwareRevision;
                            } else {
                                sorFile.supParams.softwareRevision = tmpS;
                            }
                        } else if ("InstrumentOther" == tmpTextField.getName()) {
                            if (isComponents) {
                                tmpS = sorFile.supParams.other;
                            } else {
                                sorFile.supParams.other = tmpS;
                            }
                        }
                        if (isComponents) {
                            tmpTextField.setText(tmpS);
                        }
                    } else if (comp instanceof JComboBox) {
                        JComboBox tmpComboBox = (JComboBox)comp;
                        int anIndex = 0;
                        if (!isComponents) {
                            anIndex = tmpComboBox.getSelectedIndex();
                        }
                        if (-1 != anIndex) {
                            if ("DescriptionFiberType" == tmpComboBox.getName()) {
                                if (isComponents) {
                                    switch (sorFile.genParams.fiberType) {
                                        case 651: {
                                            anIndex = 0;
                                            break;
                                        }
                                        case 653: {
                                            anIndex = 2;
                                            break;
                                        }
                                        case 655: {
                                            anIndex = 3;
                                            break;
                                        }
                                        default: {
                                            anIndex = 1;
                                            break;
                                        }
                                    }
                                } else {
                                    switch (anIndex) {
                                        case 0: {
                                            sorFile.genParams.fiberType = (short)651;
                                            break;
                                        }
                                        case 2: {
                                            sorFile.genParams.fiberType = (short)653;
                                            break;
                                        }
                                        case 3: {
                                            sorFile.genParams.fiberType = (short)655;
                                            break;
                                        }
                                        default: {
                                            sorFile.genParams.fiberType = (short)652;
                                            break;
                                        }
                                    }
                                }
                            } else if ("DescriptionCondition" == tmpComboBox.getName()) {
                                if (isComponents) {
                                    anIndex = 66 == sorFile.genParams.currentDataFlag[0] && 67 == sorFile.genParams.currentDataFlag[1] ? 0 : (82 == sorFile.genParams.currentDataFlag[0] && 67 == sorFile.genParams.currentDataFlag[1] ? 1 : 2);
                                } else {
                                    switch (anIndex) {
                                        case 0: {
                                            sorFile.genParams.currentDataFlag[0] = 66;
                                            sorFile.genParams.currentDataFlag[1] = 67;
                                            break;
                                        }
                                        case 1: {
                                            sorFile.genParams.currentDataFlag[0] = 82;
                                            sorFile.genParams.currentDataFlag[1] = 67;
                                            break;
                                        }
                                        default: {
                                            sorFile.genParams.currentDataFlag[0] = 79;
                                            sorFile.genParams.currentDataFlag[1] = 84;
                                            break;
                                        }
                                    }
                                }
                            } else if ("DescriptionTraceType" == tmpComboBox.getName()) {
                                if (isComponents) {
                                    if (83 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
                                        anIndex = 0;
                                    } else if (82 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
                                        anIndex = 1;
                                    } else if (68 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
                                        anIndex = 2;
                                    } else if (82 == sorFile.fxdParams.traceType[0] && 70 == sorFile.fxdParams.traceType[1]) {
                                        anIndex = 3;
                                    }
                                } else {
                                    switch (anIndex) {
                                        case 0: {
                                            sorFile.fxdParams.traceType[0] = 83;
                                            sorFile.fxdParams.traceType[1] = 84;
                                            break;
                                        }
                                        case 1: {
                                            sorFile.fxdParams.traceType[0] = 82;
                                            sorFile.fxdParams.traceType[1] = 84;
                                            break;
                                        }
                                        case 2: {
                                            sorFile.fxdParams.traceType[0] = 68;
                                            sorFile.fxdParams.traceType[1] = 84;
                                            break;
                                        }
                                        case 3: {
                                            sorFile.fxdParams.traceType[0] = 82;
                                            sorFile.fxdParams.traceType[1] = 70;
                                            break;
                                        }
                                        default: {
                                            sorFile.fxdParams.traceType[0] = 83;
                                            sorFile.fxdParams.traceType[1] = 84;
                                        }
                                    }
                                }
                            }
                            if (isComponents) {
                                tmpComboBox.setSelectedIndex(anIndex);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++tabIndex;
        }
    }

    private void reallocButtons() {
        LayoutManager buttonLayout = this.buttonPanel.getLayout();
        int nComps = this.buttonPanel.getComponentCount();
        if (nComps > 0 && buttonLayout instanceof GridLayout) {
            if (this.cancelButton.getGraphics() != null && this.buttonsWidth == 0) {
                this.buttonsWidth = Math.max(2 * this.cancelButton.getGraphics().getFontMetrics().stringWidth(this.cancelButton.getText()), 2 * this.okButton.getGraphics().getFontMetrics().stringWidth(this.okButton.getText()));
            }
            GridLayout gLt = (GridLayout)buttonLayout;
            int hGap = Math.max(0, this.buttonPanel.getWidth() - nComps * this.buttonsWidth);
            gLt.setHgap(hGap);
        }
        this.buttonPanel.validate();
        this.buttonPanel.updateUI();
    }

    public static class TabItem {
        public String tabInitStringID;
        public String className;
        public boolean isEditable;

        public TabItem(String sID, String cName, boolean editable) {
            this.tabInitStringID = sID;
            this.className = cName;
            this.isEditable = editable;
        }
    }

    public static class TabParams {
        public String tabNameIDString;
        public TabItem[] tabItems;

        public TabParams(String tNameIDString, TabItem[] tItems) {
            this.tabNameIDString = tNameIDString;
            this.tabItems = tItems;
        }
    }
}

