/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import javax.swing.JPanel;

public class RfgMap
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 6L;
    private MainClass mainClass;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float xStep;
    private float yStep;

    RfgMap(MainClass mClass) {
        this.mainClass = mClass;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void changeRfgPos(MouseEvent e) {
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        float rfgViewWidth = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getWidth();
        float rfgViewHeight = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getHeight();
        Rectangle rect = this.getVisibleRect();
        float mouseX = e.getX();
        float mouseY = e.getY();
        sorFile.indexOffset = Math.round((mouseX -= (this.x2 - this.x1) / 2.0f) / this.xStep);
        sorFile.yOffset = Math.round((mouseY -= (this.y2 - this.y1) / 2.0f) * rfgViewHeight / (float)rect.height * Float.valueOf(this.mainClass.yScale).floatValue());
        int maxStartIndex = sorFile.dataPts.numberOfDataPoints - Math.round(rfgViewWidth / sorFile.getXStep());
        if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
            sorFile.indexOffset = sorFile.positiveDistanceIndex;
        }
        if (sorFile.indexOffset > maxStartIndex) {
            sorFile.indexOffset = maxStartIndex;
        }
        if (sorFile.yOffset < 0) {
            sorFile.yOffset = 0;
        }
        if (sorFile.yOffset > sorFile.maxYOffset) {
            sorFile.yOffset = sorFile.maxYOffset;
        }
        this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().invalidateView();
        this.mainClass.otdrWindow.getRfgBackGroundPanel().updateUI();
        this.mainClass.updateScrolls();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 0) {
            this.changeRfgPos(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 0) {
            this.changeRfgPos(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void drawRfgPosition(Graphics g, SorFile sorFile, PageFormat pf) {
        Rectangle rect;
        int y0;
        int x0;
        float rfgViewHeight;
        float rfgViewWidth;
        if (sorFile == null) {
            return;
        }
        Rectangle rfgViewRect = g.getClipBounds();
        if (pf != null && rfgViewRect != null) {
            rfgViewWidth = rfgViewRect.width;
            rfgViewHeight = rfgViewRect.height;
            int width = 3 * rfgViewRect.width / 10;
            int height = 3 * rfgViewRect.height / 10;
            x0 = rfgViewRect.x + rfgViewRect.width - width;
            y0 = rfgViewRect.y + 1;
            rect = new Rectangle(x0, y0, width, height);
        } else {
            x0 = 0;
            y0 = 0;
            rfgViewWidth = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getWidth();
            rfgViewHeight = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getHeight();
            rect = this.getVisibleRect();
        }
        float localYOffset = (float)sorFile.yOffset * rfgViewHeight / (float)this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getHeight();
        this.x1 = (float)sorFile.indexOffset * this.xStep;
        this.x2 = this.x1 + (rfgViewWidth - 1.0f) / sorFile.getXStep() * this.xStep;
        this.y1 = localYOffset / Float.valueOf(this.mainClass.yScale).floatValue() * ((float)rect.height / rfgViewHeight);
        this.y2 = this.y1 + (float)(rect.height - 1) / Float.valueOf(this.mainClass.yScale).floatValue();
        if (pf == null) {
            g.setColor(RfgView.COLOR_RFG_POSITION);
        } else {
            g.setColor(Color.BLACK);
        }
        g.drawRect(x0 + Math.round(this.x1), y0 + Math.round(this.y1), Math.round(this.x2 - this.x1), Math.round(this.y2 - this.y1));
    }

    public void updateView(Graphics g1, PageFormat pf) {
        int y0;
        int x0;
        int height;
        int width;
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        boolean isDataPresent = true;
        if (sorFile == null) {
            isDataPresent = false;
        } else if (sorFile.dataPts.scaledData == null) {
            isDataPresent = false;
        } else if (!sorFile.isDataPtsPresent) {
            isDataPresent = false;
        }
        Graphics g = g1 == null ? super.getGraphics() : g1;
        Rectangle rect = g.getClipBounds();
        if (pf != null && rect != null) {
            width = 3 * rect.width / 10;
            height = 3 * rect.height / 10;
            x0 = rect.x + rect.width - width;
            y0 = rect.y + 1;
        } else {
            width = this.getWidth();
            height = this.getHeight();
            x0 = 0;
            y0 = 0;
            if (isDataPresent) {
                sorFile.recalcXYSteps(this.mainClass, this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getWidth(), this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().getHeight(), sorFile);
            }
        }
        Image memImage = this.createImage(width, height);
        Graphics2D memGraphics2 = (Graphics2D)memImage.getGraphics();
        if (pf == null) {
            memGraphics2.setColor(RfgView.COLOR_BACK);
        } else {
            memGraphics2.setColor(Color.WHITE);
        }
        memGraphics2.fillRect(0, 0, width, height);
        if (isDataPresent) {
            this.yStep = (float)(height - 1) / Math.abs(sorFile.dataPts.maxData - sorFile.dataPts.minData);
            this.xStep = (float)width / (float)sorFile.dataPts.numberOfDataPoints;
            float old_x = 0.0f;
            float old_y = 0.0f;
            float x = this.xStep * 0.0f;
            float y = (sorFile.dataPts.scaledData[0] - sorFile.dataPts.minData) * this.yStep;
            memGraphics2.setColor(RfgView.COLOR_RFG[this.mainClass.getReferenceSorFileIndex()]);
            int i = 1;
            while (i < sorFile.dataPts.numberOfDataPoints) {
                old_x = x;
                old_y = y;
                x = this.xStep * (float)i;
                y = (sorFile.dataPts.scaledData[i] - sorFile.dataPts.minData) * this.yStep;
                memGraphics2.drawLine((int)old_x, (int)old_y, (int)x, (int)y);
                ++i;
            }
        }
        g.drawImage(memImage, x0 + 0, y0 + 0, RfgView.COLOR_BACK, null);
        this.drawRfgPosition(g, sorFile, pf);
        if (pf != null) {
            g.setColor(RfgView.COLOR_GRID);
            g.drawRect(x0 - 1, y0 - 1, width + 1, height + 1);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateView(g, null);
    }
}

