/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class RfgView
extends JPanel
implements Printable,
MouseListener,
MouseMotionListener,
KeyListener {
    static final long serialVersionUID = 2L;
    static final int EVENT_BOTTOM_OFFSET = 6;
    static final int RFG_GRID_N_X_LINES = 10;
    static final int RFG_GRID_N_Y_LINES = 10;
    static final Color COLOR_BACK = new Color(0, 0, 0);
    static final Color[] COLOR_RFG = new Color[]{Color.GREEN, Color.RED, Color.BLUE, Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.GRAY, Color.LIGHT_GRAY, new Color(55, 128, 200)};
    static final Color COLOR_GRID = new Color(128, 128, 128);
    static final Color COLOR_ZOOMING_RECT = Color.YELLOW;
    static final Color COLOR_CURSORS = new Color(255, 255, 255);
    static final Color COLOR_LSA_LINE = Color.YELLOW;
    static final Color COLOR_2P_LINE = Color.CYAN;
    static final Color COLOR_LSA_SPECTRUM = new Color(64, 178, 255);
    static final Color COLOR_EVENTS = Color.YELLOW;
    static final Color COLOR_RFG_POSITION = Color.YELLOW;
    static final Color COLOR_CUR_EVENT = Color.RED;
    private OtdrWindow.RfgBackGroundPanel rfgBackGroundPanel;
    private boolean isZoomMode = false;
    private int zoomX0;
    private int zoomY0;
    private int zoomX1;
    private int zoomY1;
    private Image memImage = null;
    private Graphics2D memGraphics2 = null;
    private final String[] reportParametersID = new String[]{"File", "Instrument", "SerialNumber", "Date", "Cable", "Fiber", "Fiber_type", "Line_begin", "Line_end", "Condition", "Trace_type", "Operator", "Comment", "Wave_length", "Refraction_index", "Range", "Resolution", "Pulse_width", "Backscatter_coefficient", "Loss_threshold", "Reflectance_threshold", "End_of_fiber_threshold", "EndToEndLoss", "LineORL"};
    private String[] reportValues;
    private final String[] eventsTableHeaderStringsDirect = new String[]{"type", "number", "distance", "loss", "reflectance", "attenuation", "full", "comment"};
    private final String[] eventsTableHeaderUnitsDirect = new String[]{"", "", "km", "dB", "dB", "dBPerKm", "dB", ""};
    private final String[] eventsTableHeaderStringsTwoWay = new String[]{"number", "type", "number", "type", "distance", "loss", "loss", "lossAverage", "attenuation", "attenuation", "attenuationAverage"};
    private final String[] eventsTableHeaderUnitsTwoWay = new String[]{"", "", "", "", "km", "dB", "dB", "dB", "dBPerKm", "dBPerKm", "dBPerKm"};
    private int printEventIndex = 0;
    private int previousStartEventIndex = 0;
    private int oldPageIndex = -1;
    static final int EVENT_MARKER_HEIGHT = 16;
    static final int EVENT_MARKER_WIDTH = 8;
    private MainClass mainClass = null;

    public RfgView(MainClass mClass, OtdrWindow.RfgBackGroundPanel rfgBackGroundP) {
        this.mainClass = mClass;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.rfgBackGroundPanel = rfgBackGroundP;
        this.addComponentListener(new ComponentAdapter(){
            private int savedComponentHeight = 1;

            @Override
            public void componentResized(ComponentEvent e) {
                int oldHeight = this.savedComponentHeight;
                this.savedComponentHeight = RfgView.this.getHeight();
                SorFile sorFile = RfgView.this.mainClass.getSorFile(RfgView.this.mainClass.getReferenceSorFileIndex());
                if (sorFile == null) {
                    return;
                }
                if (sorFile.dataPts == null) {
                    return;
                }
                if (!sorFile.isDataPtsPresent) {
                    return;
                }
                int oldYOffset = sorFile.yOffset;
                sorFile.yOffset = oldYOffset * RfgView.this.getHeight() / oldHeight;
                sorFile.recalcXYSteps(RfgView.this.mainClass, RfgView.this.getWidth(), RfgView.this.getHeight(), sorFile);
                int maxStartIndex = sorFile.dataPts.numberOfDataPoints - Math.round((float)RfgView.this.getHeight() / sorFile.getXStep());
                if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
                    sorFile.indexOffset = sorFile.positiveDistanceIndex;
                }
                if (sorFile.indexOffset > maxStartIndex) {
                    sorFile.indexOffset = maxStartIndex;
                }
                sorFile.maxYOffset = Math.round((float)RfgView.this.getHeight() * (Float.valueOf(((RfgView)RfgView.this).mainClass.yScale).floatValue() - 1.0f));
                if (sorFile.yOffset < 0) {
                    sorFile.yOffset = 0;
                }
                if (sorFile.yOffset > sorFile.maxYOffset) {
                    sorFile.yOffset = sorFile.maxYOffset;
                }
                RfgView.this.invalidateView();
                RfgView.this.updateUI();
                RfgView.this.rfgBackGroundPanel.updateUI();
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        if (this.mainClass.isZoomMode()) {
            this.isZoomMode = true;
            this.zoomX0 = e.getX();
            this.zoomY0 = e.getY();
            return;
        }
        int nearestCursorIndex = -1;
        float nearestCursorX = 2.1474836E9f;
        float mouseX = e.getX();
        int i = 0;
        while (i < sorFile.cursor.length) {
            if (sorFile.cursor[i].isShown()) {
                float cursorX = sorFile.getXStep() * (float)sorFile.cursor[i].getDataIndex() - sorFile.getXStep() * (float)sorFile.indexOffset;
                if (Math.abs(mouseX - cursorX) < Math.abs(mouseX - nearestCursorX)) {
                    nearestCursorX = cursorX;
                    nearestCursorIndex = i;
                }
                if (sorFile.cursor[i].getState() == 1) {
                    sorFile.cursor[i].setState(2);
                    sorFile.activeCursor = i;
                    this.setCursor(new Cursor(1));
                    this.updateUI();
                    break;
                }
            }
            ++i;
        }
        if (i == sorFile.cursor.length) {
            int dataIndex = Math.round(mouseX / sorFile.getXStep() + (float)sorFile.indexOffset);
            if (-1 != nearestCursorIndex) {
                sorFile.activeCursor = nearestCursorIndex;
            }
            if (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS != this.mainClass.getMeasureMode()) {
                if ((e.getModifiersEx() & 0x400) != 0) {
                    sorFile.activeCursor = 0;
                } else if ((e.getModifiersEx() & 0x1000) != 0) {
                    sorFile.activeCursor = 1;
                }
            }
            sorFile.setActiveCursorWithRangeControl(dataIndex, this.mainClass.getMeasureMode());
            sorFile.cursor[sorFile.activeCursor].setState(2);
            if (this.mainClass != null) {
                this.mainClass.updateOtdrControlPanel();
            }
            this.updateUI();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        this.setCursor(new Cursor(0));
        if (this.isZoomMode) {
            this.isZoomMode = false;
            this.mainClass.setZoomMode(false);
            this.zoomX1 = e.getX();
            this.zoomY1 = e.getY();
            this.zoom();
            return;
        }
        int i = 0;
        while (i < sorFile.cursor.length) {
            sorFile.cursor[i].setState(0);
            ++i;
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        if (this.isZoomMode) {
            this.zoomX1 = e.getX();
            this.zoomY1 = e.getY();
            this.updateUI();
            return;
        }
        float mouseX = e.getX();
        float cursorX = mouseX;
        int dataIndex = Math.round(cursorX / sorFile.getXStep() + (float)sorFile.indexOffset);
        if (dataIndex < 0) {
            dataIndex = 0;
        }
        if (dataIndex > sorFile.dataPts.numberOfDataPoints - 1) {
            dataIndex = sorFile.dataPts.numberOfDataPoints - 1;
        }
        int i = 0;
        while (i < sorFile.cursor.length) {
            if (sorFile.cursor[i].isShown() && sorFile.cursor[i].getState() == 2) {
                sorFile.setActiveCursorWithRangeControl(dataIndex, this.mainClass.getMeasureMode());
                this.updateUI();
                if (this.mainClass == null) break;
                this.mainClass.updateOtdrControlPanel();
                break;
            }
            ++i;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        float mouseX = e.getX();
        int i = 0;
        while (i < sorFile.cursor.length) {
            sorFile.cursor[i].setState(0);
            ++i;
        }
        if (!this.mainClass.isZoomMode()) {
            i = 0;
            while (i < sorFile.cursor.length) {
                float cursorX;
                if (sorFile.cursor[i].isShown() && Math.abs((cursorX = sorFile.getXStep() * (float)sorFile.cursor[i].getDataIndex() - sorFile.getXStep() * (float)sorFile.indexOffset) - mouseX) <= 5.0f) {
                    this.setCursor(new Cursor(10));
                    sorFile.cursor[i].setState(1);
                    break;
                }
                ++i;
            }
        }
        if (i == sorFile.cursor.length) {
            this.setCursor(new Cursor(0));
        }
    }

    private void debugKeyPressed(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        int offset = Math.round(sorFile.getPointWeight());
        if (offset == 0) {
            offset = 1;
        }
        switch (e.getKeyCode()) {
            case 10: {
                sorFile.changeActiveCursor();
                int x0 = 0;
                int x1 = this.getWidth() - 1;
                int aCursorX = Math.round(sorFile.getXStep() * (float)(sorFile.cursor[sorFile.activeCursor].getDataIndex() - sorFile.indexOffset));
                if (aCursorX < x0 || aCursorX > x1) {
                    sorFile.indexOffset = sorFile.cursor[sorFile.activeCursor].getDataIndex() - Math.round((float)(this.getWidth() / 2) / sorFile.getXStep());
                    this.checkStartIndex();
                }
                this.invalidateView();
                this.updateUI();
                if (this.mainClass == null) break;
                this.mainClass.updateOtdrControlPanel();
                break;
            }
            case 37: {
                sorFile.moveActiveCursor(-offset, this.mainClass.getMeasureMode());
                this.updateUI();
                if (this.mainClass == null) break;
                this.mainClass.updateOtdrControlPanel();
                break;
            }
            case 39: {
                sorFile.moveActiveCursor(offset, this.mainClass.getMeasureMode());
                this.updateUI();
                if (this.mainClass == null) break;
                this.mainClass.updateOtdrControlPanel();
                break;
            }
            default: {
                this.debugKeyPressed(e);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public SorFile getSorFile(int index) {
        if (this.mainClass != null) {
            return this.mainClass.getSorFile(index);
        }
        return null;
    }

    public void invalidateView() {
        this.memImage = null;
        this.memGraphics2 = null;
    }

    private void prepareReportStrings() {
        int anIndex;
        SorFile sorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        this.reportValues = new String[this.reportParametersID.length];
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy\tHH:mm:ss");
        Date date = new Date(sorFile.fxdParams.dateTimeStamp * 1000L);
        int valIndex = 0;
        this.reportValues[valIndex++] = sorFile.getFileName();
        this.reportValues[valIndex++] = sorFile.supParams.otdrMainFrameID;
        this.reportValues[valIndex++] = sorFile.supParams.otdrMainFrameSN;
        this.reportValues[valIndex++] = formatter.format(date);
        this.reportValues[valIndex++] = sorFile.genParams.cableID;
        this.reportValues[valIndex++] = sorFile.genParams.fiberID;
        switch (sorFile.genParams.fiberType) {
            case 651: {
                anIndex = 0;
                break;
            }
            case 653: {
                anIndex = 2;
                break;
            }
            case 655: {
                anIndex = 3;
                break;
            }
            default: {
                anIndex = 1;
            }
        }
        String tmpS = this.mainClass.getResourceString("DescriptionFiberTypeItems");
        String[] tmpStringArray = tmpS.split("/");
        this.reportValues[valIndex++] = tmpStringArray[anIndex];
        this.reportValues[valIndex++] = sorFile.genParams.originatingLocation;
        this.reportValues[valIndex++] = sorFile.genParams.terminatingLocation;
        anIndex = 66 == sorFile.genParams.currentDataFlag[0] && 67 == sorFile.genParams.currentDataFlag[1] ? 0 : (82 == sorFile.genParams.currentDataFlag[0] && 67 == sorFile.genParams.currentDataFlag[1] ? 1 : 2);
        tmpS = this.mainClass.getResourceString("DescriptionConditionItems");
        tmpStringArray = tmpS.split("/");
        this.reportValues[valIndex++] = tmpStringArray[anIndex];
        if (83 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
            anIndex = 0;
        } else if (82 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
            anIndex = 1;
        } else if (68 == sorFile.fxdParams.traceType[0] && 84 == sorFile.fxdParams.traceType[1]) {
            anIndex = 2;
        } else if (82 == sorFile.fxdParams.traceType[0] && 70 == sorFile.fxdParams.traceType[1]) {
            anIndex = 3;
        }
        tmpS = this.mainClass.getResourceString("DescriptionTraceTypeItems");
        tmpStringArray = tmpS.split("/");
        this.reportValues[valIndex++] = tmpStringArray[anIndex];
        this.reportValues[valIndex++] = sorFile.genParams.operatorCode;
        this.reportValues[valIndex++] = sorFile.genParams.comment;
        tmpS = String.valueOf(String.format("%d ", sorFile.genParams.nominalWaveLength)) + this.mainClass.getResourceString("nm");
        this.reportValues[valIndex++] = tmpS;
        this.reportValues[valIndex++] = String.format("%.5f", Float.valueOf((float)sorFile.fxdParams.groupIndex / 100000.0f));
        float lMax = (long)sorFile.fxdParams.acquisitionRangeDistance != 0L ? (float)sorFile.fxdParams.acquisitionRangeDistance / 10.0f * sorFile.fxdParams.distanceMultiplier : (float)sorFile.recalcDistance(sorFile.getTimeIndex(sorFile.fxdParams.acquisitionRange));
        tmpS = lMax > 5.0f ? String.format("%.0f ", Float.valueOf(lMax)) : String.format("%1.1f ", Float.valueOf(lMax));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("km");
        this.reportValues[valIndex++] = tmpS;
        float dL = 1000.0f * (float)sorFile.recalcDistance(0, sorFile.getTimeIndex(sorFile.fxdParams.dataSpacing[0] / 10000));
        tmpS = dL < 1.0f ? String.format("%.2f ", Float.valueOf(dL)) : String.format("%.1f ", Float.valueOf(dL));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("m");
        this.reportValues[valIndex++] = tmpS;
        short pulseWidth = sorFile.fxdParams.pulseWidthsUsed[0];
        tmpS = String.format("%d ", pulseWidth);
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("ns");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.fxdParams.backscatterCoefficient / 10.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.fxdParams.lossThreshold / 1000.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.fxdParams.reflectanceThreshold / -1000.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.fxdParams.endOfFiberThreshold / 1000.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.keyEvents.endToEndLoss / 1000.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
        tmpS = String.format("%.3f ", Float.valueOf((float)sorFile.keyEvents.opticalReturnLoss / 1000.0f));
        tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
        this.reportValues[valIndex++] = tmpS;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int ret;
        block100: {
            int index;
            boolean drawEvents = false;
            ret = 0;
            SorFile mainSorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
            if (this.oldPageIndex == pageIndex) {
                this.printEventIndex = this.previousStartEventIndex;
            } else {
                this.previousStartEventIndex = this.printEventIndex;
            }
            if (mainSorFile == null) {
                this.oldPageIndex = -1;
                return 1;
            }
            if (this.printEventIndex > mainSorFile.keyEvents.numberOfKeyEvents - 1 && pageIndex > 0) {
                this.oldPageIndex = -1;
                return 1;
            }
            g.setColor(Color.GRAY);
            String colontileString = this.mainClass.getResourceString("printingColontileString");
            Font fnt = new Font("Arial Cyr", 0, 6);
            g.setFont(fnt);
            FontMetrics fm = g.getFontMetrics();
            Rectangle originalBoundsRect = g.getClipBounds();
            Rectangle rect = g.getClipBounds();
            int x = originalBoundsRect.x;
            int y = originalBoundsRect.y + originalBoundsRect.height - 1;
            g.drawString(colontileString, x, y);
            g.setColor(Color.BLACK);
            fnt = new Font("Arial Cyr", 0, 8);
            g.setFont(fnt);
            fm = g.getFontMetrics();
            String tmpS = String.format("%d", pageIndex + 1);
            x = (int)Math.round((double)(originalBoundsRect.x + originalBoundsRect.width) - fm.getStringBounds(tmpS, g).getWidth());
            y = originalBoundsRect.y + originalBoundsRect.height;
            g.drawString(tmpS, x, y);
            int xOffset = 0;
            int yOffset = 0;
            int bottomPageLimit = y - fm.getHeight();
            originalBoundsRect.setBounds(originalBoundsRect.x, originalBoundsRect.y, originalBoundsRect.width, originalBoundsRect.height - fm.getHeight());
            if (pageIndex == 0) {
                g.setColor(Color.BLACK);
                ret = 0;
                this.printEventIndex = 0;
                this.previousStartEventIndex = 0;
                rect = g.getClipBounds();
                if (rect != null) {
                    this.prepareReportStrings();
                    tmpS = this.mainClass.getResourceString("Report");
                    tmpS = "OTDR " + tmpS;
                    fnt = new Font("Arial Cyr", 1, 16);
                    g.setFont(fnt);
                    fm = g.getFontMetrics();
                    x = (int)((double)(rect.x + rect.width / 2) - fm.getStringBounds(tmpS, g).getWidth() / 2.0);
                    y = rect.y + fm.getHeight();
                    g.drawString(tmpS, x, y);
                    yOffset += fm.getHeight() * 2;
                    xOffset = 0;
                    int nCols = 2;
                    int linesPerCol = this.reportParametersID.length / nCols;
                    int lineIndex = 0;
                    int dX = (rect.width - xOffset) / nCols;
                    int[] maxX = new int[nCols];
                    int[] leftX = new int[nCols];
                    int columnNumber = 0;
                    maxX[columnNumber] = 0;
                    int topYOffset = yOffset;
                    int maxYOffset = yOffset;
                    fnt = new Font("Arial Cyr", 1, 8);
                    g.setFont(fnt);
                    fm = g.getFontMetrics();
                    index = 0;
                    while (index < this.reportParametersID.length) {
                        tmpS = this.mainClass.getResourceString(this.reportParametersID[index]);
                        x = rect.x + xOffset;
                        y = rect.y + yOffset + fm.getHeight();
                        g.drawString(tmpS, x, y);
                        leftX[columnNumber] = x;
                        maxX[columnNumber] = (int)Math.max((double)x + fm.getStringBounds(tmpS, g).getWidth(), (double)maxX[columnNumber]);
                        yOffset = (int)((double)yOffset + (double)fm.getHeight() * 1.2);
                        if (columnNumber < nCols - 1 && ++lineIndex >= linesPerCol) {
                            yOffset = topYOffset;
                            xOffset += dX;
                            lineIndex = 0;
                            maxX[++columnNumber] = 0;
                        }
                        maxYOffset = Math.max(maxYOffset, yOffset);
                        ++index;
                    }
                    fnt = new Font("Arial Cyr", 0, 8);
                    g.setFont(fnt);
                    fm = g.getFontMetrics();
                    lineIndex = 0;
                    columnNumber = 0;
                    yOffset = topYOffset;
                    Shape oldShape = g.getClip();
                    g.setClip(rect.x, rect.y, leftX[columnNumber + 1] - rect.x - fm.stringWidth(" "), rect.height);
                    index = 0;
                    while (index < this.reportParametersID.length) {
                        tmpS = " : " + this.reportValues[index];
                        x = maxX[columnNumber];
                        y = rect.y + yOffset + fm.getHeight();
                        g.drawString(tmpS, x, y);
                        yOffset = (int)((double)yOffset + (double)fm.getHeight() * 1.2);
                        if (columnNumber < nCols - 1 && ++lineIndex >= linesPerCol) {
                            yOffset = topYOffset;
                            lineIndex = 0;
                            if (++columnNumber < nCols - 1) {
                                g.setClip(rect.x, rect.y, leftX[columnNumber + 1] - rect.x - fm.stringWidth(" "), rect.height);
                            } else {
                                g.setClip(oldShape);
                            }
                        }
                        ++index;
                    }
                    g.setClip(oldShape);
                    yOffset = maxYOffset + 2 * fm.getHeight();
                    rect.y += yOffset;
                    rect.setBounds(rect.x, rect.y, rect.width, rect.height / 2);
                    g.setClip(rect.x, rect.y, rect.width, rect.height);
                    rect.setBounds(rect.x + 45, rect.y, rect.width - 45, rect.height - 20);
                    this.mainClass.otdrWindow.getRfgBackGroundPanel().drawScale(g, pf, rect);
                    g.setClip(rect.x, rect.y, rect.width, rect.height);
                    this.drawGrid((Graphics2D)g);
                    int sorFileIndex = 0;
                    while (sorFileIndex < this.mainClass.getSorFilesCount()) {
                        if (this.mainClass.getReferenceSorFileIndex() != sorFileIndex) {
                            SorFile sorFile = this.getSorFile(sorFileIndex);
                            if (this.mainClass.otdrControlPanel.isRfgChecked(sorFileIndex) && (sorFile.isDataPtsPresent || sorFile.isKeyEventsPresent)) {
                                this.drawRfg(g, sorFileIndex, pf);
                            }
                        }
                        ++sorFileIndex;
                    }
                    this.drawRfg(g, this.mainClass.getReferenceSorFileIndex(), pf);
                    this.drawKeyEvents((Graphics2D)g, pf);
                    this.drawCursors((Graphics2D)g, pf);
                    if (!(this.mainClass.isTwoWayChecked() || this.mainClass.getXScaleIndex() <= 0 && this.mainClass.getYScaleIndex() <= 0)) {
                        this.mainClass.otdrControlPanel.getRfgMap().updateView(g, pf);
                    }
                    if (mainSorFile.keyEvents.numberOfKeyEvents > 0) {
                        drawEvents = true;
                    }
                }
            } else if (this.printEventIndex < mainSorFile.keyEvents.numberOfKeyEvents) {
                drawEvents = true;
            } else {
                drawEvents = false;
                this.oldPageIndex = -1;
                ret = 1;
            }
            if (!drawEvents) break block100;
            g.setColor(Color.BLACK);
            yOffset = 0;
            if (pageIndex == 0) {
                rect.setBounds(originalBoundsRect.x, rect.y + rect.height + 20, originalBoundsRect.width, bottomPageLimit - (rect.y + rect.height + 20));
            } else {
                rect.setBounds(originalBoundsRect.x, originalBoundsRect.y, originalBoundsRect.width, originalBoundsRect.height);
            }
            g.setClip(rect.x, rect.y, rect.width, rect.height);
            fnt = new Font("Arial Cyr", 2, 12);
            g.setFont(fnt);
            fm = g.getFontMetrics();
            tmpS = this.mainClass.getResourceString("Events_table");
            if (this.printEventIndex > 0) {
                tmpS = String.valueOf(tmpS) + " (" + this.mainClass.getResourceString("continuation") + ")";
            }
            if (rect.y + 4 * fm.getHeight() >= bottomPageLimit) {
                return 0;
            }
            x = rect.x;
            y = rect.y + 2 * fm.getHeight();
            g.drawString(tmpS, x, y);
            yOffset = (int)((double)yOffset + (double)fm.getHeight() * 2.2);
            fnt = new Font("Arial Cyr", 1, 10);
            g.setFont(fnt);
            fm = g.getFontMetrics();
            int x1 = xOffset;
            int x2 = xOffset;
            int y1 = yOffset;
            int y2 = yOffset;
            xOffset = 0;
            String[] eventsTableHeaderStrings = null;
            String[] eventsTableHeaderUnits = null;
            if (this.mainClass.isTwoWayChecked()) {
                eventsTableHeaderStrings = this.eventsTableHeaderStringsTwoWay;
                eventsTableHeaderUnits = this.eventsTableHeaderUnitsTwoWay;
            } else {
                eventsTableHeaderStrings = this.eventsTableHeaderStringsDirect;
                eventsTableHeaderUnits = this.eventsTableHeaderUnitsDirect;
            }
            int minCellWidth = (int)Math.max(fm.getStringBounds("99999", g).getWidth(), (double)(rect.width / eventsTableHeaderStrings.length / 2));
            int[] columnsRightX = new int[eventsTableHeaderStrings.length];
            index = 0;
            while (index < eventsTableHeaderStrings.length) {
                tmpS = this.mainClass.getResourceString(eventsTableHeaderStrings[index]);
                int strWidth = (int)Math.round(fm.getStringBounds(tmpS, g).getWidth());
                int cellWidth = index == eventsTableHeaderStrings.length - 1 && eventsTableHeaderStrings != this.eventsTableHeaderStringsTwoWay ? rect.width - xOffset : (int)Math.round(Math.max(fm.getStringBounds(tmpS, g).getWidth() * 1.1, (double)minCellWidth));
                x = rect.x + xOffset + (cellWidth - strWidth) / 2;
                y = rect.y + yOffset + fm.getHeight();
                g.drawString(tmpS, x, y);
                tmpS = this.mainClass.getResourceString(eventsTableHeaderUnits[index]);
                if ("" != tmpS) {
                    tmpS = "(" + tmpS + ")";
                    strWidth = (int)Math.round(fm.getStringBounds(tmpS, g).getWidth());
                    x = rect.x + xOffset + (cellWidth - strWidth) / 2;
                    g.drawString(tmpS, x, y += fm.getHeight());
                }
                x1 = rect.x + xOffset;
                x2 = x1 + cellWidth;
                y2 = y1 = rect.y + yOffset;
                y2 = (int)((double)y2 + (double)fm.getHeight() * 2.4);
                Color oldColor = g.getColor();
                g.setColor(Color.GRAY);
                g.drawRect(x1, y1, x2 - x1, y2 - y1);
                g.setColor(oldColor);
                columnsRightX[index] = x2;
                xOffset += cellWidth;
                ++index;
            }
            fnt = new Font("Arial Cyr", 0, 8);
            g.setFont(fnt);
            fm = g.getFontMetrics();
            yOffset = y2 - rect.y;
            xOffset = 0;
            boolean isBreak = false;
            MainClass.QDEBUG("pageIndex = %d, printEventIndex = %d\n", pageIndex, this.printEventIndex);
            int cellWidth = 0;
            int cellHeight = (int)Math.round((double)fm.getHeight() * 1.2);
            SorFile memSorFile = null;
            SorFile.KeyEvents twoWayKeyEvents = null;
            Color color1 = Color.BLACK;
            Color color2 = Color.BLACK;
            short numberOfKeyEvents = mainSorFile.keyEvents.numberOfKeyEvents;
            if (this.mainClass.isTwoWayChecked()) {
                int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
                color1 = new Color(COLOR_RFG[referenceSorFileIndex].getRed() / 2, COLOR_RFG[referenceSorFileIndex].getGreen() / 2, COLOR_RFG[referenceSorFileIndex].getBlue() / 2);
                int i = 0;
                while (i < this.mainClass.getSorFilesCount()) {
                    if (this.mainClass.otdrControlPanel.isRfgChecked(i) && referenceSorFileIndex != i) {
                        memSorFile = this.mainClass.getSorFile(i);
                        color2 = new Color(COLOR_RFG[i].getRed() / 2, COLOR_RFG[i].getGreen() / 2, COLOR_RFG[i].getBlue() / 2);
                        break;
                    }
                    ++i;
                }
                if (memSorFile == null) {
                    return ret;
                }
                twoWayKeyEvents = this.mainClass.getTwoWayKeyEvents();
                if (twoWayKeyEvents == null) {
                    return ret;
                }
                numberOfKeyEvents = twoWayKeyEvents.numberOfKeyEvents;
            }
            int eventIndex = this.printEventIndex;
            while (eventIndex < numberOfKeyEvents) {
                index = 0;
                while (index < eventsTableHeaderStrings.length) {
                    ImageIcon tmpImage;
                    block102: {
                        float eventDistance;
                        int timeIndex;
                        int index0;
                        block101: {
                            index0 = mainSorFile.getIndexAfterPulse();
                            timeIndex = mainSorFile.getTimeIndex(mainSorFile.keyEvents.events[eventIndex].eventPropagationTime);
                            eventDistance = (float)mainSorFile.recalcDistance(timeIndex);
                            tmpImage = null;
                            if (!this.mainClass.isTwoWayChecked()) break block101;
                            if (twoWayKeyEvents.numberOfKeyEvents - 1 < eventIndex) {
                                return ret;
                            }
                            int pulseTime1 = Math.round(mainSorFile.getIndexTime(mainSorFile.getIndexAfterPulse(true)));
                            int pulseTime2 = Math.round(memSorFile.getIndexTime(memSorFile.getIndexAfterPulse(true)));
                            SorFile.KeyEventsItem event1 = null;
                            SorFile.KeyEventsItem event2 = null;
                            try {
                                event1 = mainSorFile.keyEvents.getEventInNeighborhood(twoWayKeyEvents.events[eventIndex].eventPropagationTime, pulseTime1);
                            }
                            catch (Exception e) {
                                System.out.printf("Printing: can't event1 = getEventInNeighborhood:%s\n", e.getMessage());
                            }
                            int endEventIndex = mainSorFile.keyEvents.numberOfKeyEvents - 1;
                            int endEventTime = mainSorFile.keyEvents.events[endEventIndex].eventPropagationTime;
                            int eventPropagationTime = endEventTime - twoWayKeyEvents.events[eventIndex].eventPropagationTime;
                            try {
                                event2 = memSorFile.keyEvents.getEventInNeighborhood(eventPropagationTime, pulseTime2);
                            }
                            catch (Exception e) {
                                System.out.printf("Printing: can't event2 = getEventInNeighborhood:%s\n", e.getMessage());
                            }
                            tmpS = "";
                            g.setColor(Color.BLACK);
                            switch (index) {
                                case 0: {
                                    if (event1 != null) {
                                        tmpS = String.format("%d", event1.eventNumber);
                                        g.setColor(color1);
                                        break;
                                    }
                                    break block102;
                                }
                                case 1: {
                                    if (event1 != null) {
                                        URL imageURL;
                                        if (event1.eventCode[1] == 69 || event1.eventCode[1] == 68) {
                                            tmpS = "FE";
                                            imageURL = this.mainClass.getResource("eventTableFiberEndImage");
                                        } else if (event1.eventCode[0] == 48) {
                                            if ((float)event1.eventLoss < 0.0f) {
                                                tmpS = "G";
                                                imageURL = this.mainClass.getResource("eventTableGainImage");
                                            } else {
                                                tmpS = "NR";
                                                imageURL = this.mainClass.getResource("eventTableNonReflectImage");
                                            }
                                        } else {
                                            tmpS = "R";
                                            imageURL = this.mainClass.getResource("eventTableReflectImage");
                                        }
                                        if (imageURL != null) {
                                            tmpImage = new ImageIcon(imageURL);
                                            break;
                                        }
                                        g.setColor(color1);
                                        break;
                                    }
                                    break block102;
                                }
                                case 2: {
                                    if (event2 != null) {
                                        tmpS = String.format("%d", event2.eventNumber);
                                        g.setColor(color2);
                                        break;
                                    }
                                    break block102;
                                }
                                case 3: {
                                    if (event2 != null) {
                                        URL imageURL;
                                        if (event2.eventCode[1] == 69 || event2.eventCode[1] == 68) {
                                            tmpS = "FE";
                                            imageURL = this.mainClass.getResource("eventTableFiberEndImage");
                                        } else if (event2.eventCode[0] == 48) {
                                            if ((float)event2.eventLoss < 0.0f) {
                                                tmpS = "G";
                                                imageURL = this.mainClass.getResource("eventTableGainImage");
                                            } else {
                                                tmpS = "NR";
                                                imageURL = this.mainClass.getResource("eventTableNonReflectImage");
                                            }
                                        } else {
                                            tmpS = "R";
                                            imageURL = this.mainClass.getResource("eventTableReflectImage");
                                        }
                                        if (imageURL != null) {
                                            tmpImage = new ImageIcon(imageURL);
                                            break;
                                        }
                                        g.setColor(color2);
                                        break;
                                    }
                                    break block102;
                                }
                                case 4: {
                                    if (event1 != null) {
                                        tmpS = String.format("%.4f", Float.valueOf(eventDistance));
                                        break;
                                    }
                                    break block102;
                                }
                                case 5: {
                                    tmpS = "";
                                    if (event1 != null && event1.eventLoss != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)event1.eventLoss / 1000.0f));
                                        g.setColor(color1);
                                        break;
                                    }
                                    break block102;
                                }
                                case 6: {
                                    tmpS = "";
                                    if (event2 != null && event2.eventLoss != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)event2.eventLoss / 1000.0f));
                                        g.setColor(color2);
                                        break;
                                    }
                                    break block102;
                                }
                                case 7: {
                                    tmpS = "";
                                    if (twoWayKeyEvents.events[eventIndex].eventLoss != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)twoWayKeyEvents.events[eventIndex].eventLoss / 1000.0f));
                                        break;
                                    }
                                    break block102;
                                }
                                case 8: {
                                    tmpS = "";
                                    if (event1 != null && event1.attenuationCoefficientLeadInFiber != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)event1.attenuationCoefficientLeadInFiber / 1000.0f));
                                        g.setColor(color1);
                                        break;
                                    }
                                    break block102;
                                }
                                case 9: {
                                    short attenuationCoefficientLeadInFiber;
                                    int j;
                                    tmpS = "";
                                    if (event2 != null && (j = event2.eventNumber - 1) < memSorFile.keyEvents.numberOfKeyEvents - 1 && (attenuationCoefficientLeadInFiber = memSorFile.keyEvents.events[j + 1].attenuationCoefficientLeadInFiber) != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)attenuationCoefficientLeadInFiber / 1000.0f));
                                        g.setColor(color2);
                                        break;
                                    }
                                    break block102;
                                }
                                case 10: {
                                    tmpS = "";
                                    if (twoWayKeyEvents.events[eventIndex].attenuationCoefficientLeadInFiber != 0) {
                                        tmpS = String.format("%.3f", Float.valueOf((float)twoWayKeyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f));
                                        break;
                                    }
                                    break block102;
                                }
                                default: {
                                    tmpS = this.mainClass.getResourceString("error");
                                    break;
                                }
                            }
                            break block102;
                        }
                        switch (index) {
                            case 0: {
                                URL imageURL;
                                if (mainSorFile.keyEvents.events[eventIndex].eventCode[1] == 69 || mainSorFile.keyEvents.events[eventIndex].eventCode[1] == 68) {
                                    tmpS = "FE";
                                    imageURL = this.mainClass.getResource("eventTableFiberEndImage");
                                } else if (mainSorFile.keyEvents.events[eventIndex].eventCode[0] == 48) {
                                    if ((float)mainSorFile.keyEvents.events[eventIndex].eventLoss < 0.0f) {
                                        tmpS = "G";
                                        imageURL = this.mainClass.getResource("eventTableGainImage");
                                    } else {
                                        tmpS = "NR";
                                        imageURL = this.mainClass.getResource("eventTableNonReflectImage");
                                    }
                                } else {
                                    tmpS = "R";
                                    imageURL = this.mainClass.getResource("eventTableReflectImage");
                                }
                                if (imageURL == null) break;
                                tmpImage = new ImageIcon(imageURL);
                                break;
                            }
                            case 1: {
                                tmpS = String.format("%d", mainSorFile.keyEvents.events[eventIndex].eventNumber);
                                break;
                            }
                            case 2: {
                                tmpS = String.format("%.4f", Float.valueOf(eventDistance));
                                break;
                            }
                            case 3: {
                                if (mainSorFile.keyEvents.events[eventIndex].eventLoss == 0) break;
                                tmpS = String.format("%.3f", Float.valueOf((float)mainSorFile.keyEvents.events[eventIndex].eventLoss / 1000.0f));
                                break;
                            }
                            case 4: {
                                if (mainSorFile.keyEvents.events[eventIndex].eventReflectance == 0) break;
                                tmpS = String.format("%.3f", Float.valueOf((float)mainSorFile.keyEvents.events[eventIndex].eventReflectance / 1000.0f));
                                break;
                            }
                            case 5: {
                                if (mainSorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber == 0) break;
                                tmpS = String.format("%.3f", Float.valueOf((float)mainSorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f));
                                break;
                            }
                            case 6: {
                                if (mainSorFile.dataPts.scaledData == null || !(eventDistance > 0.0f)) break;
                                tmpS = String.format("%.3f", Float.valueOf(mainSorFile.dataPts.scaledData[timeIndex] - mainSorFile.dataPts.scaledData[index0]));
                                break;
                            }
                            case 7: {
                                tmpS = mainSorFile.keyEvents.events[eventIndex].comment;
                                break;
                            }
                        }
                    }
                    int strWidth = (int)Math.round(fm.getStringBounds(tmpS, g).getWidth());
                    cellWidth = columnsRightX[index] - (rect.x + xOffset);
                    int imageWidth = fm.stringWidth("FE");
                    int imageHeight = fm.getAscent();
                    if (tmpImage == null) {
                        x = eventsTableHeaderStrings.length - 1 == index ? rect.x + xOffset + 1 : rect.x + xOffset + (cellWidth - strWidth) / 2;
                        y = rect.y + yOffset + fm.getAscent();
                    } else {
                        x = rect.x + xOffset + (cellWidth - imageWidth) / 2;
                        y = rect.y + yOffset + (cellHeight - imageHeight) / 2;
                    }
                    int y_criteria = rect.y + yOffset + (cellHeight - imageHeight) / 2;
                    if (y_criteria >= bottomPageLimit) {
                        isBreak = true;
                        ret = 0;
                        break;
                    }
                    Shape oldShape = g.getClip();
                    g.setClip(rect.x + xOffset, rect.y + yOffset, cellWidth, cellHeight);
                    if (tmpImage == null) {
                        g.drawString(tmpS, x, y);
                    } else {
                        g.drawImage(tmpImage.getImage(), x, y, imageWidth, imageHeight, null);
                    }
                    g.setClip(oldShape);
                    xOffset += cellWidth;
                    ++index;
                }
                if (eventIndex == mainSorFile.keyEvents.numberOfKeyEvents - 1) {
                    Color oldColor = g.getColor();
                    g.setColor(Color.GRAY);
                    g.drawLine(rect.x, rect.y + yOffset + cellHeight, rect.x + xOffset, rect.y + yOffset + cellHeight);
                    g.setColor(oldColor);
                }
                if (isBreak) break;
                xOffset = 0;
                yOffset += cellHeight;
                ++eventIndex;
            }
            this.oldPageIndex = pageIndex;
            this.printEventIndex = eventIndex;
        }
        return ret;
    }

    private void drawRfg(Graphics g, int sorFileIndex, PageFormat pf) {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        if (-1 == referenceSorFileIndex) {
            return;
        }
        SorFile referenceSorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        SorFile sorFile = this.mainClass.getSorFile(sorFileIndex);
        boolean isReverse = false;
        float direction = 1.0f;
        if (sorFile == referenceSorFile) {
            if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
                sorFile.indexOffset = sorFile.positiveDistanceIndex;
            }
        } else if (this.mainClass.isTwoWayChecked()) {
            isReverse = true;
        }
        if (sorFile.isDataPtsPresent) {
            int y0;
            int x0;
            int height;
            int width;
            Rectangle rect;
            try {
                rect = g.getClipBounds();
            }
            catch (Exception e) {
                System.out.printf("AHTUNG!!! \u0421\u041b\u0423\u0427\u0418\u041b\u041e\u0421\u042c \u0414\u0418\u0427\u0410\u0419\u0428\u0415\u0415 (drawRFG): %s\n", e.getMessage());
                return;
            }
            if (rect != null) {
                width = rect.width;
                height = rect.height;
                x0 = rect.x;
                y0 = rect.y;
            } else {
                width = this.getWidth();
                height = this.getHeight();
                x0 = 0;
                y0 = 0;
            }
            sorFile.recalcXYSteps(this.mainClass, width, height, referenceSorFile);
            float localYOffset = (float)sorFile.yOffset * (float)height / (float)this.getHeight();
            if (sorFile != referenceSorFile && sorFile.indexOffset >= sorFile.dataPts.numberOfDataPoints - 1) {
                return;
            }
            int deltaIndex = 0;
            int indexOffset = sorFile.indexOffset;
            if (isReverse) {
                boolean canShowReverse = referenceSorFile.isKeyEventsPresent;
                int endDataIndex = 0;
                if (canShowReverse) {
                    int endOfFiberEventIndex = referenceSorFile.keyEvents.numberOfKeyEvents - 1;
                    if (endOfFiberEventIndex < 0) {
                        canShowReverse = false;
                    } else {
                        SorFile.KeyEventsItem event = referenceSorFile.keyEvents.events[endOfFiberEventIndex];
                        byte eventCode = event.eventCode[1];
                        if (68 != eventCode && 69 != eventCode && 100 != eventCode && 101 != eventCode) {
                            canShowReverse = false;
                        } else {
                            endDataIndex = referenceSorFile.getTimeIndex(event.eventPropagationTime);
                        }
                    }
                }
                if (!canShowReverse) {
                    this.mainClass.setTwoWay(false);
                    return;
                }
                float endX = referenceSorFile.getXStep() * (float)(endDataIndex - referenceSorFile.indexOffset);
                deltaIndex = Math.round(endX / sorFile.getXStep());
                direction = -1.0f;
                indexOffset = 0;
            }
            float old_x = x0;
            float old_y = y0;
            y0 = (int)((float)y0 - sorFile.dataPts.minData * sorFile.getYStep());
            float x = (float)x0 + sorFile.getXStep() * ((float)deltaIndex + direction * 0.0f - (float)indexOffset);
            float y = (float)y0 + sorFile.dataPts.scaledData[0] * sorFile.getYStep() - localYOffset;
            g.setColor(Color.BLACK);
            g.setColor(COLOR_RFG[sorFileIndex]);
            int i = 1;
            while (i < sorFile.dataPts.numberOfDataPoints) {
                old_x = x;
                old_y = y;
                x = (float)x0 + sorFile.getXStep() * ((float)deltaIndex + direction * (float)i - (float)indexOffset);
                y = (float)y0 + sorFile.dataPts.scaledData[i] * sorFile.getYStep() - localYOffset;
                g.drawLine((int)old_x, (int)old_y, (int)x, (int)y);
                ++i;
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        float width = this.getWidth();
        float height = this.getHeight();
        boolean isInvalid = false;
        if (this.memGraphics2 == null || this.memImage == null) {
            this.memImage = this.createImage((int)width, (int)height);
            this.memGraphics2 = (Graphics2D)this.memImage.getGraphics();
            isInvalid = true;
        } else if (this.memGraphics2.getDeviceConfiguration().getBounds().getHeight() != (double)((int)height) || this.memGraphics2.getDeviceConfiguration().getBounds().getWidth() != (double)((int)width)) {
            this.memImage = null;
            this.memGraphics2 = null;
            this.memImage = this.createImage((int)width, (int)height);
            this.memGraphics2 = (Graphics2D)this.memImage.getGraphics();
            isInvalid = true;
        }
        int mainSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile referenceSorFile = null;
        if (mainSorFileIndex >= 0) {
            referenceSorFile = this.mainClass.getSorFile(this.mainClass.getReferenceSorFileIndex());
            referenceSorFile.recalcXYSteps(this.mainClass, width, height, referenceSorFile);
        }
        if (isInvalid) {
            this.memGraphics2.setColor(COLOR_BACK);
            this.memGraphics2.fillRect(0, 0, (int)width, (int)height);
            this.drawGrid(this.memGraphics2);
            if (mainSorFileIndex >= 0) {
                int sorFileIndex = 0;
                while (sorFileIndex < this.mainClass.getSorFilesCount()) {
                    if (mainSorFileIndex != sorFileIndex) {
                        SorFile sorFile = this.getSorFile(sorFileIndex);
                        if (this.mainClass.otdrControlPanel.isRfgChecked(sorFileIndex) && (sorFile.isDataPtsPresent || sorFile.isKeyEventsPresent)) {
                            this.drawRfg(this.memGraphics2, sorFileIndex, null);
                        }
                    }
                    ++sorFileIndex;
                }
            }
            if (mainSorFileIndex >= 0) {
                this.drawRfg(this.memGraphics2, mainSorFileIndex, null);
                this.drawKeyEvents(this.memGraphics2, null);
                this.mainClass.otdrControlPanel.getRfgMap().updateUI();
            }
        }
        Image localMemImage = this.createImage((int)width, (int)height);
        Graphics2D localMemGraphics2 = (Graphics2D)localMemImage.getGraphics();
        localMemGraphics2.drawImage(this.memImage, 0, 0, COLOR_BACK, null);
        if (mainSorFileIndex >= 0) {
            SorFile sorFile;
            int dataIndex;
            int currentEventIndex;
            if (this.isZoomMode) {
                this.drawZoomRectangle(localMemGraphics2);
            }
            this.drawCursors(localMemGraphics2, null);
            if (this.mainClass.otdrWindow.otdrEventsPanel.isEventsOn() && this.mainClass.otdrWindow.otdrEventsPanel.isVisible() && (currentEventIndex = this.mainClass.otdrWindow.otdrEventsPanel.getCurrentEventIndex()) >= 0 && (dataIndex = (sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex())).getTimeIndex(sorFile.keyEvents.events[currentEventIndex].eventPropagationTime)) > 0) {
                float tmp_x = (float)(dataIndex - sorFile.indexOffset) * sorFile.getXStep();
                float y = this.getHeight() - 3;
                int w = this.mainClass.imageNR.getIconWidth() + 6;
                int h = this.mainClass.imageNR.getIconHeight() + 6;
                Stroke oldStroke = localMemGraphics2.getStroke();
                BasicStroke tmpStroke = new BasicStroke(2.0f);
                localMemGraphics2.setStroke(tmpStroke);
                localMemGraphics2.setColor(COLOR_CUR_EVENT);
                localMemGraphics2.drawRect((int)tmp_x - w / 2, (int)y - h, w, h);
                localMemGraphics2.setStroke(oldStroke);
            }
        }
        g.drawImage(localMemImage, 0, 0, COLOR_BACK, null);
    }

    void drawZoomRectangle(Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f, 6.0f, 6.0f}, 0.0f);
        g2.setStroke(dotted);
        g2.setColor(COLOR_ZOOMING_RECT);
        int x = Math.min(this.zoomX0, this.zoomX1);
        int y = Math.min(this.zoomY0, this.zoomY1);
        int width = Math.max(this.zoomX0, this.zoomX1) - x;
        int height = Math.max(this.zoomY0, this.zoomY1) - y;
        g2.drawRect(x, y, width, height);
        g2.setStroke(oldStroke);
    }

    void drawCursors(Graphics2D g2, PageFormat pf) {
        int y0;
        int x0;
        int height;
        int width;
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile.dataPts == null || sorFile.dataPts.scaledData == null || sorFile.keyEvents == null) {
            return;
        }
        Rectangle rect = g2.getClipBounds();
        if (rect != null) {
            width = rect.width;
            height = rect.height;
            x0 = rect.x;
            y0 = rect.y;
        } else {
            width = this.getWidth();
            height = this.getHeight();
            x0 = 0;
            y0 = 0;
        }
        if (pf == null) {
            g2.setColor(COLOR_CURSORS);
        } else {
            g2.setColor(Color.BLACK);
        }
        Stroke oldStroke = g2.getStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f, 6.0f, 6.0f}, 0.0f);
        sorFile.recalcXYSteps(this.mainClass, width, height, sorFile);
        int i = 0;
        while (i < 2) {
            if (i == 1) {
                g2.setStroke(dotted);
            }
            float x = sorFile.getXStep() * (float)sorFile.cursor[i].getDataIndex();
            int ix = x0 + (int)(x -= sorFile.getXStep() * (float)sorFile.indexOffset);
            if (ix <= width) {
                g2.drawLine(ix, y0 + 0, ix, y0 + height - 1);
                if (i == sorFile.activeCursor) {
                    g2.setStroke(oldStroke);
                    g2.drawLine(ix, y0 + 0, ix - 2, y0 + 5);
                    g2.drawLine(ix, y0 + 0, ix + 2, y0 + 5);
                    g2.drawLine(ix - 2, y0 + 5, ix + 2, y0 + 5);
                    g2.drawLine(ix, y0 + height - 1, ix - 2, y0 + height - 5 - 1);
                    g2.drawLine(ix, y0 + height - 1, ix + 2, y0 + height - 5 - 1);
                    g2.drawLine(ix - 2, y0 + height - 5 - 1, ix + 2, y0 + height - 5 - 1);
                }
                int textX = ix + 5;
                int textY = y0 + height;
                String tmpS = String.format("%.2f ", Float.valueOf(sorFile.dataPts.scaledData[sorFile.cursor[i].getDataIndex()]));
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dB");
                FontMetrics fm = g2.getFontMetrics();
                textY -= (i + 1) * fm.getHeight();
                if ((double)textX + fm.getStringBounds(tmpS, g2).getWidth() >= (double)width) {
                    textX = ix - (int)fm.getStringBounds(tmpS, g2).getWidth() - 5;
                }
                g2.drawString(tmpS, textX, textY);
            }
            ++i;
        }
        y0 = (int)((float)y0 - sorFile.dataPts.minData * sorFile.getYStep());
        if (MainClass.MeasureMode.MEASURE_MODE_APPROX_LOSS == this.mainClass.getMeasureMode()) {
            sorFile.lsaLine[0] = sorFile.getLSALine(sorFile.cursor[0].getDataIndex(), sorFile.cursor[1].getDataIndex());
            float y1dB = sorFile.lsaLine[0].getY(sorFile.cursor[0].getDataIndex());
            float y2dB = sorFile.lsaLine[0].getY(sorFile.cursor[1].getDataIndex());
            float y1 = (float)y0 + y1dB * sorFile.getYStep() - (float)sorFile.yOffset;
            float y2 = (float)y0 + y2dB * sorFile.getYStep() - (float)sorFile.yOffset;
            float x1 = (float)x0 + sorFile.getXStep() * (float)(sorFile.cursor[0].getDataIndex() - sorFile.indexOffset);
            float x2 = (float)x0 + sorFile.getXStep() * (float)(sorFile.cursor[1].getDataIndex() - sorFile.indexOffset);
            if (pf == null) {
                g2.setColor(COLOR_LSA_LINE);
                g2.setXORMode(COLOR_BACK);
            } else {
                g2.setColor(Color.BLACK);
            }
            BasicStroke w3 = new BasicStroke(3.0f);
            g2.setStroke(w3);
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            g2.setPaintMode();
        } else if (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS == this.mainClass.getMeasureMode()) {
            g2.setStroke(oldStroke);
            sorFile.lsaLine[0] = sorFile.getLSALine(sorFile.cursor[2].getDataIndex(), sorFile.cursor[0].getDataIndex());
            sorFile.lsaLine[1] = sorFile.getLSALine(sorFile.cursor[3].getDataIndex(), sorFile.cursor[1].getDataIndex());
            this.drawLSACursor(g2, sorFile, 2, pf);
            this.drawLSACursor(g2, sorFile, 3, pf);
            this.drawLSACursor(g2, sorFile, 4, pf);
        }
        g2.setStroke(oldStroke);
    }

    void drawLSACursor(Graphics2D g2, SorFile sorFile, int cursorIndex, PageFormat pf) {
        float x1;
        float y1;
        int y0;
        int x0;
        int height;
        int cursorSize = 150;
        Rectangle rect = g2.getClipBounds();
        if (rect != null) {
            height = rect.height;
            x0 = rect.x;
            y0 = rect.y;
        } else {
            height = this.getHeight();
            x0 = 0;
            y0 = 0;
        }
        y0 = (int)((float)y0 - sorFile.dataPts.minData * sorFile.getYStep());
        int localYOffset = Math.round((float)sorFile.yOffset * (float)height / (float)this.getHeight());
        Stroke oldStroke = g2.getStroke();
        BasicStroke w3 = new BasicStroke(3.0f);
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f, 6.0f, 6.0f}, 0.0f);
        if (4 != cursorIndex) {
            int baseCursorIndex;
            int lsaLineIndex;
            if (2 == cursorIndex) {
                lsaLineIndex = 0;
                baseCursorIndex = 0;
            } else {
                lsaLineIndex = 1;
                baseCursorIndex = 1;
            }
            float y1dB = sorFile.lsaLine[lsaLineIndex].getY(sorFile.cursor[cursorIndex].getDataIndex());
            float y2dB = sorFile.lsaLine[lsaLineIndex].getY(sorFile.cursor[baseCursorIndex].getDataIndex());
            y1 = (float)y0 + y1dB * sorFile.getYStep() - (float)localYOffset;
            float y2 = (float)y0 + y2dB * sorFile.getYStep() - (float)localYOffset;
            x1 = (float)x0 + sorFile.getXStep() * (float)(sorFile.cursor[cursorIndex].getDataIndex() - sorFile.indexOffset);
            float x2 = (float)x0 + sorFile.getXStep() * (float)(sorFile.cursor[baseCursorIndex].getDataIndex() - sorFile.indexOffset);
            if (pf == null) {
                g2.setColor(COLOR_LSA_LINE);
                g2.setXORMode(COLOR_BACK);
            } else {
                g2.setColor(Color.BLACK);
            }
            g2.setStroke(w3);
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            g2.setPaintMode();
            if (cursorIndex == sorFile.activeCursor) {
                g2.setStroke(dotted);
            } else {
                g2.setStroke(oldStroke);
            }
            if (pf == null) {
                g2.setColor(COLOR_LSA_SPECTRUM);
            } else {
                g2.setColor(Color.BLACK);
            }
            g2.drawLine((int)x1, (int)y1 - cursorSize / 2, (int)x1, (int)y1 + cursorSize / 2);
        } else {
            y1 = (float)y0 + sorFile.dataPts.scaledData[sorFile.cursor[cursorIndex].getDataIndex()] * sorFile.getYStep() - (float)localYOffset;
            x1 = (float)x0 + sorFile.getXStep() * (float)(sorFile.cursor[cursorIndex].getDataIndex() - sorFile.indexOffset);
            if (cursorIndex == sorFile.activeCursor) {
                g2.setStroke(dotted);
            } else {
                g2.setStroke(oldStroke);
            }
            if (pf == null) {
                g2.setColor(COLOR_LSA_SPECTRUM);
            } else {
                g2.setColor(Color.BLACK);
            }
            g2.drawLine((int)x1, (int)y1 - cursorSize / 2, (int)x1, (int)y1 + cursorSize / 2);
        }
        g2.setStroke(oldStroke);
        if (cursorIndex == sorFile.activeCursor) {
            int ix = (int)x1;
            int iy = (int)y1;
            g2.drawLine(ix, iy - cursorSize / 2, ix - 2, iy - cursorSize / 2 + 5);
            g2.drawLine(ix, iy - cursorSize / 2, ix + 2, iy - cursorSize / 2 + 5);
            g2.drawLine(ix - 2, iy - cursorSize / 2 + 5, ix + 2, iy - cursorSize / 2 + 5);
            g2.drawLine(ix, iy + cursorSize / 2, ix - 2, iy + cursorSize / 2 - 5);
            g2.drawLine(ix, iy + cursorSize / 2, ix + 2, iy + cursorSize / 2 - 5);
            g2.drawLine(ix - 2, iy + cursorSize / 2 - 5, ix + 2, iy + cursorSize / 2 - 5);
        }
    }

    void drawKeyEvents(Graphics2D g2, PageFormat pf) {
        int y0;
        int x0;
        int height;
        int width;
        Rectangle rect;
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        SorFile.KeyEvents keyEvents = null;
        keyEvents = this.mainClass.isTwoWayChecked() ? this.mainClass.getTwoWayKeyEvents() : sorFile.keyEvents;
        if (!sorFile.isKeyEventsPresent) {
            return;
        }
        if (keyEvents == null) {
            return;
        }
        if (!this.mainClass.otdrWindow.otdrEventsPanel.isEventsOn()) {
            return;
        }
        try {
            rect = g2.getClipBounds();
        }
        catch (Exception e) {
            System.out.printf("AHTUNG!!! (drawKeyEvents):%s", e.getMessage());
            return;
        }
        if (rect != null) {
            width = rect.width;
            height = rect.height;
            x0 = rect.x;
            y0 = rect.y;
        } else {
            width = this.getWidth();
            height = this.getHeight();
            x0 = 0;
            y0 = 0;
        }
        int localYOffset = Math.round((float)sorFile.yOffset * (float)height / (float)this.getHeight());
        if (pf == null) {
            g2.setColor(COLOR_EVENTS);
        } else {
            int fontSize = 6;
            Font fnt = new Font("Arial Cyr", 0, fontSize);
            g2.setFont(fnt);
            g2.setColor(Color.BLACK);
        }
        sorFile.recalcXYSteps(this.mainClass, width, height, sorFile);
        int previousDataIndex = 0;
        int previousTextX = 0;
        y0 = (int)((float)y0 - sorFile.dataPts.minData * sorFile.getYStep());
        int eventIndex = 0;
        while (eventIndex < keyEvents.numberOfKeyEvents) {
            int dataIndex = sorFile.getTimeIndex(keyEvents.events[eventIndex].eventPropagationTime);
            if (dataIndex > sorFile.positiveDistanceIndex) {
                int y1;
                ImageIcon tmpImage;
                int eventX = x0 + Math.round(sorFile.getXStep() * ((float)dataIndex - (float)sorFile.indexOffset));
                int eventY = y0 + Math.round(sorFile.dataPts.scaledData[dataIndex] * sorFile.getYStep() - (float)localYOffset);
                g2.drawLine(eventX, eventY - 8, eventX, eventY + 8);
                g2.drawLine(eventX - 4, eventY + 8, eventX + 4, eventY + 8);
                AffineTransform oldAT = g2.getTransform();
                AffineTransform aT = g2.getTransform();
                aT.quadrantRotate(3);
                g2.setTransform(aT);
                String tmpS = String.format("%.4f ", Float.valueOf((float)sorFile.recalcDistance(dataIndex)));
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("km");
                int textX = eventX + g2.getFontMetrics().getHeight() / 3;
                int textY = eventY + 16 + g2.getFontMetrics().stringWidth(tmpS);
                g2.drawString(tmpS, -textY, textX);
                g2.setTransform(oldAT);
                if (keyEvents.events[eventIndex].eventCode[1] == 69 || keyEvents.events[eventIndex].eventCode[1] == 68) {
                    tmpS = "FE";
                    tmpImage = pf == null ? this.mainClass.imageFE : this.mainClass.loadImageIcon("eventTableFiberEndImage");
                } else if (keyEvents.events[eventIndex].eventCode[0] == 48) {
                    if ((float)keyEvents.events[eventIndex].eventLoss < 0.0f) {
                        tmpS = "G";
                        tmpImage = pf == null ? this.mainClass.imageGain : this.mainClass.loadImageIcon("eventTableGainImage");
                    } else {
                        tmpS = "NR";
                        tmpImage = pf == null ? this.mainClass.imageNR : this.mainClass.loadImageIcon("eventTableNonReflectImage");
                    }
                } else {
                    tmpS = "R";
                    tmpImage = pf == null ? this.mainClass.imageR : this.mainClass.loadImageIcon("eventTableReflectImage");
                }
                if (tmpImage != null) {
                    y1 = rect == null ? 0 : rect.y;
                    g2.drawImage(tmpImage.getImage(), eventX - tmpImage.getIconWidth() / 2, y1 + height - tmpImage.getIconHeight() - 6, COLOR_BACK, null);
                } else {
                    y1 = rect == null ? 0 : rect.y;
                    g2.drawString(tmpS, eventX, y1 + height - g2.getFontMetrics().stringWidth(tmpS) / 2 - 6);
                }
                tmpS = String.format("%3.3f ", Float.valueOf((float)keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f));
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("dBPerKm");
                textX = x0 + Math.round(((float)(dataIndex - (dataIndex - previousDataIndex) / 2) - (float)sorFile.indexOffset) * sorFile.getXStep());
                int textWidth = g2.getFontMetrics().stringWidth(tmpS);
                int textIndex = Math.round((float)((textX -= textWidth / 2) - x0) * sorFile.getPointWeight()) + sorFile.indexOffset;
                textY = textIndex > 0 && sorFile.dataPts.numberOfDataPoints > textIndex ? y0 + Math.round(sorFile.dataPts.scaledData[textIndex] * sorFile.getYStep() - (float)localYOffset) : y0 + 0;
                textY -= 5;
                if (previousTextX < textX) {
                    g2.drawString(tmpS, textX, textY);
                    previousTextX = textX + textWidth;
                }
                previousDataIndex = dataIndex;
            }
            ++eventIndex;
        }
    }

    void drawGrid(Graphics2D g2) {
        int y0;
        int x0;
        float height;
        float width;
        Rectangle rect = g2.getClipBounds();
        if (rect != null) {
            width = rect.width;
            height = rect.height;
            x0 = rect.x;
            y0 = rect.y;
        } else {
            width = this.getWidth();
            height = this.getHeight();
            x0 = 0;
            y0 = 0;
        }
        int dx = (int)(width / 10.0f);
        int dy = (int)(height / 10.0f);
        if (dx <= 0) {
            dx = 1;
        }
        if (dy <= 0) {
            dy = 1;
        }
        g2.setColor(COLOR_GRID);
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(dotted);
        int i = 0;
        while (i < (int)width) {
            g2.drawLine(x0 + i, y0 + 0, x0 + i, y0 + (int)height);
            i += dx;
        }
        i = 0;
        while (i < (int)height) {
            g2.drawLine(x0 + 0, y0 + i, x0 + (int)width, y0 + i);
            i += dy;
        }
        g2.setStroke(oldStroke);
    }

    void checkStartIndex() {
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts.data == null) {
            return;
        }
        if (sorFile.dataPts.scaledData == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        sorFile.recalcXYSteps(this.mainClass, this.getWidth(), this.getHeight(), sorFile);
        if ((float)(sorFile.dataPts.numberOfDataPoints - sorFile.indexOffset) * sorFile.getXStep() < (float)this.getWidth()) {
            sorFile.indexOffset = (int)((float)sorFile.dataPts.numberOfDataPoints - (float)this.getWidth() / sorFile.getXStep());
        }
        if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
            sorFile.indexOffset = sorFile.positiveDistanceIndex;
        }
        this.autoSearchRfg();
    }

    public void autoSearchRfg() {
        if (this.mainClass != null && !this.mainClass.menuItemAutosearch.isSelected()) {
            return;
        }
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts.scaledData == null) {
            return;
        }
        int oldYOffset = sorFile.yOffset;
        float indexX = this.getWidth() / 2;
        int index = Math.round(indexX / sorFile.getXStep()) + sorFile.indexOffset;
        if (index < sorFile.positiveDistanceIndex) {
            System.out.printf("index!!! = %d\n", index);
            index = sorFile.positiveDistanceIndex;
        } else if (index > sorFile.dataPts.numberOfDataPoints - 1) {
            System.out.printf("index!!!!! = %d, indexOffset = %d\n", index, sorFile.indexOffset);
            index = sorFile.positiveDistanceIndex;
        }
        float y = (sorFile.dataPts.scaledData[index] - sorFile.dataPts.minData) * sorFile.getYStep() - (float)oldYOffset;
        if (y > 0.0f && y < (float)(this.getHeight() - 1)) {
            return;
        }
        sorFile.yOffset = Math.round((sorFile.dataPts.scaledData[index] - sorFile.dataPts.minData) * sorFile.getYStep() - (float)(this.getHeight() / 2));
        if (oldYOffset != sorFile.yOffset) {
            sorFile.recalcXYSteps(this.mainClass, this.getWidth(), this.getHeight(), sorFile);
            this.invalidateView();
            if (this.mainClass != null) {
                this.mainClass.otdrWindow.updateUI();
                this.mainClass.updateZoomControls();
                this.mainClass.updateOtdrControlPanel();
                this.mainClass.updateScrolls();
            }
        }
    }

    public void zoom(int x0, int y0, int x1, int y1) {
        this.zoomX0 = x0;
        this.zoomX1 = x1;
        this.zoomY0 = y0;
        this.zoomY1 = y1;
        this.zoom();
    }

    private void zoom() {
        if (this.zoomX0 != this.zoomX1 && this.zoomY0 != this.zoomY1) {
            SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
            if (sorFile == null) {
                return;
            }
            int zoomLeft = Math.min(this.zoomX0, this.zoomX1);
            int zoomRight = Math.max(this.zoomX0, this.zoomX1);
            int zoomTop = Math.min(this.zoomY0, this.zoomY1);
            int zoomBottom = Math.max(this.zoomY0, this.zoomY1);
            int centerX = zoomLeft + (zoomRight - zoomLeft) / 2;
            int centerY = zoomTop + (zoomBottom - zoomTop) / 2;
            float xScale = (float)(Double.valueOf(this.mainClass.xScale) * (double)Math.abs((float)this.getWidth() / (float)(zoomRight - zoomLeft)));
            float yScale = (float)(Double.valueOf(this.mainClass.yScale) * (double)Math.abs((float)this.getHeight() / (float)(zoomBottom - zoomTop)));
            if (xScale < 1.0f) {
                xScale = 1.0f;
            }
            if (yScale < 1.0f) {
                yScale = 1.0f;
            }
            if (xScale > this.mainClass.maxXYScale) {
                xScale = this.mainClass.maxXYScale;
            }
            if (yScale > this.mainClass.maxXYScale) {
                yScale = this.mainClass.maxXYScale;
            }
            float newYStep = (float)(this.getHeight() - 1) / Math.abs(sorFile.dataPts.maxData - sorFile.dataPts.minData);
            float newXStep = (float)this.getWidth() / (float)sorFile.dataPts.numberOfDataPoints;
            newYStep *= yScale;
            int centerIndex = Math.round((float)centerX / sorFile.getXStep() + (float)sorFile.indexOffset);
            sorFile.indexOffset = Math.round((float)centerIndex - (float)this.getWidth() / 2.0f / (newXStep *= xScale));
            if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
                sorFile.indexOffset = sorFile.positiveDistanceIndex;
            }
            float db = (float)(sorFile.yOffset + centerY) / sorFile.getYStep();
            int newYOffset = Math.round(db * newYStep - (float)(this.getHeight() / 2));
            this.mainClass.xScale = String.format("%f", Float.valueOf(xScale));
            this.mainClass.yScale = String.format("%f", Float.valueOf(yScale));
            this.mainClass.xScale = this.mainClass.xScale.replace(",", ".");
            this.mainClass.yScale = this.mainClass.yScale.replace(",", ".");
            sorFile.maxYOffset = Math.round((float)this.getHeight() * (Float.valueOf(this.mainClass.yScale).floatValue() - 1.0f));
            if (newYOffset > sorFile.maxYOffset) {
                newYOffset = sorFile.maxYOffset;
            }
            if (newYOffset < 0) {
                newYOffset = 0;
            }
            sorFile.yOffset = newYOffset;
            sorFile.recalcXYSteps(this.mainClass, this.getWidth(), this.getHeight(), sorFile);
        }
        this.invalidateView();
        if (this.mainClass != null) {
            this.mainClass.otdrWindow.updateUI();
            this.mainClass.updateZoomControls();
            this.mainClass.updateOtdrControlPanel();
            this.mainClass.updateScrolls();
        }
    }

    public void zoomX(int scaleIndex) {
        int zoomCenter;
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        int oldStartIndex = sorFile.indexOffset;
        float oldXScale = Float.valueOf(this.mainClass.xScale).floatValue();
        float oldXStep = sorFile.getXStep();
        float zoomCenterX = oldXStep * (float)(sorFile.cursor[sorFile.activeCursor].getDataIndex() - sorFile.indexOffset);
        if (zoomCenterX < 0.0f || zoomCenterX > (float)this.getWidth()) {
            zoomCenterX = this.getWidth() / 2;
            zoomCenter = Math.round(zoomCenterX / oldXStep) + sorFile.indexOffset;
        } else {
            zoomCenter = sorFile.cursor[sorFile.activeCursor].getDataIndex();
        }
        this.mainClass.setXScaleIndex(scaleIndex);
        float newXScale = Float.valueOf(this.mainClass.xScale).floatValue();
        float newXStep = oldXStep / oldXScale * newXScale;
        int newStartIndex = Math.round(((float)zoomCenter * newXStep - ((float)zoomCenter - (float)oldStartIndex) * oldXStep) / newXStep);
        if ((float)(sorFile.dataPts.numberOfDataPoints - newStartIndex) * newXStep < (float)this.getWidth()) {
            newStartIndex = (int)((float)sorFile.dataPts.numberOfDataPoints - (float)this.getWidth() / newXStep);
        }
        if (newStartIndex < sorFile.positiveDistanceIndex) {
            newStartIndex = sorFile.positiveDistanceIndex;
        }
        sorFile.indexOffset = newStartIndex;
        sorFile.recalcXYSteps(this.mainClass, this.getWidth(), this.getHeight(), sorFile);
        this.invalidateView();
        if (this.mainClass != null) {
            this.mainClass.otdrWindow.updateUI();
            this.mainClass.updateZoomControls();
            this.mainClass.updateOtdrControlPanel();
            this.mainClass.updateScrolls();
        }
    }

    public void zoomY(int scaleIndex) {
        int zoomCenter;
        SorFile sorFile = this.getSorFile(this.mainClass.getReferenceSorFileIndex());
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts.scaledData == null) {
            return;
        }
        float zoomCenterX = sorFile.getXStep() * (float)(sorFile.cursor[sorFile.activeCursor].getDataIndex() - sorFile.indexOffset);
        if (zoomCenterX < 0.0f || zoomCenterX > (float)this.getWidth()) {
            zoomCenterX = this.getWidth() / 2;
            zoomCenter = Math.round(zoomCenterX / sorFile.getXStep()) + sorFile.indexOffset;
        } else {
            zoomCenter = sorFile.cursor[sorFile.activeCursor].getDataIndex();
        }
        if (zoomCenter > sorFile.dataPts.numberOfDataPoints - 1) {
            zoomCenter = sorFile.dataPts.numberOfDataPoints - 1;
        }
        if (zoomCenter < 0) {
            zoomCenter = 0;
        }
        float oldYStep = sorFile.getYStep();
        int oldYOffset = sorFile.yOffset;
        float oldYScale = Float.valueOf(this.mainClass.yScale).floatValue();
        this.mainClass.setYScaleIndex(scaleIndex);
        float newYScale = Float.valueOf(this.mainClass.yScale).floatValue();
        float newYStep = oldYStep / oldYScale * newYScale;
        int newYOffset = Math.round((sorFile.dataPts.scaledData[zoomCenter] - sorFile.dataPts.minData) * newYStep - ((sorFile.dataPts.scaledData[zoomCenter] - sorFile.dataPts.minData) * oldYStep - (float)oldYOffset));
        sorFile.maxYOffset = Math.round((float)this.getHeight() * (newYScale - 1.0f));
        if (newYOffset > sorFile.maxYOffset) {
            newYOffset = sorFile.maxYOffset;
        }
        if (newYOffset < 0) {
            newYOffset = 0;
        }
        sorFile.yOffset = newYOffset;
        sorFile.recalcXYSteps(this.mainClass, this.getWidth(), this.getHeight(), sorFile);
        this.invalidateView();
        if (this.mainClass != null) {
            this.mainClass.otdrWindow.updateUI();
            this.mainClass.updateZoomControls();
            this.mainClass.updateOtdrControlPanel();
            this.mainClass.updateScrolls();
        }
    }
}

