/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.JOptionPane;

public class SorFile {
    public static final int SOR_FILE_VERSION = 10;
    public static final int CURSOR_A_INDEX = 0;
    public static final int CURSOR_B_INDEX = 1;
    public static final int CURSOR_LA_INDEX = 2;
    public static final int CURSOR_RB_INDEX = 3;
    public static final int CURSOR_CENTER_INDEX = 4;
    public static final int MAX_CURSORS = 5;
    public static final float const_E_per_km = 299792.47f;
    public static final float MIN_AUTO_RT_VALUE = -65.0f;
    private static final float MIN_PTHOTODETECTOR_BAND_WIDTH_MHZ = 0.33f;
    private static final float MAX_PTHOTODETECTOR_BAND_WIDTH_MHZ = 100.0f;
    private final boolean SOR_CALC_PULSE_DEBUG = false;
    private int afterPulseIndex = -1;
    private int justPulseIndex = -1;
    static final int MAX_POSSIBLE_CRACK_COUNT = 1;
    static final int MAX_PULSE_WIDTH_RATIO = 16;
    private boolean isCursorsFixed = false;
    public Map map = new Map();
    public GenParams genParams = new GenParams();
    public SupParams supParams = new SupParams();
    public FxdParams fxdParams = new FxdParams();
    public KeyEvents keyEvents = new KeyEvents();
    public LnkParams lnkParams = new LnkParams();
    public DataPts dataPts = new DataPts();
    public SVPReferenceParams svpReferenceParams = new SVPReferenceParams();
    public SpecialProprietary[] specialProprietary = null;
    public int specialProprietaryCount;
    public Cksum cksum = new Cksum();
    public OTDRCursor[] cursor = new OTDRCursor[5];
    private OTDRCursor[] savedCursorPrivate = new OTDRCursor[5];
    public LSALineParameters[] lsaLine;
    public int positiveDistanceIndex;
    public int activeCursor;
    public float realDistance;
    public String filePath = "untitled.sor";
    public boolean isKeyEventsPresent;
    public boolean isLnkParamsPresent;
    public boolean isDataPtsPresent;
    public boolean isSVPReferenceParamsPresent;
    int indexOffset;
    int yOffset;
    int maxYOffset;
    private byte[] tmpBuffer;
    private byte[] sorFileBuffer = null;
    private int sorFileBufferSize = 0;
    private int bufferOffset;
    private float xStep;
    private float yStep;
    private float pointWeight;
    private float exactMaxData;
    private boolean isEndOfFiberJustAfterPulse = false;

    public SorFile() {
        int i = 0;
        while (i < this.cursor.length) {
            this.cursor[i] = new OTDRCursor();
            ++i;
        }
        this.lsaLine = new LSALineParameters[2];
        i = 0;
        while (i < this.lsaLine.length) {
            this.lsaLine[i] = new LSALineParameters();
            ++i;
        }
        this.isKeyEventsPresent = false;
        this.isLnkParamsPresent = false;
        this.isDataPtsPresent = false;
        this.isSVPReferenceParamsPresent = false;
        this.specialProprietaryCount = 0;
        this.isEndOfFiberJustAfterPulse = false;
    }

    public void saveCSVFile(String filePath) {
        try {
            File file = new File(filePath);
            FileOutputStream fout = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(fout);
            String tmpS = new String();
            int i = 0;
            while (i < this.fxdParams.pulseWidthsUsed.length) {
                tmpS = String.format("pulse width[%d] (ns);%d\r", i, this.fxdParams.pulseWidthsUsed[i]);
                out.writeBytes(tmpS);
                ++i;
            }
            tmpS = String.format("n;%f\r", (double)this.fxdParams.groupIndex / 100000.0);
            out.writeBytes(tmpS);
            tmpS = String.format("number of samples;%d\r", this.dataPts.numberOfDataPoints);
            out.writeBytes(tmpS);
            tmpS = "\r\r";
            out.writeBytes(tmpS);
            tmpS = "km;dB\r";
            out.writeBytes(tmpS);
            i = 0;
            while (i < this.dataPts.numberOfDataPoints) {
                tmpS = String.format("%f;%f\r", Float.valueOf((float)this.recalcDistance(i)), Float.valueOf(-this.dataPts.scaledData[i]));
                out.writeBytes(tmpS);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
    }

    public int loadSorFileBuffer(String filePath) {
        this.sorFileBufferSize = 0;
        try {
            File file = new File(filePath);
            this.sorFileBufferSize = (int)file.length();
            if (this.sorFileBufferSize == 0) {
                System.out.println("Zero length file");
                throw new IOException("File length is zero: " + filePath);
            }
            FileInputStream fin = new FileInputStream(file);
            DataInputStream in = new DataInputStream(fin);
            if (this.sorFileBuffer != null) {
                this.sorFileBuffer = null;
            }
            this.sorFileBuffer = new byte[this.sorFileBufferSize];
            in.readFully(this.sorFileBuffer);
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
        return this.sorFileBufferSize;
    }

    public void saveSorFileBuffer(String filePath) {
        this.createSorFileBuffer();
        try {
            File file = new File(filePath);
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(fos);
            out.write(this.sorFileBuffer, 0, this.sorFileBuffer.length);
            out.flush();
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
    }

    private void startPacking() {
        this.sorFileBufferSize = 0;
        this.bufferOffset = 0;
        this.sorFileBuffer = null;
        this.tmpBuffer = null;
        this.tmpBuffer = new byte[0x100000];
    }

    public void createSorFileBuffer() {
        int j;
        MapItem[] mapItems = new MapItem[255];
        this.startPacking();
        this.map.blockID = "Map";
        this.map.numberOfBlocks = 1;
        int oldBufferSize = this.bufferOffset;
        this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
        this.genParams.blockID = "GenParams";
        this.packValue(this.genParams.blockID);
        this.packValue(this.genParams.languageCode);
        this.packValue(this.genParams.cableID);
        this.packValue(this.genParams.fiberID);
        this.packValue(this.genParams.fiberType);
        this.packValue(this.genParams.nominalWaveLength);
        this.packValue(this.genParams.originatingLocation);
        this.packValue(this.genParams.terminatingLocation);
        this.packValue(this.genParams.cableCode);
        this.packValue(this.genParams.currentDataFlag);
        this.packValue(this.genParams.userOffset);
        this.packValue(this.genParams.userOffsetDistance);
        this.packValue(this.genParams.operatorCode);
        this.packValue(this.genParams.comment);
        this.genParams.size = this.bufferOffset - oldBufferSize;
        mapItems[this.map.numberOfBlocks - 2] = new MapItem();
        mapItems[this.map.numberOfBlocks - 2].id = this.genParams.blockID;
        mapItems[this.map.numberOfBlocks - 2].size = this.genParams.size;
        oldBufferSize = this.bufferOffset;
        this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
        this.supParams.blockID = "SupParams";
        this.packValue(this.supParams.blockID);
        this.packValue(this.supParams.supplierName);
        this.packValue(this.supParams.otdrMainFrameID);
        this.packValue(this.supParams.otdrMainFrameSN);
        this.packValue(this.supParams.opticalModuleID);
        this.packValue(this.supParams.opticalModuleSN);
        this.packValue(this.supParams.softwareRevision);
        this.packValue(this.supParams.other);
        this.supParams.size = this.bufferOffset - oldBufferSize;
        mapItems[this.map.numberOfBlocks - 2] = new MapItem();
        mapItems[this.map.numberOfBlocks - 2].id = this.supParams.blockID;
        mapItems[this.map.numberOfBlocks - 2].size = this.supParams.size;
        oldBufferSize = this.bufferOffset;
        this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
        this.fxdParams.blockID = "FxdParams";
        this.packValue(this.fxdParams.blockID);
        this.packValue(this.fxdParams.dateTimeStamp);
        this.packValue(this.fxdParams.unitsOfDistance);
        this.packValue(this.fxdParams.actualWaveLength);
        this.packValue(this.fxdParams.acquisitionOffset);
        this.packValue(this.fxdParams.acquisitionOffsetDistance);
        this.packValue(this.fxdParams.totalNumberOfPulseWidthsUsed);
        int i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.packValue(this.fxdParams.pulseWidthsUsed[i]);
            ++i;
        }
        i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.packValue(this.fxdParams.dataSpacing[i]);
            ++i;
        }
        i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.packValue(this.fxdParams.numberOfDataPointsForEachPulseWidth[i]);
            ++i;
        }
        this.packValue(this.fxdParams.groupIndex);
        this.packValue(this.fxdParams.backscatterCoefficient);
        this.packValue(this.fxdParams.numberOfAverages);
        this.packUnsignedShort(this.fxdParams.averagingTime);
        this.packValue(this.fxdParams.acquisitionRange);
        this.packValue(this.fxdParams.acquisitionRangeDistance);
        this.packValue(this.fxdParams.frontPannelOffset);
        this.packUnsignedShort(this.fxdParams.noiseFloorLevel);
        this.packValue(this.fxdParams.noiseFloorScaleFactor);
        this.packUnsignedShort(this.fxdParams.powerOffsetFirstPoint);
        this.packUnsignedShort(this.fxdParams.lossThreshold);
        this.packUnsignedShort(this.fxdParams.reflectanceThreshold);
        this.packUnsignedShort(this.fxdParams.endOfFiberThreshold);
        this.packValue(this.fxdParams.traceType);
        i = 0;
        while (i < this.fxdParams.windowCoordinates.length) {
            this.packValue(this.fxdParams.windowCoordinates[i]);
            ++i;
        }
        this.fxdParams.size = this.bufferOffset - oldBufferSize;
        mapItems[this.map.numberOfBlocks - 2] = new MapItem();
        mapItems[this.map.numberOfBlocks - 2].id = this.fxdParams.blockID;
        mapItems[this.map.numberOfBlocks - 2].size = this.fxdParams.size;
        if (this.isKeyEventsPresent) {
            oldBufferSize = this.bufferOffset;
            this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
            this.keyEvents.blockID = "KeyEvents";
            this.packValue(this.keyEvents.blockID);
            this.packValue(this.keyEvents.numberOfKeyEvents);
            i = 0;
            while (i < this.keyEvents.numberOfKeyEvents) {
                this.packValue(this.keyEvents.events[i].eventNumber);
                this.packValue(this.keyEvents.events[i].eventPropagationTime);
                this.packValue(this.keyEvents.events[i].attenuationCoefficientLeadInFiber);
                this.packValue(this.keyEvents.events[i].eventLoss);
                this.packValue(this.keyEvents.events[i].eventReflectance);
                this.packValue(this.keyEvents.events[i].eventCode);
                this.packValue(this.keyEvents.events[i].lossMeasurmentTechnique);
                j = 0;
                while (j < this.keyEvents.events[i].markerLocations.length) {
                    this.packValue(this.keyEvents.events[i].markerLocations[j]);
                    ++j;
                }
                this.packValue(this.keyEvents.events[i].comment);
                ++i;
            }
            this.packValue(this.keyEvents.endToEndLoss);
            i = 0;
            while (i < this.keyEvents.endToEndMarkerPosition.length) {
                this.packValue(this.keyEvents.endToEndMarkerPosition[i]);
                ++i;
            }
            this.packUnsignedShort(this.keyEvents.opticalReturnLoss);
            i = 0;
            while (i < this.keyEvents.opticalReturnLossMarkerPosition.length) {
                this.packValue(this.keyEvents.opticalReturnLossMarkerPosition[i]);
                ++i;
            }
            this.keyEvents.size = this.bufferOffset - oldBufferSize;
            mapItems[this.map.numberOfBlocks - 2] = new MapItem();
            mapItems[this.map.numberOfBlocks - 2].id = this.keyEvents.blockID;
            mapItems[this.map.numberOfBlocks - 2].size = this.keyEvents.size;
        }
        if (this.isLnkParamsPresent) {
            oldBufferSize = this.bufferOffset;
            this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
            this.lnkParams.blockID = "LnkEvents";
            this.packValue(this.lnkParams.blockID);
            this.packValue(this.lnkParams.totalNumberOfLandmarks);
            i = 0;
            while (i < this.lnkParams.totalNumberOfLandmarks) {
                this.packValue(this.lnkParams.landmarks[i].landmarkNumber);
                this.packValue(this.lnkParams.landmarks[i].landmarkCode);
                this.packValue(this.lnkParams.landmarks[i].landmarkLocation);
                this.packValue(this.lnkParams.landmarks[i].relatedEventNumber);
                j = 0;
                while (j < this.lnkParams.landmarks[i].gpsInformation.length) {
                    this.packValue(this.lnkParams.landmarks[i].gpsInformation[j]);
                    ++j;
                }
                this.packValue(this.lnkParams.landmarks[i].fiberCorrectionFactorLeadInFiber);
                this.packValue(this.lnkParams.landmarks[i].sheathMarkerEnteringLandmark);
                this.packValue(this.lnkParams.landmarks[i].sheathMarkerLeavingLandmark);
                this.packValue(this.lnkParams.landmarks[i].unitsOfSheathMarkerLeavingLandmark);
                this.packValue(this.lnkParams.landmarks[i].modeFieldDiameterLeavingLandmark);
                this.packValue(this.lnkParams.landmarks[i].comment);
                ++i;
            }
            this.lnkParams.size = this.bufferOffset - oldBufferSize;
            mapItems[this.map.numberOfBlocks - 2] = new MapItem();
            mapItems[this.map.numberOfBlocks - 2].id = this.lnkParams.blockID;
            mapItems[this.map.numberOfBlocks - 2].size = this.lnkParams.size;
        }
        if (this.isDataPtsPresent) {
            oldBufferSize = this.bufferOffset;
            this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
            this.dataPts.blockID = "DataPts";
            this.packValue(this.dataPts.blockID);
            this.packValue(this.dataPts.numberOfDataPoints);
            this.packValue(this.dataPts.totalNumberScaleFactorsUsed);
            int dataIndex = 0;
            i = 0;
            while (i < this.dataPts.totalNumberScaleFactorsUsed) {
                this.packValue(this.dataPts.totalDataPointsUsingScaleFactor[i]);
                this.packValue(this.dataPts.scaleFactors[i]);
                j = 0;
                while (j < this.dataPts.totalDataPointsUsingScaleFactor[i]) {
                    this.packUnsignedShort(this.dataPts.data[dataIndex]);
                    ++dataIndex;
                    ++j;
                }
                ++i;
            }
            this.dataPts.size = this.bufferOffset - oldBufferSize;
            mapItems[this.map.numberOfBlocks - 2] = new MapItem();
            mapItems[this.map.numberOfBlocks - 2].id = this.dataPts.blockID;
            mapItems[this.map.numberOfBlocks - 2].size = this.dataPts.size;
        }
        if (this.isSVPReferenceParamsPresent) {
            oldBufferSize = this.bufferOffset;
            this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
            this.svpReferenceParams.blockID = "SVPReferenceParams";
            this.packValue(this.svpReferenceParams.blockID);
            this.packUnsignedShort(this.svpReferenceParams.lossDeviation);
            this.packUnsignedShort(this.svpReferenceParams.reflectanceDeviation);
            this.packUnsignedShort(this.svpReferenceParams.lossCoefficientDeviation);
            this.packUnsignedShort(this.svpReferenceParams.fullLossDeviation);
            this.packValue(this.svpReferenceParams.filterCode);
            this.packValue(this.svpReferenceParams.isLowPower);
            this.packValue(this.svpReferenceParams.isHighResolution);
            this.packValue(this.svpReferenceParams.reserved);
            this.svpReferenceParams.size = this.bufferOffset - oldBufferSize;
            mapItems[this.map.numberOfBlocks - 2] = new MapItem();
            mapItems[this.map.numberOfBlocks - 2].id = this.svpReferenceParams.blockID;
            mapItems[this.map.numberOfBlocks - 2].size = this.svpReferenceParams.size;
        }
        i = 0;
        while (i < this.specialProprietaryCount) {
            this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
            this.packValue(this.specialProprietary[i].blockID);
            this.packValue(this.specialProprietary[i].buffer);
            mapItems[this.map.numberOfBlocks - 2] = new MapItem();
            mapItems[this.map.numberOfBlocks - 2].id = this.specialProprietary[i].blockID;
            mapItems[this.map.numberOfBlocks - 2].size = this.specialProprietary[i].blockID.length() + 1 + this.specialProprietary[i].buffer.length;
            ++i;
        }
        oldBufferSize = this.bufferOffset;
        this.map.numberOfBlocks = (short)(this.map.numberOfBlocks + 1);
        this.cksum.blockID = "Cksum";
        this.packValue(this.cksum.blockID);
        this.cksum.checksum = 0;
        this.packUnsignedShort(this.cksum.checksum);
        this.cksum.size = this.bufferOffset - oldBufferSize;
        mapItems[this.map.numberOfBlocks - 2] = new MapItem();
        mapItems[this.map.numberOfBlocks - 2].id = this.cksum.blockID;
        mapItems[this.map.numberOfBlocks - 2].size = this.cksum.size;
        this.map.createMapItems(this.map.numberOfBlocks);
        this.map.revisionNo = 200;
        this.map.size = this.map.blockID.length() + 1;
        this.map.size += 2;
        this.map.size += 4;
        this.map.size += 2;
        i = 0;
        while (i < this.map.numberOfBlocks - 1) {
            this.map.mapItems[i] = new MapItem();
            this.map.mapItems[i].id = mapItems[i].id;
            this.map.mapItems[i].revisionNo = this.map.revisionNo;
            this.map.mapItems[i].size = mapItems[i].size;
            this.map.size += this.map.mapItems[i].id.length() + 1;
            this.map.size += 2;
            this.map.size += 4;
            ++i;
        }
        this.sorFileBufferSize = this.bufferOffset + this.map.size;
        this.sorFileBuffer = new byte[this.sorFileBufferSize];
        i = this.map.size;
        while (i < this.sorFileBufferSize) {
            this.sorFileBuffer[i] = this.tmpBuffer[i - this.map.size];
            ++i;
        }
        this.tmpBuffer = null;
        this.bufferOffset = 0;
        this.tmpBuffer = new byte[this.map.size];
        this.packValue(this.map.blockID);
        this.packUnsignedShort(this.map.revisionNo);
        this.packValue(this.map.size);
        this.packValue(this.map.numberOfBlocks);
        i = 0;
        while (i < this.map.numberOfBlocks - 1) {
            this.packValue(this.map.mapItems[i].id);
            this.packUnsignedShort(this.map.mapItems[i].revisionNo);
            this.packValue(this.map.mapItems[i].size);
            ++i;
        }
        if (this.bufferOffset != this.map.size) {
            String errString = String.format("error sor file map size = %d, bufferOffset = %d", this.map.size, this.bufferOffset);
            JOptionPane.showMessageDialog(null, errString, "OTDR View", 0);
        }
        i = 0;
        while (i < this.map.size) {
            this.sorFileBuffer[i] = this.tmpBuffer[i];
            ++i;
        }
        this.verifyCheckSum(false);
        this.sorFileBuffer[this.sorFileBufferSize - 2] = (byte)(this.cksum.checksum & 0xFF);
        this.sorFileBuffer[this.sorFileBufferSize - 1] = (byte)(this.cksum.checksum >> 8 & 0xFF);
        this.tmpBuffer = null;
        mapItems = null;
        if (this.sorFileBufferSize != this.sorFileBuffer.length) {
            String errString = String.format("error sor file sorFileBuffer.length = %d, sorFileBufferSize = %d", this.sorFileBuffer.length, this.sorFileBufferSize);
            JOptionPane.showMessageDialog(null, errString, "OTDR View", 0);
        }
    }

    private void packValue(String str) {
        int i = 0;
        while (i < str.length()) {
            this.tmpBuffer[this.bufferOffset] = str.getBytes()[i];
            ++this.bufferOffset;
            ++i;
        }
        this.tmpBuffer[this.bufferOffset] = 0;
        ++this.bufferOffset;
    }

    private void packValue(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.tmpBuffer[this.bufferOffset] = bytes[i];
            ++this.bufferOffset;
            ++i;
        }
    }

    private void packValue(byte value) {
        this.tmpBuffer[this.bufferOffset] = value;
        ++this.bufferOffset;
    }

    private void packValue(long value) {
        this.tmpBuffer[this.bufferOffset] = (byte)(value & 0xFFL);
        this.tmpBuffer[this.bufferOffset + 1] = (byte)(value >> 8 & 0xFFL);
        this.tmpBuffer[this.bufferOffset + 2] = (byte)(value >> 16 & 0xFFL);
        this.tmpBuffer[this.bufferOffset + 3] = (byte)(value >> 24 & 0xFFL);
        this.bufferOffset += 4;
    }

    private void packValue(int value) {
        this.tmpBuffer[this.bufferOffset] = (byte)(value & 0xFF);
        this.tmpBuffer[this.bufferOffset + 1] = (byte)(value >> 8 & 0xFF);
        this.tmpBuffer[this.bufferOffset + 2] = (byte)(value >> 16 & 0xFF);
        this.tmpBuffer[this.bufferOffset + 3] = (byte)(value >> 24 & 0xFF);
        this.bufferOffset += 4;
    }

    private void packValue(short value) {
        this.tmpBuffer[this.bufferOffset] = (byte)(value & 0xFF);
        this.tmpBuffer[this.bufferOffset + 1] = (byte)(value >> 8 & 0xFF);
        this.bufferOffset += 2;
    }

    private void packUnsignedShort(int value) {
        this.tmpBuffer[this.bufferOffset] = (byte)(value & 0xFF);
        this.tmpBuffer[this.bufferOffset + 1] = (byte)(value >> 8 & 0xFF);
        this.bufferOffset += 2;
    }

    private void startExtraction() {
        this.bufferOffset = 0;
    }

    private String extractString() {
        int nBytes = 0;
        int index = this.bufferOffset;
        if (index < this.sorFileBuffer.length) {
            while (this.sorFileBuffer[index] != 0) {
                ++nBytes;
                if (++index >= this.sorFileBuffer.length) break;
            }
        }
        byte[] bytes = this.extractByteArray(nBytes);
        ++this.bufferOffset;
        String ret = new String(bytes);
        return ret;
    }

    private byte[] extractByteArray(int size) {
        byte[] ret = new byte[size];
        int j = 0;
        int i = this.bufferOffset;
        while (i < this.bufferOffset + size) {
            if (i >= this.sorFileBuffer.length) break;
            ret[j] = this.sorFileBuffer[i];
            ++j;
            ++i;
        }
        this.bufferOffset += size;
        return ret;
    }

    private byte extractByte() {
        byte ret = 0;
        if (this.bufferOffset < this.sorFileBuffer.length) {
            ret = this.sorFileBuffer[this.bufferOffset];
            ++this.bufferOffset;
        }
        return ret;
    }

    private long extractUnsignedLong() {
        long ret = 0L;
        if (this.bufferOffset + 3 < this.sorFileBuffer.length) {
            ret = 0xFF & this.sorFileBuffer[this.bufferOffset + 3];
            ret <<= 8;
            ret |= (long)(0xFF & this.sorFileBuffer[this.bufferOffset + 2]);
            ret <<= 8;
            ret |= (long)(0xFF & this.sorFileBuffer[this.bufferOffset + 1]);
            ret <<= 8;
            ret |= (long)(0xFF & this.sorFileBuffer[this.bufferOffset]);
            this.bufferOffset += 4;
        }
        return ret;
    }

    private int extractLong() {
        int ret = 0;
        if (this.bufferOffset + 3 < this.sorFileBuffer.length) {
            ret = this.sorFileBuffer[this.bufferOffset + 3];
            ret <<= 8;
            ret |= 0xFF & this.sorFileBuffer[this.bufferOffset + 2];
            ret <<= 8;
            ret |= 0xFF & this.sorFileBuffer[this.bufferOffset + 1];
            ret <<= 8;
            ret |= 0xFF & this.sorFileBuffer[this.bufferOffset];
            this.bufferOffset += 4;
        }
        return ret;
    }

    private short extractShort() {
        short ret = 0;
        if (this.bufferOffset + 1 < this.sorFileBuffer.length) {
            ret = this.sorFileBuffer[this.bufferOffset + 1];
            ret = (short)(ret << 8);
            ret = (short)(ret | 0xFF & this.sorFileBuffer[this.bufferOffset]);
            this.bufferOffset += 2;
        }
        return ret;
    }

    private int extractUnsignedShort() {
        int ret = 0;
        if (this.bufferOffset + 1 < this.sorFileBuffer.length) {
            ret = 0xFF & this.sorFileBuffer[this.bufferOffset + 1];
            ret <<= 8;
            ret |= 0xFF & this.sorFileBuffer[this.bufferOffset];
            this.bufferOffset += 2;
        }
        return ret;
    }

    private boolean extractMapBlock() {
        boolean ret = true;
        this.startExtraction();
        this.map.blockID = this.extractString();
        if (this.map.blockID.toUpperCase().compareToIgnoreCase("MAP") != 0) {
            ret = false;
            return ret;
        }
        this.map.revisionNo = this.extractUnsignedShort();
        this.map.size = this.extractLong();
        this.map.numberOfBlocks = this.extractShort();
        if (this.map.mapItems != null) {
            this.map.mapItems = null;
        }
        this.map.mapItems = new MapItem[this.map.numberOfBlocks - 1];
        if (this.map.mapItems == null) {
            MainClass.QDEBUG("Vitalik - you are wrong!!!\n", new Object[0]);
        }
        this.isKeyEventsPresent = false;
        this.isLnkParamsPresent = false;
        this.isDataPtsPresent = false;
        this.isSVPReferenceParamsPresent = false;
        int blockNumber = 0;
        while (blockNumber < this.map.numberOfBlocks - 1) {
            MapItem mapItem = new MapItem();
            mapItem.id = this.extractString();
            mapItem.revisionNo = this.extractUnsignedShort();
            mapItem.size = this.extractLong();
            this.map.mapItems[blockNumber] = mapItem;
            if (this.map.mapItems[blockNumber].id.compareTo("KeyEvents") == 0) {
                this.isKeyEventsPresent = true;
            }
            if (this.map.mapItems[blockNumber].id.compareTo("LnkParams") == 0) {
                this.isLnkParamsPresent = true;
            }
            if (this.map.mapItems[blockNumber].id.compareTo("DataPts") == 0) {
                this.isDataPtsPresent = true;
            }
            if (this.map.mapItems[blockNumber].id.compareTo("SVPReferenceParams") == 0) {
                this.isSVPReferenceParamsPresent = true;
            }
            ++blockNumber;
        }
        return ret;
    }

    private void extractGenParamsBlock() {
        this.genParams.blockID = this.extractString();
        this.genParams.languageCode = this.extractByteArray(2);
        this.genParams.cableID = this.extractString();
        this.genParams.fiberID = this.extractString();
        this.genParams.fiberType = this.extractShort();
        this.genParams.nominalWaveLength = this.extractShort();
        this.genParams.originatingLocation = this.extractString();
        this.genParams.terminatingLocation = this.extractString();
        this.genParams.cableCode = this.extractString();
        this.genParams.currentDataFlag = this.extractByteArray(2);
        this.genParams.userOffset = this.extractLong();
        this.genParams.userOffsetDistance = this.extractLong();
        this.genParams.operatorCode = this.extractString();
        this.genParams.comment = this.extractString();
    }

    private void extractSupParamsBlock() {
        this.supParams.blockID = this.extractString();
        this.supParams.supplierName = this.extractString();
        this.supParams.otdrMainFrameID = this.extractString();
        this.supParams.otdrMainFrameSN = this.extractString();
        this.supParams.opticalModuleID = this.extractString();
        this.supParams.opticalModuleSN = this.extractString();
        this.supParams.softwareRevision = this.extractString();
        this.supParams.other = this.extractString();
    }

    private void extractFxdParamsBlock() {
        this.fxdParams.blockID = this.extractString();
        this.fxdParams.dateTimeStamp = this.extractUnsignedLong();
        this.fxdParams.unitsOfDistance = this.extractByteArray(2);
        this.fxdParams.distanceMultiplier = this.fxdParams.unitsOfDistance[0] == 107 && this.fxdParams.unitsOfDistance[1] == 109 ? 1.0f : (this.fxdParams.unitsOfDistance[0] == 109 && this.fxdParams.unitsOfDistance[1] == 116 ? 0.001f : (this.fxdParams.unitsOfDistance[0] == 102 && this.fxdParams.unitsOfDistance[1] == 116 ? 3.048E-4f : (this.fxdParams.unitsOfDistance[0] == 107 && this.fxdParams.unitsOfDistance[1] == 102 ? 0.3048f : (this.fxdParams.unitsOfDistance[0] == 109 && this.fxdParams.unitsOfDistance[1] == 105 ? 1.609344f : 1.0f))));
        this.fxdParams.actualWaveLength = this.extractShort();
        this.fxdParams.acquisitionOffset = this.extractLong();
        this.fxdParams.acquisitionOffsetDistance = this.extractLong();
        this.fxdParams.totalNumberOfPulseWidthsUsed = this.extractShort();
        this.fxdParams.createFxdParamsItems(this.fxdParams.totalNumberOfPulseWidthsUsed);
        int i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.fxdParams.pulseWidthsUsed[i] = this.extractShort();
            ++i;
        }
        i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.fxdParams.dataSpacing[i] = this.extractLong();
            ++i;
        }
        i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            this.fxdParams.numberOfDataPointsForEachPulseWidth[i] = this.extractLong();
            ++i;
        }
        this.fxdParams.groupIndex = this.extractLong();
        this.fxdParams.backscatterCoefficient = this.extractShort();
        this.fxdParams.numberOfAverages = this.extractLong();
        this.fxdParams.averagingTime = this.extractUnsignedShort();
        this.fxdParams.acquisitionRange = this.extractLong();
        this.fxdParams.acquisitionRangeDistance = this.extractLong();
        this.fxdParams.frontPannelOffset = this.extractLong();
        this.fxdParams.noiseFloorLevel = this.extractUnsignedShort();
        this.fxdParams.noiseFloorScaleFactor = this.extractShort();
        this.fxdParams.powerOffsetFirstPoint = this.extractUnsignedShort();
        this.fxdParams.lossThreshold = this.extractUnsignedShort();
        this.fxdParams.reflectanceThreshold = this.extractUnsignedShort();
        this.fxdParams.endOfFiberThreshold = this.extractUnsignedShort();
        this.fxdParams.traceType = this.extractByteArray(2);
        i = 0;
        while (i < 4) {
            this.fxdParams.windowCoordinates[i] = this.extractLong();
            ++i;
        }
    }

    private void extractKeyEventsBlock() {
        this.keyEvents.blockID = this.extractString();
        this.keyEvents.numberOfKeyEvents = this.extractShort();
        this.keyEvents.createKeyEventsItems(this.keyEvents.numberOfKeyEvents);
        int eventIndex = 0;
        while (eventIndex < this.keyEvents.numberOfKeyEvents) {
            KeyEventsItem keyEventItem = new KeyEventsItem();
            keyEventItem.eventNumber = this.extractShort();
            keyEventItem.eventPropagationTime = this.extractLong();
            keyEventItem.attenuationCoefficientLeadInFiber = this.extractShort();
            keyEventItem.eventLoss = this.extractShort();
            keyEventItem.eventReflectance = this.extractLong();
            keyEventItem.eventCode = this.extractByteArray(6);
            keyEventItem.lossMeasurmentTechnique = this.extractByteArray(2);
            int i = 0;
            while (i < 5) {
                keyEventItem.markerLocations[i] = this.extractLong();
                ++i;
            }
            keyEventItem.comment = this.extractString();
            this.keyEvents.events[eventIndex] = keyEventItem;
            ++eventIndex;
        }
        this.keyEvents.endToEndLoss = this.extractLong();
        this.keyEvents.endToEndMarkerPosition[0] = this.extractLong();
        this.keyEvents.endToEndMarkerPosition[1] = this.extractLong();
        this.keyEvents.opticalReturnLoss = this.extractUnsignedShort();
        this.keyEvents.opticalReturnLossMarkerPosition[0] = this.extractLong();
        this.keyEvents.opticalReturnLossMarkerPosition[1] = this.extractLong();
    }

    private void extractLnkParamsBlock() {
        this.lnkParams.blockID = this.extractString();
        this.lnkParams.totalNumberOfLandmarks = this.extractShort();
        this.lnkParams.createLnkParamsItem(this.lnkParams.totalNumberOfLandmarks);
        int landmarkIndex = 0;
        while (landmarkIndex < this.lnkParams.totalNumberOfLandmarks) {
            Landmark landmark = new Landmark();
            landmark.landmarkNumber = this.extractShort();
            landmark.landmarkCode = this.extractByteArray(2);
            landmark.landmarkLocation = this.extractLong();
            landmark.relatedEventNumber = this.extractShort();
            landmark.gpsInformation[0] = this.extractLong();
            landmark.gpsInformation[1] = this.extractLong();
            landmark.fiberCorrectionFactorLeadInFiber = this.extractShort();
            landmark.sheathMarkerEnteringLandmark = this.extractLong();
            landmark.sheathMarkerLeavingLandmark = this.extractLong();
            landmark.unitsOfSheathMarkerLeavingLandmark = this.extractByteArray(2);
            landmark.modeFieldDiameterLeavingLandmark = this.extractShort();
            landmark.comment = this.extractString();
            this.lnkParams.landmarks[landmarkIndex] = landmark;
            ++landmarkIndex;
        }
    }

    private void extractDataPtsBlock() {
        this.dataPts.blockID = this.extractString();
        this.dataPts.numberOfDataPoints = this.extractLong();
        this.dataPts.totalNumberScaleFactorsUsed = this.extractShort();
        this.dataPts.createDataPtsItems(this.dataPts.numberOfDataPoints, this.dataPts.totalNumberScaleFactorsUsed);
        this.dataPts.maxData = -2147.3853f;
        this.dataPts.minData = 2147.3853f;
        this.updatePositiveDistanceIndex();
        int dataIndex = 0;
        int i = 0;
        while (i < this.dataPts.totalNumberScaleFactorsUsed) {
            this.dataPts.totalDataPointsUsingScaleFactor[i] = this.extractLong();
            this.dataPts.scaleFactors[i] = this.extractShort();
            int j = 0;
            while (j < this.dataPts.totalDataPointsUsingScaleFactor[i]) {
                this.dataPts.data[dataIndex] = this.extractUnsignedShort();
                this.dataPts.scaledData[dataIndex] = (float)(this.dataPts.scaleFactors[i] * this.dataPts.data[dataIndex]) / 1000000.0f;
                if (dataIndex >= this.positiveDistanceIndex) {
                    this.dataPts.maxData = Math.max(this.dataPts.maxData, this.dataPts.scaledData[dataIndex]);
                    this.dataPts.minData = Math.min(this.dataPts.minData, this.dataPts.scaledData[dataIndex]);
                }
                ++dataIndex;
                ++j;
            }
            ++i;
        }
        this.exactMaxData = this.dataPts.maxData;
        float tmp = -65.0f;
        while (tmp < this.dataPts.maxData + 10.0f) {
            if (this.dataPts.maxData < tmp) {
                this.dataPts.maxData = tmp;
                break;
            }
            tmp += 5.0f;
        }
        tmp = 65.0f;
        while (tmp > this.dataPts.minData - 10.0f) {
            if (this.dataPts.minData >= tmp) {
                this.dataPts.minData = tmp;
                break;
            }
            tmp -= 5.0f;
        }
        this.recalcIndexAfterPulse();
    }

    public void extractSVPReferenceParamsBlock() {
        this.svpReferenceParams.blockID = this.extractString();
        this.svpReferenceParams.lossDeviation = this.extractUnsignedShort();
        this.svpReferenceParams.reflectanceDeviation = this.extractUnsignedShort();
        this.svpReferenceParams.lossCoefficientDeviation = this.extractUnsignedShort();
        this.svpReferenceParams.fullLossDeviation = this.extractUnsignedShort();
        this.svpReferenceParams.filterCode = this.extractByteArray(this.svpReferenceParams.filterCode.length);
        this.svpReferenceParams.isLowPower = this.extractByte();
        this.svpReferenceParams.isHighResolution = this.extractByte();
        this.svpReferenceParams.reserved = this.extractByteArray(this.svpReferenceParams.reserved.length);
    }

    public LSALineParameters get2PLine(int x1, int x2) {
        LSALineParameters ret = new LSALineParameters();
        if (this.dataPts == null) {
            return ret;
        }
        if (this.dataPts.scaledData == null) {
            return ret;
        }
        double y1 = this.dataPts.scaledData[x1];
        double y2 = this.dataPts.scaledData[x2];
        double a = (y1 - y2) / (double)(x1 - x2);
        double b = y1 - (double)x1 * a;
        ret.setA((float)a);
        ret.setB((float)b);
        return ret;
    }

    public double getAngleBetweenLSALines(LSALineParameters line1, LSALineParameters line2) {
        double k1 = line1.getA();
        double k2 = line2.getA();
        double ret = Math.acos(Math.abs(k1 * k2 + 1.0) / (Math.sqrt(1.0 + k1 * k1) * Math.sqrt(1.0 + k2 * k2)));
        return ret;
    }

    public LSALineParameters getLSALine(int ix1, int ix2) {
        LSALineParameters ret = new LSALineParameters();
        if (this.dataPts == null) {
            return ret;
        }
        if (this.dataPts.scaledData == null) {
            return ret;
        }
        if (ix1 > ix2) {
            int tmpIX = ix1;
            ix1 = ix2;
            ix2 = tmpIX;
        }
        double n = ix2 - ix1 + 1;
        double averY = 0.0;
        double averX = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        int ix = ix1;
        while (ix <= ix2) {
            averY += (double)this.dataPts.scaledData[ix];
            averX += (double)ix;
            sumXY += (double)ix * (double)this.dataPts.scaledData[ix];
            sumX2 += (double)ix * (double)ix;
            ++ix;
        }
        double denominator = sumX2 - n * (averX /= n) * averX;
        double b = ((averY /= n) * sumX2 - averX * sumXY) / denominator;
        double a = (sumXY - n * averX * averY) / denominator;
        ret.setA((float)a);
        ret.setB((float)b);
        return ret;
    }

    public double getLSAAttenuationCoefficient(int lsa0_i, int lsa1_i) {
        double ret = 0.0;
        if (lsa0_i > lsa1_i) {
            int tmp_i = lsa0_i;
            lsa0_i = lsa1_i;
            lsa1_i = tmp_i;
        }
        if (lsa0_i != lsa1_i && lsa0_i >= 0 && lsa1_i >= 0 && lsa0_i < this.dataPts.numberOfDataPoints && lsa1_i < this.dataPts.numberOfDataPoints) {
            LSALineParameters lsaLP = this.getLSALine(lsa0_i, lsa1_i);
            ret = (double)(lsaLP.getY(lsa1_i) - lsaLP.getY(lsa0_i)) / this.recalcDistance(lsa0_i, lsa1_i);
        }
        return ret;
    }

    public DeadZones calcDeadZones(MainClass.MeasureMode measureMode) {
        DeadZones retDZ = new DeadZones();
        retDZ.eventDeadZone = -1.0f;
        retDZ.eventDeadZoneTelcordia = -1.0f;
        retDZ.attenuationDeadZone = -1.0f;
        if (this.dataPts.scaledData != null && MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS == measureMode) {
            LSALineParameters lsaLine = this.getLSALine(this.cursor[1].getDataIndex(), this.cursor[3].getDataIndex());
            int i = this.cursor[1].getDataIndex();
            while (this.cursor[4].getDataIndex() < i) {
                float diff = (float)Math.round((lsaLine.getY(i) - this.dataPts.scaledData[i]) * 10.0f) / 10.0f;
                if (diff >= 0.05f) break;
                --i;
            }
            retDZ.attenuationDeadZone = (float)this.recalcDistance(this.cursor[4].getDataIndex(), i) * 1000.0f;
            MainClass.QDEBUG("aDZ[%d-%d]=%f\n", this.cursor[4].getDataIndex(), i, Float.valueOf(retDZ.attenuationDeadZone));
            int minIndex = this.cursor[4].getDataIndex();
            float min = this.dataPts.scaledData[minIndex];
            i = this.cursor[4].getDataIndex();
            while (i < this.cursor[1].getDataIndex()) {
                if (min > this.dataPts.scaledData[i]) {
                    minIndex = i;
                    min = this.dataPts.scaledData[minIndex];
                }
                ++i;
            }
            i = minIndex;
            while (i < this.cursor[1].getDataIndex()) {
                float diff = (float)Math.round((this.dataPts.scaledData[i] - min) * 10.0f) / 10.0f;
                if (diff >= 1.5f) break;
                ++i;
            }
            int end = i;
            i = minIndex;
            while (i > this.cursor[4].getDataIndex()) {
                if (this.dataPts.scaledData[i] - this.dataPts.scaledData[end] >= 0.0f) break;
                --i;
            }
            int begin = i;
            retDZ.eventDeadZone = (float)this.recalcDistance(begin, end) * 1000.0f;
            retDZ.eventDeadZoneTelcordia = (float)this.recalcDistance(this.cursor[4].getDataIndex(), end) * 1000.0f;
            MainClass.QDEBUG("eDZ[%d-%d]=%f\n", begin, end, Float.valueOf(retDZ.eventDeadZone));
            MainClass.QDEBUG("eDZTelcordia[%d-%d]=%f\n", this.cursor[4].getDataIndex(), end, Float.valueOf(retDZ.eventDeadZoneTelcordia));
        }
        return retDZ;
    }

    public boolean extractSorFile() {
        boolean ret = true;
        ret = this.extractMapBlock();
        if (!ret) {
            return ret;
        }
        int i = 0;
        while (i < this.map.numberOfBlocks - 1) {
            if (this.map.mapItems[i].id.compareTo("GenParams") == 0) {
                this.extractGenParamsBlock();
            } else if (this.map.mapItems[i].id.compareTo("SupParams") == 0) {
                this.extractSupParamsBlock();
            } else if (this.map.mapItems[i].id.compareTo("FxdParams") == 0) {
                this.extractFxdParamsBlock();
            } else if (this.map.mapItems[i].id.compareTo("KeyEvents") == 0) {
                this.extractKeyEventsBlock();
            } else if (this.map.mapItems[i].id.compareTo("LnkParams") == 0) {
                this.extractLnkParamsBlock();
            } else if (this.map.mapItems[i].id.compareTo("DataPts") == 0) {
                this.extractDataPtsBlock();
            } else if (this.map.mapItems[i].id.compareTo("SVPReferenceParams") == 0) {
                this.extractSVPReferenceParamsBlock();
            } else {
                this.bufferOffset += this.map.mapItems[i].size;
            }
            ++i;
        }
        return ret;
    }

    public void createFromBuffer(byte[] buffer) {
        this.sorFileBuffer = buffer;
        this.extractSorFile();
    }

    public boolean verifyCheckSum(boolean verify) {
        boolean ret = !verify;
        int len = this.sorFileBufferSize;
        int storedCRC = 0;
        if (len < 2) {
            return false;
        }
        byte iTmp = this.sorFileBuffer[len - 1];
        storedCRC |= (0xFF & iTmp) << 8;
        iTmp = this.sorFileBuffer[len - 2];
        storedCRC |= 0xFF & iTmp;
        int calcCRC = this.calcCRCCCITT16(this.sorFileBuffer, this.sorFileBufferSize - 2, 65535);
        if (verify) {
            if (calcCRC != storedCRC) {
                System.out.println("CRC failed");
                System.out.printf("storedCRC = 0x%x != 0x%x = calcTabCRC\n", storedCRC, calcCRC);
            } else {
                ret = true;
            }
        }
        this.cksum.checksum = calcCRC;
        return ret;
    }

    private int calcCRCCCITT16(byte[] buffer, int bufferLen, int startValue) {
        int crc = startValue;
        int i = 0;
        while (i < bufferLen) {
            int ser_data = 0xFF & buffer[i];
            crc = 0xFF & crc >> 8 | crc << 8;
            crc ^= ser_data;
            crc ^= 0xFF & (crc & 0xFF) >> 4;
            crc ^= 0xFFFF & crc << 8 << 4;
            crc ^= 0xFFFF & (crc & 0xFF) << 4 << 1;
            ++i;
        }
        return crc & 0xFFFF;
    }

    public void setDefaultMeasureParameters(MainClass mClass) {
        this.cursor[0].setDataIndex(this.positiveDistanceIndex);
        this.cursor[0].setShown(true);
        this.cursor[2].setDataIndex(this.positiveDistanceIndex);
        this.cursor[2].setShown(false);
        this.cursor[1].setDataIndex(this.positiveDistanceIndex + this.dataPts.numberOfDataPoints / 2);
        this.cursor[1].setShown(true);
        this.cursor[3].setDataIndex(this.positiveDistanceIndex + this.dataPts.numberOfDataPoints / 2);
        this.cursor[3].setShown(false);
        this.cursor[4].setDataIndex((this.cursor[0].getDataIndex() + this.cursor[1].getDataIndex()) / 2);
        this.cursor[4].setShown(false);
        this.activeCursor = 1;
        mClass.xScale = mClass.yScale = mClass.scaleList[0];
        this.indexOffset = this.positiveDistanceIndex;
        this.yOffset = 0;
    }

    public short fixEvent(MainClass.MeasureMode measureMode, short movedEventIndex) {
        short result = -1;
        short eventIndex = 0;
        OTDRCursor[] eventCursor = new OTDRCursor[this.cursor.length];
        int i = 0;
        while (i < eventCursor.length) {
            eventCursor[i] = new OTDRCursor();
            eventCursor[i].setDataIndex(this.cursor[i].getDataIndex());
            ++i;
        }
        LSALineParameters[] eventLSALine = new LSALineParameters[this.lsaLine.length];
        i = 0;
        while (i < eventLSALine.length) {
            eventLSALine[i] = new LSALineParameters();
            eventLSALine[i].setA(this.lsaLine[i].getA());
            eventLSALine[i].setB(this.lsaLine[i].getB());
            ++i;
        }
        float reflectanceThreshold = -((float)this.fxdParams.reflectanceThreshold) / 1000.0f;
        float attenuationCoefficientLeadInFiber = 0.0f;
        float eventPropagationTime = 0.0f;
        float eventLoss = 0.0f;
        float eventReflectance = 0.0f;
        float tmpDistance = 0.0f;
        byte[] lossMeasurmentTechnique = new byte[2];
        int[] markerLocations = new int[5];
        eventPropagationTime = MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS == measureMode ? this.getIndexTime(eventCursor[4].getDataIndex()) : this.getIndexTime(eventCursor[0].getDataIndex());
        eventIndex = movedEventIndex >= 0 && movedEventIndex < this.keyEvents.numberOfKeyEvents ? movedEventIndex : this.keyEvents.insertKeyEvent(Math.round(eventPropagationTime));
        result = eventIndex;
        if (eventIndex < 0) {
            return result;
        }
        if (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS != measureMode) {
            if (eventIndex > 0) {
                if (this.keyEvents.events[eventIndex - 1].lossMeasurmentTechnique[0] == 76 && this.keyEvents.events[eventIndex - 1].lossMeasurmentTechnique[1] == 83) {
                    eventCursor[2].setDataIndex(this.getTimeIndex(this.keyEvents.events[eventIndex - 1].markerLocations[2]));
                } else {
                    eventCursor[2].setDataIndex(this.getTimeIndex(this.keyEvents.events[eventIndex - 1].markerLocations[1]));
                }
            } else {
                eventCursor[2].setDataIndex(Math.min(this.getIndexAfterPulse(), eventCursor[0].getDataIndex()));
            }
            eventCursor[4] = eventCursor[0];
            if (MainClass.MeasureMode.MEASURE_MODE_REFLECTANCE == measureMode) {
                int rightLimit = eventIndex < this.keyEvents.numberOfKeyEvents - 1 ? this.getTimeIndex(this.keyEvents.events[eventIndex + 1].eventPropagationTime) : this.dataPts.numberOfDataPoints - 1;
                while (this.dataPts.scaledData[eventCursor[1].getDataIndex()] < this.dataPts.scaledData[eventCursor[0].getDataIndex()]) {
                    eventCursor[1].setDataIndex(eventCursor[1].getDataIndex() + 1);
                    if (eventCursor[1].getDataIndex() >= rightLimit - 1) break;
                }
                eventCursor[1].setDataIndex(eventCursor[1].getDataIndex() + this.getIndexAfterPulse() / 2);
                if (eventCursor[1].getDataIndex() >= rightLimit - 1) {
                    eventCursor[1].setDataIndex(rightLimit - 1);
                }
                if (eventIndex < this.keyEvents.numberOfKeyEvents - 1) {
                    eventCursor[3].setDataIndex(rightLimit);
                } else {
                    eventCursor[3].setDataIndex(eventCursor[1].getDataIndex() + (this.dataPts.numberOfDataPoints - eventCursor[1].getDataIndex()) / 10);
                }
                if (eventCursor[3].getDataIndex() >= rightLimit) {
                    eventCursor[3].setDataIndex(rightLimit);
                }
            }
        }
        eventLSALine[0] = this.getLSALine(eventCursor[2].getDataIndex(), eventCursor[0].getDataIndex());
        eventLSALine[1] = this.getLSALine(eventCursor[3].getDataIndex(), eventCursor[1].getDataIndex());
        tmpDistance = (float)this.recalcDistance(eventCursor[2].getDataIndex(), eventCursor[0].getDataIndex());
        float attenuation = eventLSALine[0].getY(eventCursor[0].getDataIndex()) - eventLSALine[0].getY(eventCursor[2].getDataIndex());
        attenuationCoefficientLeadInFiber = attenuation / tmpDistance;
        if (Float.isNaN(attenuationCoefficientLeadInFiber) || Float.isInfinite(attenuationCoefficientLeadInFiber)) {
            attenuationCoefficientLeadInFiber = 0.0f;
        }
        switch (measureMode) {
            case MEASURE_MODE_2P_LOSS: {
                eventLoss = this.dataPts.scaledData[this.cursor[1].getDataIndex()] - this.dataPts.scaledData[this.cursor[0].getDataIndex()];
                eventReflectance = 0.0f;
                lossMeasurmentTechnique[0] = 50;
                lossMeasurmentTechnique[1] = 80;
                markerLocations[0] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                markerLocations[1] = Math.round(this.getIndexTime(eventCursor[1].getDataIndex()));
                markerLocations[2] = 0;
                markerLocations[3] = 0;
                markerLocations[4] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                break;
            }
            case MEASURE_MODE_APPROX_LOSS: {
                eventLoss = this.lsaLine[0].getY(this.cursor[1].getDataIndex()) - this.lsaLine[0].getY(this.cursor[0].getDataIndex());
                eventReflectance = 0.0f;
                lossMeasurmentTechnique[0] = 50;
                lossMeasurmentTechnique[1] = 80;
                markerLocations[0] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                markerLocations[1] = Math.round(this.getIndexTime(eventCursor[1].getDataIndex()));
                markerLocations[2] = 0;
                markerLocations[3] = 0;
                markerLocations[4] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                break;
            }
            case MEASURE_MODE_LSA_LOSS: {
                eventLoss = eventLSALine[1].getY(eventCursor[4].getDataIndex()) - eventLSALine[0].getY(eventCursor[4].getDataIndex());
                float f = 0.0f;
                int i2 = eventCursor[0].getDataIndex();
                while (i2 <= eventCursor[1].getDataIndex()) {
                    f = Math.max(this.dataPts.scaledData[eventCursor[0].getDataIndex()] - this.dataPts.scaledData[i2], f);
                    ++i2;
                }
                eventReflectance = this.calcReflectance(-f);
                if (reflectanceThreshold > eventReflectance) {
                    eventReflectance = 0.0f;
                }
                lossMeasurmentTechnique[0] = 76;
                lossMeasurmentTechnique[1] = 83;
                markerLocations[0] = Math.round(this.getIndexTime(eventCursor[2].getDataIndex()));
                markerLocations[1] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                markerLocations[2] = Math.round(this.getIndexTime(eventCursor[1].getDataIndex()));
                markerLocations[3] = Math.round(this.getIndexTime(eventCursor[3].getDataIndex()));
                markerLocations[4] = Math.round(this.getIndexTime(eventCursor[4].getDataIndex()));
                break;
            }
            case MEASURE_MODE_REFLECTANCE: {
                eventLoss = eventLSALine[1].getY(eventCursor[4].getDataIndex()) - eventLSALine[0].getY(eventCursor[4].getDataIndex());
                eventReflectance = this.calcReflectance(this.cursor[0].getDataIndex(), this.cursor[1].getDataIndex());
                lossMeasurmentTechnique[0] = 76;
                lossMeasurmentTechnique[1] = 83;
                markerLocations[0] = Math.round(this.getIndexTime(eventCursor[2].getDataIndex()));
                markerLocations[1] = Math.round(this.getIndexTime(eventCursor[0].getDataIndex()));
                markerLocations[2] = Math.round(this.getIndexTime(eventCursor[1].getDataIndex()));
                markerLocations[3] = Math.round(this.getIndexTime(eventCursor[3].getDataIndex()));
                markerLocations[4] = Math.round(this.getIndexTime(eventCursor[4].getDataIndex()));
                break;
            }
            default: {
                result = -1;
            }
        }
        if (result >= 0) {
            this.keyEvents.events[eventIndex].eventNumber = (short)(eventIndex + 1);
            this.keyEvents.events[eventIndex].eventPropagationTime = Math.round(eventPropagationTime);
            this.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber = (short)Math.round(attenuationCoefficientLeadInFiber * 1000.0f);
            float tmpLoss = eventLoss * 1000.0f;
            if (tmpLoss < -32768.0f) {
                tmpLoss = -32768.0f;
            }
            if (tmpLoss > 32767.0f) {
                tmpLoss = 32767.0f;
            }
            this.keyEvents.events[eventIndex].eventLoss = (short)Math.round(tmpLoss);
            this.keyEvents.events[eventIndex].eventReflectance = Math.round(eventReflectance * 1000.0f);
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique = lossMeasurmentTechnique;
            this.keyEvents.events[eventIndex].eventCode[0] = 0.0f != eventReflectance ? 49 : 48;
            float et = (float)this.fxdParams.endOfFiberThreshold / 1000.0f;
            this.keyEvents.events[eventIndex].eventCode[1] = Math.abs(eventLoss) >= et && eventIndex == this.keyEvents.numberOfKeyEvents - 1 ? 68 : 65;
            this.keyEvents.events[eventIndex].eventCode[2] = 57;
            this.keyEvents.events[eventIndex].eventCode[3] = 57;
            this.keyEvents.events[eventIndex].eventCode[4] = 57;
            this.keyEvents.events[eventIndex].eventCode[5] = 57;
            this.keyEvents.events[eventIndex].markerLocations = markerLocations;
            this.keyEvents.events[eventIndex].comment = "";
            if (eventIndex < this.keyEvents.numberOfKeyEvents - 1) {
                int index1;
                int index0 = eventCursor[1].getDataIndex();
                if (this.keyEvents.events[eventIndex + 1].lossMeasurmentTechnique[0] == 76 && this.keyEvents.events[eventIndex + 1].lossMeasurmentTechnique[1] == 83) {
                    index1 = this.getTimeIndex(this.keyEvents.events[eventIndex + 1].markerLocations[1]);
                    this.keyEvents.events[eventIndex + 1].markerLocations[0] = Math.round(this.getIndexTime(index0));
                } else {
                    index1 = this.getTimeIndex(this.keyEvents.events[eventIndex + 1].markerLocations[0]);
                }
                eventLSALine[0] = this.getLSALine(index0, index1);
                tmpDistance = (float)this.recalcDistance(index0, index1);
                attenuation = eventLSALine[0].getY(index1) - eventLSALine[0].getY(index0);
                attenuationCoefficientLeadInFiber = attenuation / tmpDistance;
                if (Float.isNaN(attenuationCoefficientLeadInFiber) || Float.isInfinite(attenuationCoefficientLeadInFiber)) {
                    attenuationCoefficientLeadInFiber = 0.0f;
                }
                this.keyEvents.events[eventIndex + 1].attenuationCoefficientLeadInFiber = (short)Math.round(attenuationCoefficientLeadInFiber * 1000.0f);
            }
        } else {
            this.keyEvents.deleteEvent(eventIndex);
        }
        eventCursor = null;
        eventLSALine = null;
        return result;
    }

    public void deleteEventsBetweenCursors(int index1, int index2) {
        if (index1 > index2) {
            int tmpIndex = index1;
            index1 = index2;
            index2 = tmpIndex;
        }
        float psec100time1 = this.getIndexTime(index1);
        float psec100time2 = this.getIndexTime(index2);
        int i = 0;
        while (i < this.keyEvents.numberOfKeyEvents) {
            float eventPsec100time = this.keyEvents.events[i].eventPropagationTime;
            if (eventPsec100time >= psec100time1 && eventPsec100time <= psec100time2) {
                this.keyEvents.deleteEvent((short)i);
                continue;
            }
            ++i;
        }
    }

    private double getRealDistance(int index) {
        double realDistance = 0.0;
        double pointWeight = 0.0;
        double dx = 0.0;
        double lx = 0.0;
        double rx = index;
        realDistance = 299792.46875 * (1.0E-10 * (double)this.getFirstPointTime()) / ((double)this.fxdParams.groupIndex * 1.0E-5);
        double fx = 0.0;
        int i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            if (lx >= rx) break;
            if (!(lx >= (fx += (double)this.fxdParams.numberOfDataPointsForEachPulseWidth[i]))) {
                dx = fx - lx > rx - lx ? rx - lx : fx - lx;
                lx += dx;
                pointWeight = 299792.46875 * (1.0E-10 * (double)this.fxdParams.dataSpacing[i] / 10000.0) / ((double)this.fxdParams.groupIndex * 1.0E-5);
                realDistance += dx * pointWeight;
            }
            ++i;
        }
        return realDistance;
    }

    public double recalcDistance(int index) {
        double distance = this.getRealDistance(index);
        if (distance < 0.0) {
            distance = 0.0;
        }
        return distance;
    }

    public double recalcDistance(int index0, int index1) {
        if (index0 == index1) {
            return 0.0;
        }
        if (index0 > index1) {
            int tmpIndex = index1;
            index1 = index0;
            index0 = tmpIndex;
        }
        return this.recalcDistance(index1) - this.recalcDistance(index0);
    }

    public void updatePositiveDistanceIndex() {
        int tmpZI = 0;
        if (this.dataPts != null) {
            tmpZI = 0;
            while (tmpZI < this.dataPts.numberOfDataPoints) {
                double rd = this.getRealDistance(tmpZI);
                if (rd >= 0.0) break;
                ++tmpZI;
            }
        }
        this.positiveDistanceIndex = tmpZI;
    }

    private float getPulseWidthOnTheScreenInNanoseconds(float nsRealPw, float mHzBandWidth) {
        float pW = (float)Math.sqrt(Math.pow(nsRealPw / 1.0E9f, 2.0) + Math.pow(0.35f / (mHzBandWidth * 1000000.0f), 2.0)) * 1.0E9f / 2.0f;
        MainClass.QDEBUG(false, "pWOnScreen(ns) = %f\n", Float.valueOf(pW));
        return pW;
    }

    private int getPulseWidthOnTheScreenInDataPoints(float nsRealPw, float mHzBandWidth) {
        float pulseWidth_ns = this.getPulseWidthOnTheScreenInNanoseconds(nsRealPw, mHzBandWidth);
        int pIndex = this.getTimeIndex((int)Math.ceil(this.getIndexTime(0)) + Math.round(pulseWidth_ns * 10.0f));
        MainClass.QDEBUG(false, "pIndex (screen) = %d\n", pIndex);
        return pIndex;
    }

    public int getIndexAfterPulse() {
        return this.getIndexAfterPulse(false);
    }

    public int getIndexAfterPulse(boolean pulseWidthOnly) {
        this.recalcIndexAfterPulse();
        MainClass.QDEBUG(false, "GIAP 1. indexAfterPulse= %d, justPulseIndex = %d\n", this.afterPulseIndex, this.justPulseIndex);
        if (pulseWidthOnly) {
            return this.justPulseIndex;
        }
        return this.afterPulseIndex;
    }

    private void recalcIndexAfterPulse() {
        if (this.dataPts.scaledData != null) {
            int rightExtremumIndex;
            int maxPulseEndIndex;
            int maxPulseIndex = this.getPulseWidthOnTheScreenInDataPoints(this.fxdParams.pulseWidthsUsed[0], 0.33f);
            int minPulseIndex = this.getPulseWidthOnTheScreenInDataPoints(this.fxdParams.pulseWidthsUsed[0], 100.0f);
            MainClass.QDEBUG(false, "RIAP 1. minPulseIndex = %d, maxPulseIndex = %d\n", minPulseIndex, maxPulseIndex);
            if (2 > minPulseIndex) {
                minPulseIndex = 2;
            }
            if (minPulseIndex + 3 > maxPulseIndex) {
                maxPulseIndex = minPulseIndex + 3;
            }
            int minPulseEndIndex = Math.max(0, this.getTimeIndex(0) + minPulseIndex);
            int testEndIndex = maxPulseEndIndex = Math.max(0, this.getTimeIndex(0) + maxPulseIndex);
            float possibleDeltaDBForCrackDetermination = 0.2f * (float)this.recalcDistance(this.dataPts.numberOfDataPoints - 1);
            possibleDeltaDBForCrackDetermination = Math.min(possibleDeltaDBForCrackDetermination, 1.0f);
            MainClass.QDEBUG("possibleDeltaDBForCrackDetermination = %f dB\n", Float.valueOf(possibleDeltaDBForCrackDetermination));
            int j = minPulseEndIndex;
            while (j <= maxPulseEndIndex) {
                testEndIndex = j;
                if (Math.abs(this.dataPts.scaledData[j] - this.exactMaxData) < possibleDeltaDBForCrackDetermination) break;
                ++j;
            }
            MainClass.QDEBUG(false, "RIAP 2. minPulseEndIndex = %d, maxPulseEndIndex = %d, testEndIndex = %d\n", minPulseEndIndex, maxPulseEndIndex, testEndIndex);
            boolean testIndexBecomesAdecvate = false;
            int i = rightExtremumIndex = minPulseEndIndex;
            float rightExtremumData = this.dataPts.scaledData[rightExtremumIndex];
            boolean isCrackStarted = false;
            int crackCount = 0;
            int firstCrackDataIndex = rightExtremumIndex;
            int rightLimitIndex = Math.min((this.dataPts.numberOfDataPoints - 1) / 16, maxPulseEndIndex + 9 * maxPulseIndex - minPulseIndex);
            while (testEndIndex < rightLimitIndex) {
                if (Math.abs(this.dataPts.scaledData[testEndIndex] - this.exactMaxData) < possibleDeltaDBForCrackDetermination) {
                    if (!isCrackStarted) {
                        if (crackCount == 0) {
                            firstCrackDataIndex = testEndIndex;
                        }
                        isCrackStarted = true;
                        if (1 < ++crackCount) {
                            testEndIndex = firstCrackDataIndex;
                            break;
                        }
                    }
                } else if (isCrackStarted) {
                    isCrackStarted = false;
                }
                if (rightExtremumData - this.dataPts.scaledData[i] >= 0.0f) {
                    rightExtremumIndex = i;
                    rightExtremumData = this.dataPts.scaledData[rightExtremumIndex];
                }
                float tmpV = (float)this.getLSAAttenuationCoefficient(testEndIndex, testEndIndex + minPulseIndex);
                if (!testIndexBecomesAdecvate && tmpV > 0.0f && tmpV < 1.0f) {
                    testIndexBecomesAdecvate = true;
                }
                if (testIndexBecomesAdecvate && (tmpV < 0.0f || tmpV > 1.0f)) break;
                ++testEndIndex;
                ++i;
            }
            MainClass.QDEBUG(false, "RIAP 3. testEndIndex(adecvate:)) = %d, rightExtremumIndex = %d\n", testEndIndex, rightExtremumIndex);
            float maxAttCoeff = 0.0f;
            int maxAttCoeffIndex = rightExtremumIndex;
            isCrackStarted = false;
            crackCount = 0;
            firstCrackDataIndex = rightExtremumIndex;
            i = rightExtremumIndex;
            while (i < testEndIndex) {
                if ((float)this.getLSAAttenuationCoefficient(minPulseEndIndex, i) > maxAttCoeff) {
                    maxAttCoeff = (float)this.getLSAAttenuationCoefficient(minPulseEndIndex, i);
                    maxAttCoeffIndex = i;
                }
                if (!(this.getLSAAttenuationCoefficient(i, Math.min(i + minPulseIndex, testEndIndex)) > 1.0)) {
                    LSALineParameters lsaLine;
                    this.isEndOfFiberJustAfterPulse = false;
                    if (Math.abs(this.dataPts.scaledData[i] - this.exactMaxData) < possibleDeltaDBForCrackDetermination) {
                        if (!isCrackStarted) {
                            if (crackCount == 0) {
                                firstCrackDataIndex = i;
                            }
                            isCrackStarted = true;
                            if (1 < ++crackCount) {
                                maxAttCoeffIndex = i = firstCrackDataIndex;
                                this.isEndOfFiberJustAfterPulse = true;
                                break;
                            }
                        }
                    } else if (isCrackStarted) {
                        isCrackStarted = false;
                    }
                    if ((lsaLine = this.getLSALine(i, testEndIndex)).getY(i) - this.dataPts.scaledData[i] < 0.4f && lsaLine.getY(testEndIndex) - this.dataPts.scaledData[testEndIndex] < 0.4f) break;
                }
                ++i;
            }
            this.afterPulseIndex = i;
            this.justPulseIndex = maxAttCoeffIndex;
        }
    }

    public int getTimeIndex(int psec100time) {
        int index = 0;
        double sectime = 100.0 * (double)(psec100time -= this.getFirstPointTime()) * 1.0E-11;
        double time = 0.0;
        if (this.fxdParams.totalNumberOfPulseWidthsUsed == 1) {
            index = (int)Math.round(10000.0 * (double)psec100time / (double)this.fxdParams.dataSpacing[0]);
            if (index > this.dataPts.numberOfDataPoints - 1) {
                index = this.dataPts.numberOfDataPoints - 1;
            }
            return index;
        }
        int i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            time += (double)(this.fxdParams.numberOfDataPointsForEachPulseWidth[i] - 1) * ((double)1.0E-9f * (double)this.fxdParams.dataSpacing[i] / 10000.0);
            index += this.fxdParams.numberOfDataPointsForEachPulseWidth[i] - 1;
            if (time >= sectime) {
                double pointWeight = 299792.46875 * ((double)1.0E-9f * (double)this.fxdParams.dataSpacing[i] / 10000.0) / ((double)this.fxdParams.groupIndex * (double)1.0E-4f);
                double overtime = time - sectime;
                int overindex = (int)Math.round(299792.46875 * overtime / ((double)this.fxdParams.groupIndex * (double)1.0E-4f) / pointWeight);
                index -= overindex;
                break;
            }
            ++i;
        }
        if (index > this.dataPts.numberOfDataPoints - 1) {
            index = this.dataPts.numberOfDataPoints - 1;
        }
        return index;
    }

    public float getIndexTime(int index) {
        float psec100time = this.getFirstPointTime();
        int tmp_index = 0;
        int i = 0;
        while (i < this.fxdParams.totalNumberOfPulseWidthsUsed) {
            psec100time += (float)(this.fxdParams.numberOfDataPointsForEachPulseWidth[i] - 1) * ((float)this.fxdParams.dataSpacing[i] / 10000.0f);
            if ((tmp_index += this.fxdParams.numberOfDataPointsForEachPulseWidth[i] - 1) >= index) {
                int overindex = tmp_index - index;
                float overtime = (float)overindex * ((float)this.fxdParams.dataSpacing[i] / 10000.0f);
                psec100time -= overtime;
                break;
            }
            ++i;
        }
        return psec100time;
    }

    int getFirstPointTime() {
        int psec100time;
        if (this.fxdParams.acquisitionOffsetDistance != 0) {
            double distance = (double)this.fxdParams.acquisitionOffsetDistance / 10.0;
            psec100time = (int)Math.round((distance *= (double)this.fxdParams.distanceMultiplier) * ((double)this.fxdParams.groupIndex * 1.0E-5) / 2.9979246874999998E-5);
        } else {
            psec100time = this.fxdParams.acquisitionOffset;
        }
        return psec100time;
    }

    public void changeActiveCursor() {
        int i = this.activeCursor + 1;
        while (true) {
            if (i > this.cursor.length - 1) {
                i = 0;
                continue;
            }
            if (this.cursor[i].isShown()) break;
            ++i;
        }
        this.activeCursor = i;
    }

    public void setCursorsFixed(boolean to) {
        this.isCursorsFixed = to;
    }

    public boolean isCursorsFixed() {
        return this.isCursorsFixed;
    }

    private void setFixedCursorsAccordingToActive(int dataIndexForActiveCursor, MainClass.MeasureMode mm) {
        int oldDataIndexForActiveCursor = this.cursor[this.activeCursor].getDataIndex();
        int deltaIndex = dataIndexForActiveCursor - oldDataIndexForActiveCursor;
        int boundingCursor = deltaIndex < 0 ? (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS == mm ? 2 : 0) : (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS == mm ? 3 : 1);
        if (this.cursor[boundingCursor].getDataIndex() + deltaIndex > this.dataPts.numberOfDataPoints - 1) {
            deltaIndex = this.dataPts.numberOfDataPoints - 1 - this.cursor[boundingCursor].getDataIndex();
        }
        if (this.cursor[boundingCursor].getDataIndex() + deltaIndex < 0) {
            deltaIndex = -(this.cursor[boundingCursor].getDataIndex() - 1);
        }
        int i = 0;
        while (i < 5) {
            this.cursor[i].setDataIndex(this.cursor[i].getDataIndex() + deltaIndex);
            ++i;
        }
    }

    public void setActiveCursorWithRangeControl(int dataIndex, MainClass.MeasureMode mm) {
        if (this.isCursorsFixed) {
            this.setFixedCursorsAccordingToActive(dataIndex, mm);
            return;
        }
        int oldActiveCursor = this.activeCursor;
        if (MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS != mm) {
            if (1 == this.activeCursor) {
                if (this.cursor[1].getDataIndex() - this.cursor[0].getDataIndex() == 1 && dataIndex <= this.cursor[0].getDataIndex()) {
                    this.activeCursor = 0;
                } else {
                    dataIndex = Math.max(dataIndex, this.cursor[0].getDataIndex() + 1);
                }
            } else if (this.activeCursor == 0) {
                if (this.cursor[1].getDataIndex() - this.cursor[0].getDataIndex() == 1 && dataIndex >= this.cursor[1].getDataIndex()) {
                    this.activeCursor = 1;
                } else {
                    dataIndex = Math.min(dataIndex, this.cursor[1].getDataIndex() - 1);
                }
            }
        } else {
            switch (this.activeCursor) {
                case 2: {
                    if (this.cursor[0].getDataIndex() - this.cursor[2].getDataIndex() == 1 && dataIndex >= this.cursor[0].getDataIndex()) {
                        this.activeCursor = 0;
                    } else {
                        dataIndex = Math.min(dataIndex, this.cursor[0].getDataIndex() - 1);
                    }
                    int tmpDataIndex = Math.min(this.cursor[0].getDataIndex() - 1, this.cursor[0].getDataIndex());
                    this.cursor[2].setDataIndex(tmpDataIndex);
                    break;
                }
                case 0: {
                    if (this.cursor[4].getDataIndex() - this.cursor[0].getDataIndex() == 1 && dataIndex >= this.cursor[4].getDataIndex()) {
                        this.activeCursor = 4;
                    } else if (this.cursor[0].getDataIndex() - this.cursor[2].getDataIndex() == 1 && dataIndex <= this.cursor[2].getDataIndex()) {
                        this.activeCursor = 2;
                    } else {
                        dataIndex = Math.min(dataIndex, this.cursor[4].getDataIndex() - 1);
                        dataIndex = Math.max(dataIndex, this.cursor[2].getDataIndex() + 1);
                    }
                    int tmpDataIndex = Math.min(this.cursor[4].getDataIndex() - 1, this.cursor[0].getDataIndex());
                    tmpDataIndex = Math.max(this.cursor[2].getDataIndex() + 1, tmpDataIndex);
                    this.cursor[0].setDataIndex(tmpDataIndex);
                    break;
                }
                case 4: {
                    if (this.cursor[4].getDataIndex() - this.cursor[0].getDataIndex() == 1 && dataIndex <= this.cursor[0].getDataIndex()) {
                        this.activeCursor = 0;
                    } else if (this.cursor[1].getDataIndex() - this.cursor[4].getDataIndex() == 1 && dataIndex >= this.cursor[1].getDataIndex()) {
                        this.activeCursor = 1;
                    } else {
                        dataIndex = Math.min(dataIndex, this.cursor[1].getDataIndex() - 1);
                        dataIndex = Math.max(dataIndex, this.cursor[0].getDataIndex() + 1);
                    }
                    int tmpDataIndex = Math.min(this.cursor[1].getDataIndex() - 1, this.cursor[4].getDataIndex());
                    tmpDataIndex = Math.max(this.cursor[0].getDataIndex() + 1, tmpDataIndex);
                    this.cursor[4].setDataIndex(tmpDataIndex);
                    break;
                }
                case 1: {
                    if (this.cursor[3].getDataIndex() - this.cursor[1].getDataIndex() == 1 && dataIndex >= this.cursor[3].getDataIndex()) {
                        this.activeCursor = 3;
                    } else if (this.cursor[1].getDataIndex() - this.cursor[4].getDataIndex() == 1 && dataIndex <= this.cursor[4].getDataIndex()) {
                        this.activeCursor = 4;
                    } else {
                        dataIndex = Math.min(dataIndex, this.cursor[3].getDataIndex() - 1);
                        dataIndex = Math.max(dataIndex, this.cursor[4].getDataIndex() + 1);
                    }
                    int tmpDataIndex = Math.min(this.cursor[3].getDataIndex() - 1, this.cursor[1].getDataIndex());
                    tmpDataIndex = Math.max(this.cursor[4].getDataIndex() + 1, tmpDataIndex);
                    this.cursor[1].setDataIndex(tmpDataIndex);
                    break;
                }
                case 3: {
                    if (this.cursor[3].getDataIndex() - this.cursor[1].getDataIndex() == 1 && dataIndex <= this.cursor[1].getDataIndex()) {
                        this.activeCursor = 1;
                    } else {
                        dataIndex = Math.max(dataIndex, this.cursor[1].getDataIndex() + 1);
                    }
                    int tmpDataIndex = Math.max(this.cursor[1].getDataIndex() + 1, this.cursor[3].getDataIndex());
                    this.cursor[3].setDataIndex(tmpDataIndex);
                    break;
                }
            }
        }
        if (oldActiveCursor == this.activeCursor) {
            if (dataIndex < this.positiveDistanceIndex) {
                dataIndex = this.positiveDistanceIndex;
            }
            if (dataIndex > this.dataPts.numberOfDataPoints - 1) {
                dataIndex = this.dataPts.numberOfDataPoints - 1;
            }
            this.cursor[this.activeCursor].setDataIndex(dataIndex);
        }
    }

    public void moveActiveCursor(int offset, MainClass.MeasureMode mm) {
        int dataIndex = this.cursor[this.activeCursor].getDataIndex();
        this.setActiveCursorWithRangeControl(dataIndex += offset, mm);
    }

    public void recalcXYSteps(MainClass mainClass, float width, float height, SorFile referenceSorFile) {
        if (this.dataPts.scaledData != null) {
            if (mainClass == null) {
                this.yStep = (height - 1.0f) / Math.abs(this.dataPts.maxData - this.dataPts.minData);
                this.xStep = width / (float)this.dataPts.numberOfDataPoints;
                this.pointWeight = 1.0f / this.xStep;
            } else if (this == referenceSorFile) {
                this.yStep = (height - 1.0f) / Math.abs(this.dataPts.maxData - this.dataPts.minData);
                this.xStep = width / (float)this.dataPts.numberOfDataPoints;
                this.yStep *= Float.valueOf(mainClass.yScale).floatValue();
                this.xStep *= Float.valueOf(mainClass.xScale).floatValue();
                this.pointWeight = 1.0f / this.xStep;
            } else {
                this.indexOffset = this.getTimeIndex(Math.round(referenceSorFile.getIndexTime(referenceSorFile.indexOffset)));
                this.yOffset = referenceSorFile.yOffset;
                this.yStep = referenceSorFile.yStep;
                this.xStep = referenceSorFile.xStep * (float)this.fxdParams.dataSpacing[0] / (float)referenceSorFile.fxdParams.dataSpacing[0];
                this.pointWeight = 1.0f / this.xStep;
            }
        }
    }

    public float calcORL(int index0, int index1) {
        float L;
        float t;
        float n;
        float c;
        float v;
        float q;
        float Q;
        float S;
        float logarifm_arg;
        float alpha_p;
        float alpha_dB;
        float retORL = 0.0f;
        if (this.dataPts.scaledData == null) {
            return retORL;
        }
        if (1310 == this.genParams.nominalWaveLength) {
            alpha_dB = 0.33f;
            alpha_p = 0.063f;
        } else if (1550 == this.genParams.nominalWaveLength) {
            alpha_dB = 0.195f;
            alpha_p = 0.032f;
        } else {
            alpha_dB = 0.25f;
            alpha_p = 0.065f;
        }
        if (index1 < index0) {
            int tmpIndex = index0;
            index0 = index1;
            index1 = tmpIndex;
        }
        float reflTerm = 0.0f;
        if (this.isKeyEventsPresent) {
            int i = 0;
            while (i < this.keyEvents.numberOfKeyEvents) {
                int eventIndex = this.getTimeIndex(this.keyEvents.events[i].eventPropagationTime);
                if (eventIndex >= index0 && eventIndex <= index1) {
                    float ct = this.keyEvents.events[i].attenuationCoefficientLeadInFiber != 0 ? (float)this.keyEvents.events[i].attenuationCoefficientLeadInFiber / 1000.0f : alpha_dB;
                    float eventRefl = (float)this.keyEvents.events[i].eventReflectance / 1000.0f;
                    if (eventRefl > 0.0f) {
                        float eventL = (float)this.recalcDistance(index0, eventIndex);
                        reflTerm = (float)((double)reflTerm + Math.pow(10.0, eventRefl / 10.0f) * Math.exp(-2.0f * ct * eventL));
                    }
                }
                ++i;
            }
        }
        if ((retORL = -10.0f * (float)Math.log10((logarifm_arg = (S = (Q = (float)Math.pow(10.0, (q = -((float)this.fxdParams.backscatterCoefficient / 10.0f) + 10.0f * (float)Math.log10(this.fxdParams.pulseWidthsUsed[0])) / 10.0f)) / alpha_p / (v = (c = 299792.47f) / (n = (float)this.fxdParams.groupIndex / 100000.0f)) / ((t = (float)this.fxdParams.pulseWidthsUsed[0] / 1.0E9f) / 2.0f)) * (1.0f - (float)Math.exp(-2.0f * alpha_dB * (L = (float)this.recalcDistance(index0, index1)))) / 2.0f) + reflTerm)) < 0.0f) {
            retORL = 0.0f;
        }
        return retORL;
    }

    public float calcReflectance(float attenuationBetweenCursors) {
        float retReflectance = 0.0f;
        float q = (float)this.fxdParams.backscatterCoefficient / 10.0f + 10.0f * (float)Math.log10(1.0f / (float)this.fxdParams.pulseWidthsUsed[0]);
        retReflectance = -q + 10.0f * (float)Math.log10((float)Math.pow(10.0, 0.2f * -attenuationBetweenCursors) - 1.0f);
        return retReflectance;
    }

    public float calcReflectance(int index0, int index1) {
        float retReflectance = 0.0f;
        if (this.dataPts.scaledData == null) {
            return retReflectance;
        }
        if (index1 < index0) {
            int tmpIndex = index0;
            index0 = index1;
            index1 = tmpIndex;
        }
        float attenuationBetweenCursors = this.dataPts.scaledData[index1] - this.dataPts.scaledData[index0];
        retReflectance = this.calcReflectance(attenuationBetweenCursors);
        return retReflectance;
    }

    public void doDerivative() {
        this.dataPts.maxData = -2147.3853f;
        this.dataPts.minData = 2147.3853f;
        if (this.dataPts.scaledData == null) {
            return;
        }
        int i = 0;
        while (i < this.dataPts.numberOfDataPoints - 1) {
            this.dataPts.scaledData[i] = this.dataPts.scaledData[i + 1] - this.dataPts.scaledData[i];
            if (i < this.dataPts.numberOfDataPoints - 2) {
                this.dataPts.maxData = Math.max(this.dataPts.maxData, this.dataPts.scaledData[i]);
                this.dataPts.minData = Math.min(this.dataPts.minData, this.dataPts.scaledData[i]);
            }
            ++i;
        }
    }

    public void doAnalysisByTemplateEvents(SorFile templateSorFile) {
        int eventIndex;
        this.keyEvents.flagOfComparisonWithTemplate = 0L;
        if (templateSorFile == null) {
            return;
        }
        if (templateSorFile.keyEvents == null) {
            return;
        }
        int startIndex = this.getIndexAfterPulse();
        while (this.keyEvents.numberOfKeyEvents > 0) {
            this.keyEvents.deleteEvent((short)(this.keyEvents.numberOfKeyEvents - 1));
        }
        boolean isEndOfFiberFound = this.findEndOfFiber(true, false);
        if (isEndOfFiberFound) {
            if (this.keyEvents.numberOfKeyEvents > 0 && templateSorFile.keyEvents.numberOfKeyEvents > 0) {
                int cursor2;
                int cursor1 = this.getTimeIndex(this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventPropagationTime);
                boolean isShorter = cursor1 < (cursor2 = this.getTimeIndex(templateSorFile.keyEvents.events[templateSorFile.keyEvents.numberOfKeyEvents - 1].eventPropagationTime));
                float distanceInMeters = (float)(1000.0 * this.recalcDistance(cursor1, cursor2));
                float pointWeight0InMeters = (float)(2.9979248E8 * (1.0E-10 * (double)this.fxdParams.dataSpacing[0] / 10000.0) / ((double)this.fxdParams.groupIndex * 1.0E-5));
                float minimumDistanceInMeters = 15.0f;
                if (distanceInMeters > (minimumDistanceInMeters = Math.max(pointWeight0InMeters * 3.0f, minimumDistanceInMeters)) && isShorter) {
                    this.keyEvents.flagOfComparisonWithTemplate |= 0x40L;
                } else if (distanceInMeters > minimumDistanceInMeters * 10.0f && !isShorter) {
                    this.keyEvents.flagOfComparisonWithTemplate |= 0x80L;
                }
                MainClass.QDEBUG("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD\n", new Object[0]);
                MainClass.QDEBUG("distanceInMeters = %.1f, pointWeight0InMeters = %.2f\n", Float.valueOf(isShorter ? -distanceInMeters : distanceInMeters), Float.valueOf(pointWeight0InMeters));
                MainClass.QDEBUG("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD\n", new Object[0]);
                if (0L != (this.keyEvents.flagOfComparisonWithTemplate & 0x40L) || 0L != (this.keyEvents.flagOfComparisonWithTemplate & 0x80L)) {
                    this.keyEvents.breakageDistanceKM = (float)this.recalcDistance(cursor1);
                }
            }
        } else {
            this.keyEvents.flagOfComparisonWithTemplate |= 0x20L;
        }
        this.saveCursors();
        while (this.keyEvents.numberOfKeyEvents > 0) {
            this.keyEvents.deleteEvent((short)(this.keyEvents.numberOfKeyEvents - 1));
        }
        int eventPropagationTime = Math.round(this.getIndexTime(0));
        float reflectance = this.calcRefclectanceFromConnecter(startIndex);
        if (!MainClass.isFloatNormal(reflectance)) {
            reflectance = 0.0f;
        }
        if (-1 != (eventIndex = this.keyEvents.insertKeyEvent(eventPropagationTime))) {
            this.keyEvents.events[eventIndex].eventPropagationTime = eventPropagationTime;
            this.keyEvents.events[eventIndex].eventReflectance = Math.round(1000.0f * reflectance);
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] = 79;
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[1] = 84;
            this.keyEvents.events[eventIndex].markerLocations[0] = Math.round(this.getIndexTime(0));
            this.keyEvents.events[eventIndex].markerLocations[1] = Math.round(this.getIndexTime(startIndex));
            this.keyEvents.events[eventIndex].markerLocations[2] = 0;
            this.keyEvents.events[eventIndex].markerLocations[3] = 0;
            this.keyEvents.events[eventIndex].markerLocations[4] = 0;
            this.keyEvents.events[eventIndex].eventCode[0] = 0.0f == reflectance ? 48 : 49;
            this.keyEvents.events[eventIndex].eventCode[1] = 70;
            this.keyEvents.events[eventIndex].eventCode[2] = 57;
            this.keyEvents.events[eventIndex].eventCode[3] = 57;
            this.keyEvents.events[eventIndex].eventCode[4] = 57;
            this.keyEvents.events[eventIndex].eventCode[5] = 57;
        }
        MainClass.QDEBUG("number of template events is %d\n", templateSorFile.keyEvents.numberOfKeyEvents);
        eventIndex = 0;
        while (eventIndex < templateSorFile.keyEvents.numberOfKeyEvents) {
            MainClass.MeasureMode measureMode;
            int maxIndex;
            int minIndex;
            if (!(templateSorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] != 76 && templateSorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] != 108 || templateSorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[1] != 83 && templateSorFile.keyEvents.events[eventIndex].lossMeasurmentTechnique[1] != 115)) {
                this.cursor[2].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[0]));
                this.cursor[0].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[1]));
                this.cursor[1].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[2]));
                this.cursor[3].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[3]));
                this.cursor[4].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[4]));
                if (this.cursor[3].getDataIndex() > this.dataPts.numberOfDataPoints - 1) {
                    this.cursor[3].setDataIndex(this.dataPts.numberOfDataPoints - 1);
                }
                if (this.cursor[1].getDataIndex() >= this.cursor[3].getDataIndex()) {
                    this.cursor[1].setDataIndex(this.cursor[3].getDataIndex() - 1);
                }
                minIndex = this.cursor[4].getDataIndex();
                maxIndex = this.cursor[4].getDataIndex();
                measureMode = MainClass.MeasureMode.MEASURE_MODE_LSA_LOSS;
            } else {
                this.cursor[0].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[0]));
                this.cursor[1].setDataIndex(this.getTimeIndex(templateSorFile.keyEvents.events[eventIndex].markerLocations[1]));
                minIndex = this.cursor[0].getDataIndex();
                maxIndex = this.cursor[1].getDataIndex();
                measureMode = 49 == templateSorFile.keyEvents.events[eventIndex].eventCode[0] ? MainClass.MeasureMode.MEASURE_MODE_REFLECTANCE : MainClass.MeasureMode.MEASURE_MODE_2P_LOSS;
            }
            MainClass.QDEBUG("eventIndex(%d), maxIndex = %d\n", eventIndex, maxIndex);
            if (maxIndex > this.dataPts.numberOfDataPoints - 1) break;
            if (minIndex < startIndex) {
                if (this.keyEvents.numberOfKeyEvents > 0 && templateSorFile.isSVPReferenceParamsPresent && this.keyEvents.events[0].eventPropagationTime == templateSorFile.keyEvents.events[eventIndex].eventPropagationTime) {
                    this.keyEvents.events[0].templateEventReflectance = templateSorFile.keyEvents.events[eventIndex].eventReflectance;
                    float dRefl = (float)this.keyEvents.events[0].eventReflectance / 1000.0f - (float)templateSorFile.keyEvents.events[eventIndex].eventReflectance / 1000.0f;
                    if (dRefl > (float)templateSorFile.svpReferenceParams.reflectanceDeviation / 1000.0f && templateSorFile.svpReferenceParams.reflectanceDeviation != 0) {
                        this.keyEvents.events[0].flagOfComparisonWithTemplate |= 2L;
                    }
                }
            } else {
                MainClass.QDEBUG("trying to fix event for template event number %d\n", eventIndex);
                short newEventIndex = this.fixEvent(measureMode, (short)-1);
                MainClass.QDEBUG("newEventIndex = %d\n", newEventIndex);
                if (newEventIndex >= 0 && templateSorFile.isSVPReferenceParamsPresent) {
                    this.keyEvents.events[newEventIndex].templateEventReflectance = templateSorFile.keyEvents.events[eventIndex].eventReflectance;
                    this.keyEvents.events[newEventIndex].templateEventLoss = templateSorFile.keyEvents.events[eventIndex].eventLoss;
                    this.keyEvents.events[newEventIndex].templateAttenuationCoefficientLeadInFiber = templateSorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber;
                    float dRefl = (float)this.keyEvents.events[newEventIndex].eventReflectance / 1000.0f - (float)templateSorFile.keyEvents.events[eventIndex].eventReflectance / 1000.0f;
                    float dLoss = (float)this.keyEvents.events[newEventIndex].eventLoss / 1000.0f - (float)templateSorFile.keyEvents.events[eventIndex].eventLoss / 1000.0f;
                    float dLossCoeff = (float)this.keyEvents.events[newEventIndex].attenuationCoefficientLeadInFiber / 1000.0f - (float)templateSorFile.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber / 1000.0f;
                    if (dRefl > (float)templateSorFile.svpReferenceParams.reflectanceDeviation / 1000.0f && templateSorFile.svpReferenceParams.reflectanceDeviation != 0) {
                        this.keyEvents.events[newEventIndex].flagOfComparisonWithTemplate |= 2L;
                    }
                    if (68 != templateSorFile.keyEvents.events[eventIndex].eventCode[1] && 69 != templateSorFile.keyEvents.events[eventIndex].eventCode[1] && 100 != templateSorFile.keyEvents.events[eventIndex].eventCode[1] && 101 != templateSorFile.keyEvents.events[eventIndex].eventCode[1] && Math.abs(dLoss) > (float)templateSorFile.svpReferenceParams.lossDeviation / 1000.0f && templateSorFile.svpReferenceParams.lossDeviation != 0) {
                        this.keyEvents.events[newEventIndex].flagOfComparisonWithTemplate |= 1L;
                    }
                    if (Math.abs(dLossCoeff) > (float)templateSorFile.svpReferenceParams.lossCoefficientDeviation / 1000.0f && templateSorFile.svpReferenceParams.lossCoefficientDeviation != 0) {
                        this.keyEvents.events[newEventIndex].flagOfComparisonWithTemplate |= 4L;
                    }
                }
            }
            ++eventIndex;
        }
        this.restoreCursors();
        short i = 0;
        while (i < this.keyEvents.numberOfKeyEvents) {
            this.keyEvents.flagOfComparisonWithTemplate |= this.keyEvents.events[i].flagOfComparisonWithTemplate;
            i = (short)(i + 1);
        }
        this.keyEvents.endToEndMarkerPosition[0] = templateSorFile.keyEvents.endToEndMarkerPosition[0];
        this.keyEvents.endToEndMarkerPosition[1] = templateSorFile.keyEvents.endToEndMarkerPosition[1];
        int c1 = this.getTimeIndex(this.keyEvents.endToEndMarkerPosition[0]);
        int c2 = this.getTimeIndex(this.keyEvents.endToEndMarkerPosition[1]);
        float endToEndLoss = this.dataPts.scaledData[c2] - this.dataPts.scaledData[c1];
        this.keyEvents.endToEndLoss = Math.round(1000.0f * endToEndLoss);
        this.keyEvents.opticalReturnLossMarkerPosition[0] = templateSorFile.keyEvents.opticalReturnLossMarkerPosition[0];
        this.keyEvents.opticalReturnLossMarkerPosition[1] = templateSorFile.keyEvents.opticalReturnLossMarkerPosition[1];
        c1 = this.getTimeIndex(this.keyEvents.opticalReturnLossMarkerPosition[0]);
        float orl = this.calcORL(c1, c2 = this.getTimeIndex(this.keyEvents.opticalReturnLossMarkerPosition[1]));
        if (!MainClass.isFloatNormal(orl)) {
            orl = 0.0f;
        }
        this.keyEvents.opticalReturnLoss = Math.round(1000.0f * orl);
        if (templateSorFile.isSVPReferenceParamsPresent) {
            this.keyEvents.templateEndToEndLoss = templateSorFile.keyEvents.endToEndLoss;
            this.keyEvents.templateOpticalReturnLoss = templateSorFile.keyEvents.opticalReturnLoss;
            float dFulloss = (float)(this.keyEvents.endToEndLoss - templateSorFile.keyEvents.endToEndLoss) / 1000.0f;
            if (dFulloss > (float)templateSorFile.svpReferenceParams.fullLossDeviation / 1000.0f && templateSorFile.svpReferenceParams.fullLossDeviation != 0) {
                this.keyEvents.flagOfComparisonWithTemplate |= 8L;
            }
        }
        this.createSorFileBuffer();
    }

    private float calcRefclectanceFromConnecter(int startIndex) {
        int minIndex = 0;
        int i = 0;
        while (i < startIndex) {
            if (this.dataPts.scaledData[minIndex] > this.dataPts.scaledData[i]) {
                minIndex = i;
            }
            ++i;
        }
        float reflectance = this.calcReflectance(this.dataPts.scaledData[minIndex] - this.dataPts.scaledData[startIndex]);
        return reflectance;
    }

    private boolean findEndOfFiber(boolean deleteIfExists, boolean moveEndIfBeforeIndexAfterPulse) {
        int startIndex;
        boolean ret = false;
        if (this.keyEvents.numberOfKeyEvents > 0 && (this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 69 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 79 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 68 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 101 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 111 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].eventCode[1] == 100)) {
            if (deleteIfExists) {
                this.keyEvents.deleteEvent((short)(this.keyEvents.numberOfKeyEvents - 1));
            } else {
                return true;
            }
        }
        int leftLimit = 0;
        int leftMarkerIndex = startIndex = this.getIndexAfterPulse();
        if (this.keyEvents.numberOfKeyEvents > 0) {
            leftLimit = !(this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].lossMeasurmentTechnique[0] != 76 && this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].lossMeasurmentTechnique[0] != 108 || this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].lossMeasurmentTechnique[1] != 83 && this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].lossMeasurmentTechnique[1] != 115) ? this.getTimeIndex(this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].markerLocations[2]) : this.getTimeIndex(this.keyEvents.events[this.keyEvents.numberOfKeyEvents - 1].markerLocations[1]);
        }
        leftMarkerIndex = Math.max(leftMarkerIndex, leftLimit);
        float et = (float)this.fxdParams.endOfFiberThreshold / 1000.0f;
        float rt = (float)this.fxdParams.reflectanceThreshold / 1000.0f;
        RoughKeyEvents roughKeyEvents = this.findReflectRoughEventsAndEndOfFiber(startIndex, et, rt);
        if (roughKeyEvents == null) {
            MainClass.QDEBUG("1. findEndOfFiber: NULL == roughKeyEvents\n", new Object[0]);
            return ret;
        }
        if (roughKeyEvents.numberOfKeyEvents > 0) {
            int eventPropagationTime;
            short eventIndex;
            int[] tmpCursor = new int[5];
            int i = roughKeyEvents.numberOfKeyEvents - 1;
            if (moveEndIfBeforeIndexAfterPulse && roughKeyEvents.events[i].eventBeginDataIndex < this.afterPulseIndex) {
                roughKeyEvents.events[i].eventBeginDataIndex = this.afterPulseIndex;
                roughKeyEvents.events[i].eventEndDataIndex = Math.min(roughKeyEvents.events[i].eventBeginDataIndex + 1, this.dataPts.numberOfDataPoints - 1);
            }
            tmpCursor[4] = roughKeyEvents.events[i].eventBeginDataIndex;
            tmpCursor[0] = Math.max(0, roughKeyEvents.events[i].eventBeginDataIndex - 1);
            tmpCursor[2] = i > 0 ? Math.max(leftMarkerIndex, roughKeyEvents.events[i - 1].eventEndDataIndex) : leftMarkerIndex;
            tmpCursor[3] = this.dataPts.numberOfDataPoints - 1;
            tmpCursor[1] = tmpCursor[3] - 1;
            this.lsaLine[0] = this.getLSALine(tmpCursor[2], tmpCursor[0]);
            this.lsaLine[1] = this.getLSALine(tmpCursor[3], tmpCursor[1]);
            if (0.0f == roughKeyEvents.events[i].reflectance) {
                int min_j = roughKeyEvents.events[i].eventBeginDataIndex;
                int j = roughKeyEvents.events[i].eventBeginDataIndex;
                while (j < roughKeyEvents.events[i].eventEndDataIndex) {
                    if (this.dataPts.scaledData[j] < this.dataPts.scaledData[min_j]) {
                        min_j = j;
                    }
                    ++j;
                }
                roughKeyEvents.events[i].reflectance = this.calcReflectance(roughKeyEvents.events[i].eventBeginDataIndex, min_j);
            }
            roughKeyEvents.events[i].eventLoss = this.lsaLine[1].getY(tmpCursor[4]) - this.lsaLine[0].getY(tmpCursor[4]);
            if (!MainClass.isFloatNormal(roughKeyEvents.events[i].eventLoss)) {
                roughKeyEvents.events[i].eventLoss = 0.0f;
            }
            if (!MainClass.isFloatNormal(roughKeyEvents.events[i].reflectance)) {
                roughKeyEvents.events[i].reflectance = 0.0f;
            }
            if (-1 == (eventIndex = this.keyEvents.insertKeyEvent(eventPropagationTime = Math.round(this.getIndexTime(roughKeyEvents.events[i].eventBeginDataIndex))))) {
                MainClass.QDEBUG("2. findEndOfFiber: eventIndex = -1!!!!!!!!!!!!!!!!!!!!! ERROR!!!!!!!!!!!\n", new Object[0]);
                return ret;
            }
            if (eventIndex != this.keyEvents.numberOfKeyEvents - 1) {
                MainClass.QDEBUG("3. findEndOfFiber: eventIndex != keyEvents->numberOfKeyEvents - 1!!!!!!!!!!!!!!!!!!!!! ERROR!!!!!!!!!!!\n", new Object[0]);
                return ret;
            }
            this.keyEvents.events[eventIndex].eventPropagationTime = eventPropagationTime;
            this.keyEvents.events[eventIndex].eventReflectance = Math.round(1000.0f * roughKeyEvents.events[i].reflectance);
            float tmpDistance = (float)this.recalcDistance(tmpCursor[2], tmpCursor[0]);
            this.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber = (short)((this.lsaLine[0].getY(tmpCursor[0]) - this.lsaLine[0].getY(tmpCursor[2])) / tmpDistance * 1000.0f);
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] = 76;
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[1] = 83;
            this.keyEvents.events[eventIndex].markerLocations[0] = Math.round(this.getIndexTime(tmpCursor[2]));
            this.keyEvents.events[eventIndex].markerLocations[1] = Math.round(this.getIndexTime(tmpCursor[0]));
            this.keyEvents.events[eventIndex].markerLocations[2] = Math.round(this.getIndexTime(tmpCursor[1]));
            this.keyEvents.events[eventIndex].markerLocations[3] = Math.round(this.getIndexTime(tmpCursor[3]));
            this.keyEvents.events[eventIndex].markerLocations[4] = Math.round(this.getIndexTime(tmpCursor[4]));
            this.keyEvents.events[eventIndex].eventCode[0] = this.keyEvents.events[eventIndex].eventReflectance == 0 ? 48 : 49;
            if (roughKeyEvents.events[i].eventBeginDataIndex == this.dataPts.numberOfDataPoints - 1) {
                this.keyEvents.events[eventIndex].eventCode[1] = 79;
                this.keyEvents.events[eventIndex].comment = "out of range without finding end of fiber";
            } else {
                this.keyEvents.events[eventIndex].eventCode[1] = 69;
                this.keyEvents.events[eventIndex].comment = "end of fiber";
            }
            this.keyEvents.events[eventIndex].eventCode[2] = 57;
            this.keyEvents.events[eventIndex].eventCode[3] = 57;
            this.keyEvents.events[eventIndex].eventCode[4] = 57;
            this.keyEvents.events[eventIndex].eventCode[5] = 57;
            float tmpVal = Math.round(roughKeyEvents.events[i].eventLoss * 1000.0f);
            if (tmpVal < -32768.0f) {
                tmpVal = -32768.0f;
            }
            if (tmpVal > 32767.0f) {
                tmpVal = 32767.0f;
            }
            this.keyEvents.events[eventIndex].eventLoss = (short)tmpVal;
            ret = true;
        }
        return ret;
    }

    private RoughKeyEventsItem findNextReflection(float et, float minRT, int startIndex, int peakPulseOffset, RoughKeyEventsItem prevRoughEventItem, RoughEventLimit[] roughEventLimits, RoughKeyEvents prevEvents) {
        int DEBUG_DATA_INDEX_LEFT_LIMIT = 293;
        int DEBUG_DATA_INDEX_RIGHT_LIMIT = 293;
        RoughKeyEventsItem tmpRoughEventItem = null;
        int testIndexOffset = startIndex * 3;
        int dataIndex = prevRoughEventItem.eventEndDataIndex + 1;
        float maxPulseWidth_ns = this.getPulseWidthOnTheScreenInNanoseconds(this.fxdParams.pulseWidthsUsed[0], 0.33f);
        float minPulseWidth_ns = this.getPulseWidthOnTheScreenInNanoseconds(this.fxdParams.pulseWidthsUsed[0], 100.0f);
        long someActionCounter = 0L;
        int limitsIndex = 0;
        while (limitsIndex < roughEventLimits.length) {
            if (tmpRoughEventItem != null) break;
            int dataIndexLimit = roughEventLimits[limitsIndex].right;
            MainClass.QDEBUG("left=%d, dataIndex=%d, dataIndexLimit=%d\n", roughEventLimits[limitsIndex].left, dataIndex, dataIndexLimit);
            if (dataIndex < roughEventLimits[limitsIndex].left) break;
            if (dataIndex <= dataIndexLimit) {
                int line1_width = startIndex;
                int line2_width = Math.min(3, peakPulseOffset);
                int leftLimitForAngleCalc = prevRoughEventItem.eventEndDataIndex + line1_width + 1;
                int rightLimitForAngleCalc = roughEventLimits[limitsIndex].right - line2_width - 1;
                while (dataIndex < dataIndexLimit) {
                    LSALineParameters lsaLineParameters;
                    int i;
                    boolean isEndOfFiber = false;
                    int tstIndex1 = Math.min(dataIndex + 1, roughEventLimits[limitsIndex].right);
                    int tstIndex2 = Math.min(dataIndex + peakPulseOffset, roughEventLimits[limitsIndex].right);
                    if (this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[tstIndex1] > 0.0f && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[tstIndex2] > 0.0f) {
                        float reflectance;
                        float tstVal;
                        int extremumIndex;
                        if (dataIndex > leftLimitForAngleCalc && dataIndex < rightLimitForAngleCalc) {
                            LSALineParameters line1 = this.getLSALine(dataIndex - line1_width, dataIndex);
                            LSALineParameters line2 = this.getLSALine(dataIndex, dataIndex + line2_width);
                            double angle = this.getAngleBetweenLSALines(line1, line2);
                            if ((angle *= 57.29577951308232) < 5.0) {
                                ++dataIndex;
                                continue;
                            }
                        }
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d]reflect?\n", dataIndex);
                        boolean isContinue = false;
                        int maxIndex = extremumIndex = dataIndex;
                        int minIndex = extremumIndex;
                        float maxDelta = this.dataPts.scaledData[maxIndex] - this.dataPts.scaledData[maxIndex + 1];
                        float minDelta = this.dataPts.scaledData[minIndex] - this.dataPts.scaledData[minIndex + 1];
                        int testEndIndex = Math.min(dataIndex + testIndexOffset, dataIndexLimit);
                        i = dataIndex;
                        while (i < testEndIndex) {
                            ++someActionCounter;
                            if (dataIndex < i && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[i] <= 0.0f) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "%d = \u043f\u0440\u043e\u0441\u0435\u0447\u043a\u0430-\u0441\u043f\u0430\u0434!!!\n", i);
                                break;
                            }
                            if (this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1] < minDelta && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[i] > 0.0f) {
                                minDelta = this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1];
                                minIndex = i;
                            }
                            if (this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1] > maxDelta && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[i + 1] > 0.0f) {
                                maxDelta = this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1];
                                maxIndex = i;
                            }
                            if (this.dataPts.scaledData[extremumIndex] - this.dataPts.scaledData[i] > 0.0f && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[i] > 0.0f) {
                                extremumIndex = i;
                            }
                            if (this.dataPts.scaledData[i] - this.dataPts.scaledData[Math.min(i + 1, this.dataPts.numberOfDataPoints - 1)] < 0.0f) {
                                int i_end = i + Math.min(10, startIndex);
                                if (i_end > this.dataPts.numberOfDataPoints - 1) {
                                    i_end = this.dataPts.numberOfDataPoints - 1;
                                }
                                tstVal = 0.0f;
                                if (i < i_end) {
                                    lsaLineParameters = this.getLSALine(i, i_end);
                                    tstVal = (lsaLineParameters.getY(i_end) - lsaLineParameters.getY(i)) / (float)this.recalcDistance(i, i_end);
                                }
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "1. tstVal[%d-%d]=%f\n", i, i_end, Float.valueOf(tstVal));
                                int j = -1;
                                if (tstVal > 10.0f) {
                                    j = i + 1;
                                    while (j < i_end) {
                                        if (this.dataPts.scaledData[j] - this.dataPts.scaledData[j + 1] < minDelta && this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[j] > 0.0f) {
                                            minDelta = this.dataPts.scaledData[j] - this.dataPts.scaledData[j + 1];
                                            minIndex = j;
                                        }
                                        if (this.dataPts.scaledData[i] - this.dataPts.scaledData[j] >= 0.0f) break;
                                        ++j;
                                    }
                                }
                                if (j == i_end) {
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "pulse falling starts from %d\n", i);
                                    if (minIndex >= extremumIndex) break;
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "%d = minIndex < extremumIndex = %d, correcting...\n", minIndex, extremumIndex);
                                    minIndex = extremumIndex;
                                    break;
                                }
                            }
                            ++i;
                        }
                        if (dataIndex > maxIndex || maxIndex >= extremumIndex || extremumIndex > minIndex) {
                            isContinue = true;
                        }
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "1. isContinue=%s\n", isContinue ? "yes" : "no");
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d](dataIndexLimit=%d, startIndex=%d), maxIndex=%d, extremumIndex=%d, minIndex=%d\n", dataIndex, dataIndexLimit, startIndex, maxIndex, extremumIndex, minIndex);
                        if (!(this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[maxIndex] >= 0.0f && this.dataPts.scaledData[maxIndex] - this.dataPts.scaledData[extremumIndex] > 0.0f && this.dataPts.scaledData[minIndex] - this.dataPts.scaledData[extremumIndex] >= 0.0f)) {
                            isContinue = true;
                        }
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "2. isContinue=%s\n", isContinue ? "yes" : "no");
                        int eventBeginDataIndex = dataIndex;
                        int eventEndDataIndex = dataIndex + testIndexOffset;
                        if (!isContinue) {
                            int lsa0_i = maxIndex;
                            int lsa1_i = Math.min(minIndex + startIndex, dataIndexLimit);
                            i = maxIndex;
                            while (i < dataIndexLimit) {
                                if (this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1] < minDelta) {
                                    minDelta = this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1];
                                    minIndex = i;
                                }
                                if (i - maxIndex > startIndex * 2) {
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "LONG END OF PULSE [%d-%d]\n", maxIndex, i);
                                    break;
                                }
                                float tstVal1 = (float)this.getLSAAttenuationCoefficient(dataIndex, lsa0_i);
                                if (this.dataPts.scaledData[i] - this.dataPts.scaledData[dataIndex] >= 0.0f && i > dataIndex && tstVal1 > 0.0f) {
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "%f = data[i=%d] > data[dataIndex=%d] = %f\n", Float.valueOf(this.dataPts.scaledData[i]), i, dataIndex, Float.valueOf(this.dataPts.scaledData[dataIndex]));
                                    break;
                                }
                                lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                                if (i > minIndex && lsa0_i != lsa1_i) {
                                    tstVal = lsaLineParameters.getY(lsa1_i) - lsaLineParameters.getY(lsa0_i);
                                    tstVal = (float)((double)tstVal / this.recalcDistance(lsa0_i, lsa1_i));
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "2. tstVal[%d-%d] = %f\n", lsa0_i, lsa1_i, Float.valueOf(tstVal));
                                    if (tstVal < 1.0f && tstVal1 > 0.0f) break;
                                }
                                if (lsa0_i < dataIndexLimit) {
                                    ++lsa0_i;
                                }
                                if (lsa1_i < dataIndexLimit) {
                                    ++lsa1_i;
                                }
                                ++i;
                            }
                            eventEndDataIndex = i;
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d] before minimization (dataIndexLimit=%d, startIndex=%d), maxIndex=%d, extremumIndex=%d, minIndex=%d\n", dataIndex, dataIndexLimit, startIndex, maxIndex, extremumIndex, minIndex);
                            i = maxIndex;
                            while (i < minIndex) {
                                if (i + 1 > dataIndexLimit || this.dataPts.scaledData[i + 1] - this.dataPts.scaledData[i] >= 0.0f || this.dataPts.scaledData[i - 1] - this.dataPts.scaledData[i] >= 0.1f) break;
                                maxIndex = i++;
                            }
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "middle minimization maxIndex = %d\n", maxIndex);
                            while (maxIndex > dataIndex) {
                                if (this.dataPts.scaledData[maxIndex - 1] - this.dataPts.scaledData[maxIndex] < 0.1f && this.dataPts.scaledData[maxIndex - 2] - this.dataPts.scaledData[maxIndex - 1] < 0.1f) break;
                                --maxIndex;
                            }
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "after minimization maxIndex = %d\n", maxIndex);
                            eventBeginDataIndex = maxIndex;
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "BEFORE LSA Line end pulse calibrating: eventBeginDataIndex = %d, eventEndDataIndex = %d\n", eventBeginDataIndex, eventEndDataIndex);
                            lsa0_i = eventBeginDataIndex;
                            lsa1_i = eventEndDataIndex;
                            if (lsa1_i > lsa0_i) {
                                lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                                while (lsa1_i < dataIndexLimit) {
                                    lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                                    if (lsaLineParameters.getY(lsa1_i) - this.dataPts.scaledData[lsa1_i] >= 0.0f) break;
                                    ++lsa1_i;
                                }
                                while (lsa1_i > lsa0_i) {
                                    lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                                    if (lsaLineParameters.getY(lsa1_i) - this.dataPts.scaledData[lsa1_i] < 0.0f) {
                                        ++lsa1_i;
                                        break;
                                    }
                                    --lsa1_i;
                                }
                                eventEndDataIndex = lsa1_i;
                            }
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "AFTER LSA Line end pulse calibrating: eventBeginDataIndex = %d, eventEndDataIndex = %d\n", eventBeginDataIndex, eventEndDataIndex);
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "eventBeginDataIndex = %d, eventEndDataIndex = %d\n", eventBeginDataIndex, eventEndDataIndex);
                            if ((double)0.1f > this.getLSAAttenuationCoefficient(eventBeginDataIndex, eventEndDataIndex)) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "NOISE ^ pulse attenuation!\n", new Object[0]);
                                isContinue = true;
                            } else if (0.2f > this.calcStandardDeviation(eventBeginDataIndex, eventEndDataIndex)) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "NOISE ^ standard deviation!\n", new Object[0]);
                                isContinue = true;
                            }
                            float tmpPulseWidth_ns = (this.getIndexTime(eventEndDataIndex - eventBeginDataIndex) - this.getIndexTime(0)) * 100.0f / 1000.0f;
                            if (tmpPulseWidth_ns > maxPulseWidth_ns * 6.0f) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "LONG ^ pulse  (tmpPulseWidth_ns=%f, maxPulseWidth_ns=%f)!\n", Float.valueOf(tmpPulseWidth_ns), Float.valueOf(maxPulseWidth_ns));
                                isContinue = true;
                            } else if (tmpPulseWidth_ns < minPulseWidth_ns) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "NOISE ^ pulse 1 (tmpPulseWidth_ns=%f, minPulseWidth_ns=%f)!\n", Float.valueOf(tmpPulseWidth_ns), Float.valueOf(minPulseWidth_ns));
                                isContinue = true;
                            }
                            if (eventEndDataIndex > dataIndexLimit) {
                                eventEndDataIndex = dataIndexLimit;
                            }
                            lsa0_i = eventEndDataIndex;
                            lsa1_i = Math.min(eventEndDataIndex + startIndex, dataIndexLimit);
                            lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                            tstVal = (float)this.getLSAAttenuationCoefficient(lsa0_i, lsa1_i);
                            while (tstVal >= 1.0f) {
                                tstVal = (float)this.getLSAAttenuationCoefficient(lsa0_i, lsa1_i);
                                ++lsa0_i;
                                if (++lsa1_i > dataIndexLimit) break;
                            }
                            int endOFFiberTestIndexLimit = Math.min(lsa1_i, dataIndexLimit);
                            int endOfFiberLossCounter = 0;
                            i = eventEndDataIndex;
                            while (i <= endOFFiberTestIndexLimit) {
                                if (this.dataPts.scaledData[i] - this.dataPts.scaledData[eventBeginDataIndex] >= et) {
                                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "EOF#%d loss from %d to %d\n", ++endOfFiberLossCounter, eventBeginDataIndex, i);
                                }
                                ++i;
                            }
                            if (endOfFiberLossCounter > 1) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[minRT = %f]: reflect END of fiber from %d to %d \n", Float.valueOf(minRT), eventBeginDataIndex, eventEndDataIndex);
                                isEndOfFiber = true;
                            }
                            lsa0_i = eventBeginDataIndex;
                            lsa1_i = minIndex + 1;
                            lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                            LSALineParameters tpLineParameters = this.get2PLine(lsa0_i, lsa1_i);
                            if (!isEndOfFiber && !isContinue) {
                                if (this.dataPts.scaledData[lsa0_i] - lsaLineParameters.getY(lsa0_i) > 0.0f && this.dataPts.scaledData[lsa1_i] - lsaLineParameters.getY(lsa1_i) > 0.0f) {
                                    i = lsa0_i;
                                    while (i < lsa1_i) {
                                        if (tpLineParameters.getY(i) - lsaLineParameters.getY(i) <= 0.0f) {
                                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "LSA and 2P lines were crossed %d\n", i);
                                            isContinue = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                } else {
                                    isContinue = true;
                                }
                            }
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d-%d]isContinue = %s\n", lsa0_i, lsa1_i, isContinue ? "yes" : "no");
                            i = maxIndex;
                            while (i < Math.min(eventEndDataIndex + startIndex, dataIndexLimit)) {
                                if (this.dataPts.scaledData[extremumIndex] - this.dataPts.scaledData[i] > 0.0f) {
                                    isContinue = true;
                                    break;
                                }
                                if (i < minIndex && !isEndOfFiber) {
                                    if (this.dataPts.scaledData[i] - this.dataPts.scaledData[maxIndex] > 0.0f) {
                                        isContinue = true;
                                        break;
                                    }
                                    if (this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 1] > maxDelta && this.dataPts.scaledData[i] - this.dataPts.scaledData[i + 2] > 0.0f) {
                                        isContinue = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (Float.isNaN(reflectance = this.calcReflectance(eventBeginDataIndex, extremumIndex)) || Float.isInfinite(reflectance)) {
                            reflectance = 0.0f;
                        }
                        if ((0.0f == reflectance || reflectance - minRT < 0.0f) && !isEndOfFiber) {
                            isContinue = true;
                        }
                        if (isContinue) {
                            dataIndex = Math.max(dataIndex + 1, maxIndex);
                            continue;
                        }
                        tmpRoughEventItem = new RoughKeyEventsItem();
                        tmpRoughEventItem.eventBeginDataIndex = eventBeginDataIndex;
                        tmpRoughEventItem.eventEndDataIndex = eventEndDataIndex;
                        tmpRoughEventItem.reflectance = reflectance;
                        tmpRoughEventItem.isEndOfFiber = isEndOfFiber;
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex || isEndOfFiber, "reflect %s event from %d to %d,", isEndOfFiber ? "End Of Fiber" : " ", tmpRoughEventItem.eventBeginDataIndex, tmpRoughEventItem.eventEndDataIndex);
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex || isEndOfFiber, "maxIndex=%d, extremumIndex=%d, minIndex=%d\n", maxIndex, extremumIndex, minIndex);
                        break;
                    }
                    boolean isContinue = false;
                    int testIndex = Math.min(dataIndex + startIndex / 2, dataIndexLimit);
                    lsaLineParameters = this.getLSALine(dataIndex, testIndex);
                    float testLoss = lsaLineParameters.getY(testIndex) - lsaLineParameters.getY(dataIndex);
                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "testLoss[%d-%d] = %f\n", dataIndex, testIndex, Float.valueOf(testLoss));
                    int dI0 = dataIndex;
                    int dI1 = Math.min(dataIndex + 1, dataIndexLimit);
                    int dI2 = Math.min(dataIndex + 2, dataIndexLimit);
                    if (this.dataPts.scaledData[dI1] - this.dataPts.scaledData[dI0] >= et && this.dataPts.scaledData[dI2] - this.dataPts.scaledData[dI0] >= et) {
                        isEndOfFiber = true;
                    }
                    if (this.dataPts.scaledData[dataIndex + 1] - this.dataPts.scaledData[dataIndex] > 0.03f && testLoss >= et) {
                        i = dataIndex;
                        while (i < testIndex) {
                            if (this.dataPts.scaledData[dataIndex] - this.dataPts.scaledData[i] > 0.0f) {
                                isContinue = true;
                                break;
                            }
                            ++i;
                        }
                        if (!isContinue || isEndOfFiber) {
                            isEndOfFiber = true;
                            tmpRoughEventItem = new RoughKeyEventsItem();
                            tmpRoughEventItem.eventBeginDataIndex = dataIndex;
                            tmpRoughEventItem.eventEndDataIndex = testIndex;
                            tmpRoughEventItem.reflectance = 0.0f;
                            tmpRoughEventItem.isEndOfFiber = isEndOfFiber;
                            MainClass.QDEBUG("non reflect END from %d to %d \n", tmpRoughEventItem.eventBeginDataIndex, tmpRoughEventItem.eventEndDataIndex);
                            break;
                        }
                    }
                    ++dataIndex;
                }
            }
            ++limitsIndex;
        }
        if (prevEvents.numberOfKeyEvents > 0 && tmpRoughEventItem != null) {
            boolean isEndOfFiberInPreviousEvent = false;
            if (dataIndex - prevEvents.events[prevEvents.numberOfKeyEvents - 1].eventBeginDataIndex <= startIndex && 0.0f == tmpRoughEventItem.reflectance) {
                isEndOfFiberInPreviousEvent = true;
            }
            if (isEndOfFiberInPreviousEvent) {
                MainClass.QDEBUG("END OF FIBER OF IN PREVIOUS EVENT[%d-%d] FOUND\n", prevEvents.events[prevEvents.numberOfKeyEvents - 1].eventBeginDataIndex, prevEvents.events[prevEvents.numberOfKeyEvents - 1].eventEndDataIndex);
                prevEvents.events[prevEvents.numberOfKeyEvents - 1].isEndOfFiber = true;
            }
        }
        MainClass.QDEBUG("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n", new Object[0]);
        MainClass.QDEBUG("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ someActionCounter = %d\n", someActionCounter);
        MainClass.QDEBUG("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n", new Object[0]);
        return tmpRoughEventItem;
    }

    private RoughKeyEvents doRoughAuto(float et, float rt, float lt) {
        int DEBUG_DATA_INDEX_LEFT_LIMIT = -1;
        int DEBUG_DATA_INDEX_RIGHT_LIMIT = -1;
        RoughKeyEventsItem tmpRoughEventItem = new RoughKeyEventsItem();
        int startIndex = this.getIndexAfterPulse();
        if (3 > startIndex) {
            startIndex = 3;
        }
        RoughKeyEvents reflectRoughKeyEvents = new RoughKeyEvents();
        MainClass.QDEBUG("^^^^^^^^^^^^^^^^^^^^^^^^^^REFLECTED EVENTS SEARCHING STARTED^^^^^^^^^^^^^^^^^^^^^^^^^^\n", new Object[0]);
        long testNanoTime = System.nanoTime();
        reflectRoughKeyEvents = this.findReflectRoughEventsAndEndOfFiber(startIndex, et, rt);
        testNanoTime = System.nanoTime() - testNanoTime;
        MainClass.QDEBUG(">>>>>>>>>>>>>>>>>>>>>>>>>>>> findReflectRoughEventsAndEndOfFiber elapsed %d ns\n", testNanoTime);
        MainClass.QDEBUG("-------------------------NON REFLECTED EVENTS SEARCHING STARTED-------------------------\n", new Object[0]);
        testNanoTime = System.nanoTime();
        RoughKeyEvents retRoughKeyEvents = new RoughKeyEvents();
        int i = 0;
        while (i < reflectRoughKeyEvents.numberOfKeyEvents) {
            retRoughKeyEvents.insertEvent(reflectRoughKeyEvents.events[i]);
            ++i;
        }
        int eventIndexLimit = reflectRoughKeyEvents.numberOfKeyEvents;
        int tstIndex = this.getIndexAfterPulse(true) / 2;
        if (tstIndex < 3) {
            tstIndex = 3;
        }
        MainClass.QDEBUG("\n----------\ntstIndex = %d, startIndex = %d\n++++++++++\n", tstIndex, startIndex);
        int minPulseWidth_i = this.getPulseWidthOnTheScreenInDataPoints(this.fxdParams.pulseWidthsUsed[0], 100.0f);
        MainClass.QDEBUG("minPulseWidth_i = %d\n", minPulseWidth_i);
        float minPulseWidth_ns = this.getPulseWidthOnTheScreenInNanoseconds(this.fxdParams.pulseWidthsUsed[0], 100.0f);
        int eventIndex = 1;
        while (eventIndex < eventIndexLimit) {
            int dataIndex_limit = reflectRoughKeyEvents.events[eventIndex].eventBeginDataIndex;
            int leftLimit = reflectRoughKeyEvents.events[eventIndex - 1].eventEndDataIndex + tstIndex + 1;
            int dataIndex = reflectRoughKeyEvents.events[eventIndex - 1].eventEndDataIndex + 1;
            dataIndex += tstIndex;
            while (dataIndex < dataIndex_limit - tstIndex) {
                if (dataIndex > leftLimit) {
                    int addLine2_i0 = tstIndex;
                    int line1_i0 = dataIndex - tstIndex;
                    int line1_i1 = dataIndex;
                    int line2_i0 = Math.min(dataIndex + 1, dataIndex_limit - 1);
                    int line2_i1 = Math.min(dataIndex + 1 + addLine2_i0, dataIndex_limit - 1);
                    boolean isBreak = false;
                    double angle = 0.0;
                    while (angle < 0.1) {
                        if (line2_i1 >= dataIndex_limit) {
                            isBreak = true;
                            break;
                        }
                        LSALineParameters line1 = this.getLSALine(line1_i0++, line1_i1++);
                        LSALineParameters line2 = this.getLSALine(line2_i0++, line2_i1++);
                        angle = this.getAngleBetweenLSALines(line1, line2);
                        angle *= 57.29577951308232;
                    }
                    if (isBreak) break;
                    dataIndex = line1_i1;
                }
                int lsa0_i = dataIndex;
                int lsa1_i = Math.min(lsa0_i + tstIndex, dataIndex_limit - 1);
                LSALineParameters lsaLineParameters = this.getLSALine(lsa0_i, lsa1_i);
                float eventLoss = lsaLineParameters.getY(lsa1_i) - lsaLineParameters.getY(lsa0_i);
                boolean isGain = true;
                boolean isLoss = true;
                if (this.dataPts.scaledData[dataIndex + 1] - this.dataPts.scaledData[dataIndex] <= 0.0f) {
                    isLoss = false;
                }
                if (this.dataPts.scaledData[dataIndex + 1] - this.dataPts.scaledData[dataIndex] >= 0.0f) {
                    isGain = false;
                }
                if (eventLoss <= 0.0f) {
                    isLoss = false;
                }
                if (eventLoss > 0.0f) {
                    isGain = false;
                }
                float attenuationCoefficient = eventLoss / (float)this.recalcDistance(lsa0_i, lsa1_i);
                if (isGain && attenuationCoefficient > 0.0f) {
                    isGain = false;
                }
                if (isLoss && attenuationCoefficient < 0.5f) {
                    isLoss = false;
                }
                if (eventLoss > lt / 2.0f && isLoss || eventLoss <= 0.0f && isGain) {
                    tmpRoughEventItem.eventBeginDataIndex = dataIndex;
                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "1. possible %s [%d-%d] eventLoss ~ %f dB\n", isGain ? "Gain" : "Loss", lsa0_i, lsa1_i, Float.valueOf(eventLoss));
                    int j = Math.min(dataIndex_limit - 1, tmpRoughEventItem.eventBeginDataIndex + tstIndex / 3 + 1);
                    int right_j_limit = Math.min(dataIndex_limit - 1, tmpRoughEventItem.eventBeginDataIndex + tstIndex * 4);
                    int extremum_j = j;
                    float extremumAttCoeff = (float)this.getLSAAttenuationCoefficient(tmpRoughEventItem.eventBeginDataIndex, j);
                    boolean isContinue = false;
                    while (j < right_j_limit) {
                        if (isGain && this.dataPts.scaledData[j] - this.dataPts.scaledData[tmpRoughEventItem.eventBeginDataIndex] >= 0.0f || isLoss && this.dataPts.scaledData[j] - this.dataPts.scaledData[tmpRoughEventItem.eventBeginDataIndex] <= 0.0f) {
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d] NOISE on %s!!! \n", tmpRoughEventItem.eventBeginDataIndex, isGain ? "gain" : "loss");
                            isContinue = true;
                        }
                        if (this.getLSAAttenuationCoefficient(j, j + tstIndex) > 0.0 && this.getLSAAttenuationCoefficient(j, j + tstIndex) < 1.0) break;
                        float tmpAtt = (float)this.getLSAAttenuationCoefficient(tmpRoughEventItem.eventBeginDataIndex, j);
                        if (isGain && tmpAtt < extremumAttCoeff || isLoss && tmpAtt > extremumAttCoeff) {
                            extremumAttCoeff = tmpAtt;
                            extremum_j = j;
                        }
                        ++j;
                    }
                    if (isContinue) {
                        ++dataIndex;
                        continue;
                    }
                    j = extremum_j;
                    MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "1/2 maximization, [%d-%d]\n", tmpRoughEventItem.eventBeginDataIndex, j);
                    float extremum_lsa_loss = lsaLineParameters.getY(j) - lsaLineParameters.getY(tmpRoughEventItem.eventBeginDataIndex);
                    int extremum_local_i = tmpRoughEventItem.eventBeginDataIndex;
                    int noiseTestLimitIndex = j;
                    int local_i = tmpRoughEventItem.eventBeginDataIndex;
                    while (local_i < tmpRoughEventItem.eventBeginDataIndex + tstIndex) {
                        lsaLineParameters = this.getLSALine(local_i, j);
                        eventLoss = lsaLineParameters.getY(j) - lsaLineParameters.getY(local_i);
                        float event2PLoss = this.dataPts.scaledData[j] - this.dataPts.scaledData[local_i];
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "%s[%d-%d]=%f\n", isGain ? "gain:" : "loss", local_i, j, Float.valueOf(eventLoss), Float.valueOf(event2PLoss));
                        if (noiseTestLimitIndex > local_i) {
                            if (isGain && (event2PLoss > 0.0f || eventLoss > 0.0f)) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d] NOISE on Gain: event2PLoss = %f, eventLoss = %f\n", tmpRoughEventItem.eventBeginDataIndex, Float.valueOf(event2PLoss), Float.valueOf(eventLoss));
                                isContinue = true;
                                break;
                            }
                            if (isLoss && (event2PLoss < 0.0f || eventLoss < 0.0f)) {
                                MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d] NOISE on Loss: event2PLoss = %f, eventLoss = %f\n", tmpRoughEventItem.eventBeginDataIndex, Float.valueOf(event2PLoss), Float.valueOf(eventLoss));
                                isContinue = true;
                                break;
                            }
                        }
                        if (isGain && extremum_lsa_loss > eventLoss || isLoss && extremum_lsa_loss < eventLoss) {
                            extremum_lsa_loss = eventLoss;
                            extremum_local_i = local_i;
                            extremum_j = j;
                        }
                        ++j;
                        ++local_i;
                    }
                    if (isContinue) {
                        ++dataIndex;
                        continue;
                    }
                    if (extremum_local_i != tmpRoughEventItem.eventBeginDataIndex) {
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "event index changed from %d to %d, line end at %d, extremum_j = %d\n", tmpRoughEventItem.eventBeginDataIndex, extremum_local_i, j, extremum_j);
                        tmpRoughEventItem.eventBeginDataIndex = extremum_local_i;
                        j = extremum_j;
                    }
                    if (j < dataIndex_limit) {
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "good... %d = j < dataIndex_limit = %d\n", j, dataIndex_limit);
                        float tmpPulseWidth_ns = (this.getIndexTime(j - tmpRoughEventItem.eventBeginDataIndex) - this.getIndexTime(0)) * 100.0f / 1000.0f;
                        if (tmpPulseWidth_ns < minPulseWidth_ns / 4.0f) {
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "[%d] NOISE: tmpPulseWidth_ns = %f, minPulseWidth_ns = %f\n", tmpRoughEventItem.eventBeginDataIndex, Float.valueOf(tmpPulseWidth_ns), Float.valueOf(minPulseWidth_ns));
                            ++dataIndex;
                            continue;
                        }
                        lsaLineParameters = this.getLSALine(tmpRoughEventItem.eventBeginDataIndex, j);
                        lsaLineParameters = this.getLSALine(reflectRoughKeyEvents.events[eventIndex - 1].eventEndDataIndex, tmpRoughEventItem.eventBeginDataIndex);
                        eventLoss = this.dataPts.scaledData[j] - lsaLineParameters.getY(j);
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "2. %s+%s: eventLoss ~ %f, lt = %f\n", isGain ? "GAIN" : "", isLoss ? "LOSS" : "", Float.valueOf(eventLoss), Float.valueOf(lt));
                        if (isLoss && eventLoss >= lt / 2.0f || isGain && eventLoss <= -lt / 2.0f) {
                            tmpRoughEventItem.reflectance = 0.0f;
                            tmpRoughEventItem.eventEndDataIndex = j;
                            retRoughKeyEvents.insertEvent(tmpRoughEventItem);
                            MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "inserted %s event from %d to %d\n", isGain ? "GAIN" : "LOSS", tmpRoughEventItem.eventBeginDataIndex, tmpRoughEventItem.eventEndDataIndex);
                            dataIndex += tstIndex;
                            continue;
                        }
                        MainClass.QDEBUG(DEBUG_DATA_INDEX_LEFT_LIMIT <= dataIndex && DEBUG_DATA_INDEX_RIGHT_LIMIT >= dataIndex, "samll loss value = %f, need be grate than %f\n", Float.valueOf(eventLoss), Float.valueOf(isGain ? -lt : lt));
                        ++dataIndex;
                        continue;
                    }
                    ++dataIndex;
                    continue;
                }
                ++dataIndex;
            }
            ++eventIndex;
        }
        MainClass.QDEBUG("startIndex = %d\n", startIndex);
        testNanoTime = System.nanoTime() - testNanoTime;
        MainClass.QDEBUG("<<<<<<<<<<<<<<<<<<<<<<<<< non reflected search elapsed %d ns\n", testNanoTime);
        return retRoughKeyEvents;
    }

    private RoughKeyEvents findReflectRoughEventsAndEndOfFiber(int startIndex, float et, float rt) {
        RoughKeyEvents roughKeyEvents = new RoughKeyEvents();
        RoughKeyEventsItem tmpRoughEventItem = new RoughKeyEventsItem();
        tmpRoughEventItem.eventBeginDataIndex = 0;
        tmpRoughEventItem.eventEndDataIndex = startIndex;
        tmpRoughEventItem.reflectance = this.calcRefclectanceFromConnecter(startIndex);
        tmpRoughEventItem.isEndOfFiber = this.isEndOfFiberJustAfterPulse;
        roughKeyEvents.insertEvent(tmpRoughEventItem);
        if (tmpRoughEventItem.isEndOfFiber) {
            return roughKeyEvents;
        }
        float nomPulseWidth_ns = (this.getIndexTime(startIndex) - this.getIndexTime(0)) * 100.0f / 1000.0f;
        nomPulseWidth_ns = Math.min((float)this.fxdParams.pulseWidthsUsed[0], nomPulseWidth_ns);
        int peakPulseOffset = Math.round(this.getTimeIndex((int)(this.getIndexTime(0) + 10.0f * nomPulseWidth_ns / 3.0f)));
        if (peakPulseOffset < 1) {
            peakPulseOffset = 1;
        }
        float tmpRT = -65.0f;
        while (tmpRT >= -65.0f) {
            MainClass.QDEBUG("+++++++++++++ ANALYSIS FOR REFLECTION THRESHOLD = %f +++++++++++++\n", Float.valueOf(tmpRT));
            if (roughKeyEvents.numberOfKeyEvents > 0) {
                tmpRoughEventItem = roughKeyEvents.events[0];
            }
            RoughEventLimit[] roughEventLimits = roughKeyEvents.numberOfKeyEvents > 0 ? new RoughEventLimit[roughKeyEvents.numberOfKeyEvents] : new RoughEventLimit[]{new RoughEventLimit(0, this.dataPts.numberOfDataPoints - 1)};
            int i = 0;
            while (i < roughKeyEvents.numberOfKeyEvents) {
                int left = i > 0 ? Math.min(roughKeyEvents.events[i - 1].eventEndDataIndex + 1, this.dataPts.numberOfDataPoints - 1) : 0;
                int right = i < roughKeyEvents.numberOfKeyEvents - 1 ? Math.min(roughKeyEvents.events[i].eventBeginDataIndex + 1, this.dataPts.numberOfDataPoints - 1) : this.dataPts.numberOfDataPoints - 1;
                roughEventLimits[i] = new RoughEventLimit(left, right);
                ++i;
            }
            while (tmpRoughEventItem != null) {
                if ((tmpRoughEventItem = this.findNextReflection(et, tmpRT, startIndex, peakPulseOffset, tmpRoughEventItem, roughEventLimits, roughKeyEvents)) == null) continue;
                roughKeyEvents.insertEvent(tmpRoughEventItem);
                if (tmpRoughEventItem.isEndOfFiber) break;
            }
            roughEventLimits = null;
            if (tmpRoughEventItem != null && tmpRoughEventItem.isEndOfFiber) break;
            tmpRT -= 5.0f;
        }
        RoughKeyEvents roughKeyEventsForReturn = new RoughKeyEvents();
        boolean isPreviousSuspicious = false;
        boolean isEndOfFiberFound = false;
        MainClass.QDEBUG("BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\n", new Object[0]);
        int i = 0;
        while (i < roughKeyEvents.numberOfKeyEvents) {
            if (roughKeyEvents.events[i].eventBeginDataIndex > startIndex) {
                int lsa0_i = roughKeyEvents.events[i].eventEndDataIndex;
                int lsa1_flow = i < roughKeyEvents.numberOfKeyEvents - 1 ? roughKeyEvents.events[i + 1].eventBeginDataIndex : this.dataPts.numberOfDataPoints - 1;
                int lsa1_i = lsa1_flow;
                while (lsa0_i < lsa1_i) {
                    int TEST_SIZE = 3;
                    int[] test_i = new int[TEST_SIZE];
                    int goodCount = 0;
                    int j = 0;
                    while (j < TEST_SIZE) {
                        test_i[j] = Math.min(lsa0_i + j + 1, lsa1_i - 1);
                        if (this.dataPts.scaledData[lsa0_i] - this.dataPts.scaledData[test_i[j]] < 0.0f) {
                            ++goodCount;
                        }
                        ++j;
                    }
                    if (goodCount == j) break;
                    ++lsa0_i;
                }
                boolean mustCheck = true;
                if (!isPreviousSuspicious) {
                    while (lsa1_i > lsa0_i + startIndex) {
                        float tstAtt = (float)this.getLSAAttenuationCoefficient(lsa0_i, lsa1_i);
                        if (tstAtt < 1.0f && tstAtt > -1.0f) {
                            MainClass.QDEBUG("!mustCheck[%d-%d]%f\n", lsa0_i, lsa1_i, Float.valueOf(tstAtt));
                            mustCheck = false;
                            break;
                        }
                        lsa1_i -= startIndex;
                    }
                }
                MainClass.QDEBUG("event#%d mustCheck? %s\n", i, mustCheck ? "yes!" : "no.");
                if (mustCheck) {
                    float minNegativeAttenuation;
                    float maxPositiveAttenuation;
                    lsa1_i = Math.min(lsa1_flow, lsa0_i + startIndex);
                    float attenuation = (float)this.getLSAAttenuationCoefficient(lsa0_i, lsa1_i);
                    MainClass.QDEBUG("event#%d attenuation[%d-%d]=%f\n", i, lsa0_i, lsa1_i, Float.valueOf(attenuation));
                    if (isPreviousSuspicious) {
                        maxPositiveAttenuation = 2.0f;
                        minNegativeAttenuation = -1.0f;
                    } else {
                        maxPositiveAttenuation = 10.0f;
                        minNegativeAttenuation = -10.0f;
                    }
                    if (attenuation < minNegativeAttenuation || maxPositiveAttenuation < attenuation) {
                        MainClass.QDEBUG("isPreviousSuspicious = %s\n", isPreviousSuspicious ? "yes" : "no");
                        if (isPreviousSuspicious) {
                            roughKeyEvents.events[i - 1].isEndOfFiber = true;
                        } else {
                            isPreviousSuspicious = true;
                        }
                    } else {
                        isPreviousSuspicious = false;
                    }
                }
            }
            ++i;
        }
        MainClass.QDEBUG("EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE\n", new Object[0]);
        i = 0;
        while (i < roughKeyEvents.numberOfKeyEvents) {
            roughKeyEventsForReturn.insertEvent(roughKeyEvents.events[i]);
            if (roughKeyEvents.events[i].isEndOfFiber) {
                isEndOfFiberFound = true;
                break;
            }
            ++i;
        }
        if (!isEndOfFiberFound) {
            float lsatAttenuation = 0.0f;
            if (roughKeyEventsForReturn.numberOfKeyEvents > 0) {
                lsatAttenuation = (float)this.getLSAAttenuationCoefficient(roughKeyEventsForReturn.events[roughKeyEventsForReturn.numberOfKeyEvents - 1].eventEndDataIndex, this.dataPts.numberOfDataPoints - 1);
            }
            if (lsatAttenuation < 0.5f) {
                tmpRoughEventItem = new RoughKeyEventsItem();
                tmpRoughEventItem.eventBeginDataIndex = this.dataPts.numberOfDataPoints - 1;
                tmpRoughEventItem.eventEndDataIndex = this.dataPts.numberOfDataPoints - 1;
                tmpRoughEventItem.isEndOfFiber = true;
                roughKeyEventsForReturn.insertEvent(tmpRoughEventItem);
            }
        }
        MainClass.QDEBUG("startIndex = %d, peakPulseOffset = %d\n", startIndex, peakPulseOffset);
        return roughKeyEventsForReturn;
    }

    public void doAuto(MainClass mainClass) {
        float et = (float)this.fxdParams.endOfFiberThreshold / 1000.0f;
        float rt = -((float)this.fxdParams.reflectanceThreshold) / 1000.0f;
        float lt = (float)this.fxdParams.lossThreshold / 1000.0f;
        while (this.keyEvents.numberOfKeyEvents > 0) {
            this.keyEvents.deleteEvent((short)(this.keyEvents.numberOfKeyEvents - 1));
        }
        if (0.0f == lt) {
            lt = 0.05f;
        }
        if (0.0f == rt) {
            rt = -65.0f;
        }
        if (0.0f == et) {
            et = 5.0f;
        }
        RoughKeyEvents roughKeyEvents = this.doRoughAuto(et, rt, lt);
        int[] tmpCursor = new int[5];
        int i = 1;
        while (i < roughKeyEvents.numberOfKeyEvents - 1) {
            tmpCursor[4] = roughKeyEvents.events[i].eventBeginDataIndex;
            tmpCursor[0] = roughKeyEvents.events[i].eventBeginDataIndex - 1;
            tmpCursor[2] = i > 0 ? roughKeyEvents.events[i - 1].eventEndDataIndex : 0;
            tmpCursor[1] = roughKeyEvents.events[i].eventEndDataIndex;
            tmpCursor[3] = roughKeyEvents.events[i + 1].eventBeginDataIndex;
            this.lsaLine[0] = this.getLSALine(tmpCursor[2], tmpCursor[0]);
            this.lsaLine[1] = this.getLSALine(tmpCursor[3], tmpCursor[1]);
            roughKeyEvents.events[i].eventLoss = this.lsaLine[1].getY(tmpCursor[4]) - this.lsaLine[0].getY(tmpCursor[4]);
            if (Float.isInfinite(roughKeyEvents.events[i].eventLoss) || Float.isNaN(roughKeyEvents.events[i].eventLoss)) {
                roughKeyEvents.events[i].eventLoss = 0.0f;
            }
            if (roughKeyEvents.events[i].eventLoss < lt && roughKeyEvents.events[i].eventLoss > -lt && roughKeyEvents.events[i].reflectance == 0.0f && i < roughKeyEvents.numberOfKeyEvents) {
                MainClass.QDEBUG("[%d] OOOOHHHHH, false event[%d-%d] fixed!!! eventLoss = %f, lt = %f\n", i, roughKeyEvents.events[i].eventBeginDataIndex, roughKeyEvents.events[i].eventEndDataIndex, Float.valueOf(roughKeyEvents.events[i].eventLoss), Float.valueOf(lt));
                roughKeyEvents.deleteEvent(i);
                i = 1;
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < roughKeyEvents.numberOfKeyEvents) {
            int eventPropagationTime;
            short eventIndex;
            MainClass.QDEBUG("roughEvent[%d], beginIndex = %d, endIndex = %d, reflectance = %f\n", i, roughKeyEvents.events[i].eventBeginDataIndex, roughKeyEvents.events[i].eventEndDataIndex, Float.valueOf(roughKeyEvents.events[i].reflectance));
            if (i != roughKeyEvents.numberOfKeyEvents - 1 && i != 0 && 0.0f != roughKeyEvents.events[i].reflectance && rt > roughKeyEvents.events[i].reflectance) {
                MainClass.QDEBUG("reflectance = %f < %f = rt", Float.valueOf(roughKeyEvents.events[i].reflectance), Float.valueOf(rt));
                ++i;
                continue;
            }
            tmpCursor[4] = roughKeyEvents.events[i].eventBeginDataIndex;
            tmpCursor[0] = Math.max(0, roughKeyEvents.events[i].eventBeginDataIndex - 1);
            tmpCursor[2] = i > 0 ? roughKeyEvents.events[i - 1].eventEndDataIndex : 0;
            if (i == roughKeyEvents.numberOfKeyEvents - 1) {
                tmpCursor[3] = this.dataPts.numberOfDataPoints - 1;
                tmpCursor[1] = tmpCursor[3] - 1;
            } else {
                tmpCursor[1] = roughKeyEvents.events[i].eventEndDataIndex;
                tmpCursor[3] = roughKeyEvents.events[i + 1].eventBeginDataIndex;
            }
            this.lsaLine[0] = this.getLSALine(tmpCursor[2], tmpCursor[0]);
            this.lsaLine[1] = this.getLSALine(tmpCursor[3], tmpCursor[1]);
            if (i == roughKeyEvents.numberOfKeyEvents - 1) {
                if (0.0f == roughKeyEvents.events[i].reflectance) {
                    int min_j = roughKeyEvents.events[i].eventBeginDataIndex;
                    int j = roughKeyEvents.events[i].eventBeginDataIndex;
                    while (j < roughKeyEvents.events[i].eventEndDataIndex) {
                        if (this.dataPts.scaledData[j] < this.dataPts.scaledData[min_j]) {
                            min_j = j;
                        }
                        ++j;
                    }
                    roughKeyEvents.events[i].reflectance = this.calcReflectance(roughKeyEvents.events[i].eventBeginDataIndex, min_j);
                }
                roughKeyEvents.events[i].eventLoss = this.lsaLine[1].getY(tmpCursor[4]) - this.lsaLine[0].getY(tmpCursor[4]);
                if (Float.isInfinite(roughKeyEvents.events[i].eventLoss) || Float.isNaN(roughKeyEvents.events[i].eventLoss)) {
                    roughKeyEvents.events[i].eventLoss = 0.0f;
                }
            }
            if (Float.isInfinite(roughKeyEvents.events[i].reflectance) || Float.isNaN(roughKeyEvents.events[i].reflectance)) {
                roughKeyEvents.events[i].reflectance = 0.0f;
            }
            if ((eventIndex = this.keyEvents.insertKeyEvent(eventPropagationTime = Math.round(this.getIndexTime(roughKeyEvents.events[i].eventBeginDataIndex)))) == -1) {
                MainClass.QDEBUG("eventIndex = -1!!!!!!!!!!!!!!!!!!!!! ERROR!!!!!!!!!!! \n", new Object[0]);
                continue;
            }
            this.keyEvents.events[eventIndex].eventPropagationTime = eventPropagationTime;
            this.keyEvents.events[eventIndex].eventReflectance = (int)(1000.0f * roughKeyEvents.events[i].reflectance);
            float tmpDistance = (float)this.recalcDistance(tmpCursor[2], tmpCursor[0]);
            float attCoeff = (this.lsaLine[0].getY(tmpCursor[0]) - this.lsaLine[0].getY(tmpCursor[2])) / tmpDistance;
            float attCoeff1000 = attCoeff * 1000.0f;
            if (attCoeff1000 > 32767.0f) {
                attCoeff1000 = 32767.0f;
            }
            if (attCoeff1000 < -32768.0f) {
                attCoeff1000 = -32768.0f;
            }
            this.keyEvents.events[eventIndex].attenuationCoefficientLeadInFiber = (short)Math.round(attCoeff1000);
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[0] = 76;
            this.keyEvents.events[eventIndex].lossMeasurmentTechnique[1] = 83;
            this.keyEvents.events[eventIndex].markerLocations[0] = Math.round(this.getIndexTime(tmpCursor[2]));
            this.keyEvents.events[eventIndex].markerLocations[1] = Math.round(this.getIndexTime(tmpCursor[0]));
            this.keyEvents.events[eventIndex].markerLocations[2] = Math.round(this.getIndexTime(tmpCursor[1]));
            this.keyEvents.events[eventIndex].markerLocations[3] = Math.round(this.getIndexTime(tmpCursor[3]));
            this.keyEvents.events[eventIndex].markerLocations[4] = Math.round(this.getIndexTime(tmpCursor[4]));
            this.keyEvents.events[eventIndex].eventCode[0] = this.keyEvents.events[eventIndex].eventReflectance == 0 ? 48 : 49;
            if (i == roughKeyEvents.numberOfKeyEvents - 1) {
                MainClass.QDEBUG("eventIndex = %d\n", eventIndex);
                if (roughKeyEvents.events[i].eventBeginDataIndex == this.dataPts.numberOfDataPoints - 1) {
                    MainClass.QDEBUG("---------------------------END OF FIBER TYPE O!!!\n", new Object[0]);
                    this.keyEvents.events[eventIndex].eventCode[1] = 79;
                    this.keyEvents.events[eventIndex].comment = mainClass.getResourceString("KEY_EVENTS_OUT_OF_RANGE");
                } else {
                    MainClass.QDEBUG("---------------------------END OF FIBER TYPE E!!!\n", new Object[0]);
                    this.keyEvents.events[eventIndex].eventCode[1] = 69;
                    this.keyEvents.events[eventIndex].comment = mainClass.getResourceString("KEY_EVENTS_END_OF_FIBER");
                }
            } else {
                this.keyEvents.events[eventIndex].eventCode[1] = 70;
                this.keyEvents.events[eventIndex].comment = this.keyEvents.events[eventIndex].eventPropagationTime == 0 ? mainClass.getResourceString("KEY_EVENTS_BEGIN_OF_FIBER") : (49 == this.keyEvents.events[eventIndex].eventCode[0] ? mainClass.getResourceString("KEY_EVENTS_REFLECTED") : (48 == this.keyEvents.events[eventIndex].eventCode[0] ? (0.0f < roughKeyEvents.events[i].eventLoss ? mainClass.getResourceString("KEY_EVENTS_LOSS") : mainClass.getResourceString("KEY_EVENTS_GAIN")) : mainClass.getResourceString("KEY_EVENTS_SOFT")));
            }
            this.keyEvents.events[eventIndex].eventCode[2] = 57;
            this.keyEvents.events[eventIndex].eventCode[3] = 57;
            this.keyEvents.events[eventIndex].eventCode[4] = 57;
            this.keyEvents.events[eventIndex].eventCode[5] = 57;
            float tmpVal = Math.round(roughKeyEvents.events[i].eventLoss * 1000.0f);
            if (tmpVal < -32768.0f) {
                tmpVal = -32768.0f;
            }
            if (tmpVal > 32767.0f) {
                tmpVal = 32767.0f;
            }
            this.keyEvents.events[eventIndex].eventLoss = (short)tmpVal;
            ++i;
        }
        int c1 = roughKeyEvents.events[0].eventEndDataIndex;
        int c2 = roughKeyEvents.events[roughKeyEvents.numberOfKeyEvents - 1].eventBeginDataIndex;
        float endToEndLoss = this.dataPts.scaledData[c2] - this.dataPts.scaledData[c1];
        this.keyEvents.endToEndLoss = Math.round(1000.0f * endToEndLoss);
        this.keyEvents.endToEndMarkerPosition[0] = (int)this.getIndexTime(c1);
        this.keyEvents.endToEndMarkerPosition[1] = (int)this.getIndexTime(c2);
        float orl = this.calcORL(c1, c2);
        if (Float.isInfinite(orl) || Float.isNaN(orl)) {
            orl = 0.0f;
        }
        this.keyEvents.opticalReturnLoss = Math.round(1000.0f * orl);
        this.keyEvents.opticalReturnLossMarkerPosition[0] = (int)this.getIndexTime(c1);
        this.keyEvents.opticalReturnLossMarkerPosition[1] = (int)this.getIndexTime(c2);
        MainClass.QDEBUG("et = %f, rt = %f, lt = %f, endToEndLoss = %f, ORL = %f\n", Float.valueOf(et), Float.valueOf(rt), Float.valueOf(lt), Float.valueOf(endToEndLoss), Float.valueOf(orl));
        this.createSorFileBuffer();
        this.isKeyEventsPresent = true;
    }

    public float calcStandardDeviation(int i1, int i2) {
        if (i1 > i2) {
            int tmp = i1;
            i1 = i2;
            i2 = tmp;
        }
        LSALineParameters lsaLine = this.getLSALine(i1, i2);
        float sum = 0.0f;
        int i = i1;
        while (i <= i2) {
            sum = (float)((double)sum + Math.pow(this.dataPts.scaledData[i] - lsaLine.getY(i), 2.0));
            ++i;
        }
        float sigma = (float)Math.sqrt(sum / (float)(i2 - i1 + 1));
        return sigma;
    }

    private float[] bSort(int max_n, float[] f_buff) {
        int i = max_n - 1;
        while (i >= 0) {
            int j = 0;
            while (j <= i) {
                if (f_buff[j] <= f_buff[j + 1]) {
                    float tmp = f_buff[j + 1];
                    f_buff[j + 1] = f_buff[j];
                    f_buff[j] = tmp;
                }
                ++j;
            }
            --i;
        }
        return f_buff;
    }

    public void convertToPowerLevels() {
        if (!this.isDataPtsPresent) {
            return;
        }
        if (this.dataPts.scaledData == null) {
            return;
        }
        this.dataPts.maxData = -2147.3853f;
        this.dataPts.minData = 2147.3853f;
        int i = 0;
        while (i < this.dataPts.numberOfDataPoints) {
            this.dataPts.scaledData[i] = (float)Math.pow(10.0, this.dataPts.scaledData[i] / -5.0f);
            this.dataPts.maxData = Math.max(this.dataPts.maxData, this.dataPts.scaledData[i]);
            this.dataPts.minData = Math.min(this.dataPts.minData, this.dataPts.scaledData[i]);
            ++i;
        }
    }

    public void doMedianFromLevels() {
        if (!this.isDataPtsPresent) {
            return;
        }
        if (this.dataPts.scaledData == null) {
            return;
        }
        float[] levels = new float[this.dataPts.numberOfDataPoints];
        int i = 0;
        while (i < this.dataPts.numberOfDataPoints) {
            levels[i] = (float)Math.pow(10.0, this.dataPts.scaledData[i] / -5.0f);
            ++i;
        }
        levels = this.doMedian(levels);
        i = 0;
        while (i < this.dataPts.numberOfDataPoints) {
            this.dataPts.scaledData[i] = -5.0f * (float)Math.log10(levels[i]);
            ++i;
        }
    }

    public float[] doMedian(float[] dataPtsBuffer) {
        float[] tmpData = (float[])dataPtsBuffer.clone();
        int nOfA = this.getIndexAfterPulse(true) / 3;
        if (nOfA < 3) {
            nOfA = 3;
        }
        int nOfA1 = nOfA / 2;
        if (nOfA == (nOfA1 *= 2)) {
            ++nOfA;
        }
        float[] tmpAperture = new float[nOfA];
        int n_offset = nOfA / 2 + 1;
        MainClass.QDEBUG("nOfA = %d\n", nOfA);
        int dataIndex = n_offset;
        while (dataIndex < this.dataPts.numberOfDataPoints) {
            int a_i = 0;
            while (a_i < nOfA) {
                tmpAperture[a_i] = tmpData[Math.min(dataIndex - n_offset + a_i, this.dataPts.numberOfDataPoints - 1)];
                ++a_i;
            }
            tmpAperture = this.bSort(nOfA - 1, tmpAperture);
            try {
                dataPtsBuffer[dataIndex] = tmpAperture[n_offset];
            }
            catch (Exception e) {
                System.out.printf("Exception:%s\n", e.getMessage());
                System.out.printf("dataIndex = %d (from %d), n_offset = %d (from %d)\n", dataIndex, this.dataPts.numberOfDataPoints, n_offset, nOfA);
            }
            ++dataIndex;
        }
        return dataPtsBuffer;
    }

    public void doMedian() {
        float[] tmpData = (float[])this.dataPts.scaledData.clone();
        int nOfA = this.getIndexAfterPulse(true) / 3;
        if (nOfA < 3) {
            nOfA = 3;
        }
        int nOfA1 = nOfA / 2;
        if (nOfA == (nOfA1 *= 2)) {
            ++nOfA;
        }
        float[] tmpAperture = new float[nOfA];
        int n_offset = nOfA / 2 + 1;
        MainClass.QDEBUG("nOfA = %d\n", nOfA);
        int dataIndex = n_offset;
        while (dataIndex < this.dataPts.numberOfDataPoints) {
            int a_i = 0;
            while (a_i < nOfA) {
                tmpAperture[a_i] = tmpData[Math.min(dataIndex - n_offset + a_i, this.dataPts.numberOfDataPoints - 1)];
                ++a_i;
            }
            tmpAperture = this.bSort(nOfA - 1, tmpAperture);
            try {
                this.dataPts.scaledData[dataIndex] = tmpAperture[n_offset];
            }
            catch (Exception e) {
                System.out.printf("Exception:%s\n", e.getMessage());
                System.out.printf("dataIndex = %d (from %d), n_offset = %d (from %d)\n", dataIndex, this.dataPts.numberOfDataPoints, n_offset, nOfA);
            }
            this.dataPts.data[dataIndex] = (int)Math.round((double)this.dataPts.scaledData[dataIndex] * 1000000.0 / (double)this.dataPts.scaleFactors[0]);
            ++dataIndex;
        }
    }

    public String getFileName() {
        File file = new File(this.filePath);
        return file.getName();
    }

    private void saveCursors() {
        int i = 0;
        while (i < 5) {
            this.savedCursorPrivate[i] = this.cursor[i];
            ++i;
        }
    }

    private void restoreCursors() {
        int i = 0;
        while (i < 5) {
            this.cursor[i] = this.savedCursorPrivate[i];
            ++i;
        }
    }

    float getXStep() {
        return this.xStep;
    }

    float getYStep() {
        return this.yStep;
    }

    float getPointWeight() {
        return this.pointWeight;
    }

    public class Cksum {
        public String blockID = "Cksum";
        public int checksum;
        public int size;
    }

    public class DataPts {
        public String blockID = "DataPts";
        public int numberOfDataPoints = 0;
        public short totalNumberScaleFactorsUsed = 0;
        public int[] totalDataPointsUsingScaleFactor = null;
        public short[] scaleFactors = null;
        public int[] data = null;
        public float[] scaledData = null;
        public float maxData = -2147.3853f;
        public float minData = 2147.3853f;
        public int size;

        public void createDataPtsItems(int nDataPoints, short nScaleFactors) {
            if (this.totalDataPointsUsingScaleFactor != null) {
                this.totalDataPointsUsingScaleFactor = null;
            }
            if (this.scaleFactors != null) {
                this.scaleFactors = null;
            }
            if (this.data != null) {
                this.data = null;
            }
            if (this.scaledData != null) {
                this.scaledData = null;
            }
            this.totalDataPointsUsingScaleFactor = new int[nScaleFactors];
            this.scaleFactors = new short[nScaleFactors];
            this.data = new int[nDataPoints];
            this.scaledData = new float[nDataPoints];
            this.totalNumberScaleFactorsUsed = nScaleFactors;
            this.numberOfDataPoints = nDataPoints;
        }
    }

    public class DeadZones {
        public float eventDeadZone;
        public float eventDeadZoneTelcordia = 0.0f;
        public float attenuationDeadZone = 0.0f;

        DeadZones() {
        }
    }

    public class FxdParams {
        public String blockID;
        public long dateTimeStamp;
        public byte[] unitsOfDistance;
        public short actualWaveLength;
        public int acquisitionOffset;
        public int acquisitionOffsetDistance;
        public short totalNumberOfPulseWidthsUsed;
        public short[] pulseWidthsUsed;
        public int[] dataSpacing;
        public int[] numberOfDataPointsForEachPulseWidth;
        public int groupIndex;
        public short backscatterCoefficient;
        public int numberOfAverages;
        public int averagingTime;
        public int acquisitionRange;
        public int acquisitionRangeDistance;
        public int frontPannelOffset;
        public int noiseFloorLevel;
        public short noiseFloorScaleFactor;
        public int powerOffsetFirstPoint;
        public int lossThreshold;
        public int reflectanceThreshold;
        public int endOfFiberThreshold;
        public byte[] traceType;
        public int[] windowCoordinates;
        public int size;
        public float distanceMultiplier;

        public FxdParams() {
            Date curDate = new Date();
            this.blockID = "FxdParams";
            this.dateTimeStamp = curDate.getTime() / 1000L;
            this.unitsOfDistance = new byte[2];
            this.unitsOfDistance[0] = 107;
            this.unitsOfDistance[1] = 109;
            this.actualWaveLength = (short)1310;
            this.acquisitionOffset = 0;
            this.acquisitionOffsetDistance = 0;
            this.totalNumberOfPulseWidthsUsed = 0;
            this.pulseWidthsUsed = null;
            this.dataSpacing = null;
            this.numberOfDataPointsForEachPulseWidth = null;
            this.groupIndex = 0;
            this.backscatterCoefficient = (short)800;
            this.numberOfAverages = 0;
            this.averagingTime = 0;
            this.acquisitionRange = 0;
            this.acquisitionRangeDistance = 0;
            this.frontPannelOffset = 0;
            this.noiseFloorLevel = 65535;
            this.noiseFloorScaleFactor = (short)1000;
            this.powerOffsetFirstPoint = 0;
            this.lossThreshold = 200;
            this.reflectanceThreshold = 40000;
            this.endOfFiberThreshold = 3000;
            this.traceType = new byte[2];
            this.traceType[0] = 83;
            this.traceType[1] = 84;
            this.windowCoordinates = new int[4];
            this.windowCoordinates[0] = 0;
            this.windowCoordinates[1] = 0;
            this.windowCoordinates[2] = 0;
            this.windowCoordinates[3] = 0;
            this.distanceMultiplier = 1.0f;
        }

        void createFxdParamsItems(short numberOfPulseWidths) {
            if (this.pulseWidthsUsed != null) {
                this.pulseWidthsUsed = null;
            }
            if (this.dataSpacing != null) {
                this.dataSpacing = null;
            }
            if (this.numberOfDataPointsForEachPulseWidth != null) {
                this.numberOfDataPointsForEachPulseWidth = null;
            }
            this.pulseWidthsUsed = new short[numberOfPulseWidths];
            this.dataSpacing = new int[numberOfPulseWidths];
            this.numberOfDataPointsForEachPulseWidth = new int[numberOfPulseWidths];
            this.totalNumberOfPulseWidthsUsed = numberOfPulseWidths;
        }
    }

    public class GenParams {
        public String blockID = "GenParams";
        public byte[] languageCode = new byte[2];
        public String cableID;
        public String fiberID;
        public short fiberType;
        public short nominalWaveLength;
        public String originatingLocation;
        public String terminatingLocation;
        public String cableCode;
        public byte[] currentDataFlag;
        public int userOffset;
        public int userOffsetDistance;
        public String operatorCode;
        public String comment;
        public int size;

        public GenParams() {
            this.languageCode[0] = 69;
            this.languageCode[1] = 78;
            this.cableID = " ";
            this.fiberID = " ";
            this.fiberType = (short)652;
            this.nominalWaveLength = (short)1310;
            this.originatingLocation = " ";
            this.terminatingLocation = " ";
            this.cableCode = " ";
            this.currentDataFlag = new byte[2];
            this.currentDataFlag[0] = 66;
            this.currentDataFlag[1] = 67;
            this.userOffset = 0;
            this.userOffsetDistance = 0;
            this.operatorCode = " ";
            this.comment = " ";
        }
    }

    public class KeyEvents {
        public String blockID = "KeyEvents";
        public short numberOfKeyEvents = 0;
        public KeyEventsItem[] events = null;
        public int endToEndLoss = 0;
        public int[] endToEndMarkerPosition = new int[2];
        public int opticalReturnLoss;
        public int[] opticalReturnLossMarkerPosition;
        public int size;
        public long flagOfComparisonWithTemplate;
        public long templateEndToEndLoss;
        public int templateOpticalReturnLoss;
        public float breakageDistanceKM;

        public KeyEvents() {
            this.endToEndMarkerPosition[0] = 0;
            this.endToEndMarkerPosition[1] = 0;
            this.opticalReturnLoss = 0;
            this.opticalReturnLossMarkerPosition = new int[2];
            this.opticalReturnLossMarkerPosition[0] = 0;
            this.opticalReturnLossMarkerPosition[1] = 0;
        }

        void createKeyEventsItems(short nfKeyEvents) {
            if (this.events != null) {
                this.events = null;
            }
            this.numberOfKeyEvents = nfKeyEvents;
            if (this.numberOfKeyEvents > 0) {
                this.events = new KeyEventsItem[nfKeyEvents];
                int i = 0;
                while (i < nfKeyEvents) {
                    this.events[i] = new KeyEventsItem();
                    ++i;
                }
            }
        }

        void insertEvent(short index) {
            if (index < 0) {
                index = 0;
            }
            if (index > this.numberOfKeyEvents) {
                index = this.numberOfKeyEvents;
            }
            if (this.numberOfKeyEvents <= 0) {
                this.createKeyEventsItems((short)1);
            } else {
                this.numberOfKeyEvents = (short)(this.numberOfKeyEvents + 1);
                KeyEventsItem[] tmpEvents = new KeyEventsItem[this.numberOfKeyEvents];
                int j = 0;
                short i = 0;
                while (i < this.numberOfKeyEvents) {
                    tmpEvents[i] = new KeyEventsItem();
                    if (i != index) {
                        tmpEvents[i] = this.events[j];
                        j = (short)(j + 1);
                    }
                    tmpEvents[i].eventNumber = (short)(i + 1);
                    i = (short)(i + 1);
                }
                this.createKeyEventsItems(this.numberOfKeyEvents);
                i = 0;
                while (i < this.numberOfKeyEvents) {
                    this.events[i] = tmpEvents[i];
                    i = (short)(i + 1);
                }
                KeyEventsItem[] keyEventsItemArray = null;
            }
            SorFile.this.isKeyEventsPresent = true;
        }

        short insertKeyEvent(int psec100Time) {
            short i;
            if (this.numberOfKeyEvents <= 0) {
                i = 0;
            } else {
                i = 0;
                while (i < this.numberOfKeyEvents) {
                    if (this.events[i].eventPropagationTime == psec100Time) {
                        return -1;
                    }
                    if (this.events[i].eventPropagationTime > psec100Time) break;
                    i = (short)(i + 1);
                }
            }
            this.insertEvent(i);
            this.events[i].eventPropagationTime = psec100Time;
            SorFile.this.isKeyEventsPresent = true;
            return i;
        }

        void deleteEvent(short index) {
            if (index > this.numberOfKeyEvents - 1 || index < 0) {
                return;
            }
            KeyEventsItem[] tmpEvents = new KeyEventsItem[this.numberOfKeyEvents - 1];
            int j = 0;
            short i = 0;
            while (i < this.numberOfKeyEvents) {
                if (i != index) {
                    tmpEvents[j] = new KeyEventsItem();
                    tmpEvents[j] = this.events[i];
                    tmpEvents[j].eventNumber = (short)(j + 1);
                    j = (short)(j + 1);
                }
                i = (short)(i + 1);
            }
            this.numberOfKeyEvents = (short)(this.numberOfKeyEvents - 1);
            this.createKeyEventsItems(this.numberOfKeyEvents);
            i = 0;
            while (i < this.numberOfKeyEvents) {
                this.events[i] = tmpEvents[i];
                i = (short)(i + 1);
            }
            tmpEvents = null;
        }

        public KeyEventsItem getEventInNeighborhood(int eventPropagationTime, int neighborhood100PsecTime) {
            KeyEventsItem ret = null;
            int i = 0;
            while (i < this.numberOfKeyEvents) {
                int deltaTime = Math.abs(this.events[i].eventPropagationTime - eventPropagationTime);
                if (deltaTime < neighborhood100PsecTime) {
                    ret = this.events[i].copy();
                    break;
                }
                ++i;
            }
            return ret;
        }
    }

    public class KeyEventsItem {
        public short eventNumber = 1;
        public int eventPropagationTime = 0;
        public short attenuationCoefficientLeadInFiber = 0;
        public short eventLoss = 0;
        public int eventReflectance = 0;
        public byte[] eventCode = new byte[6];
        public byte[] lossMeasurmentTechnique;
        public int[] markerLocations;
        public String comment;
        public static final long KEY_EVENT_FLAG_OK = 0L;
        public static final long KEY_EVENT_FLAG_LOSS = 1L;
        public static final long KEY_EVENT_FLAG_REFLECTANCE = 2L;
        public static final long KEY_EVENT_FLAG_LOSS_COEFFICIENT = 4L;
        public static final long KEY_EVENT_FLAG_FULL_LOSS = 8L;
        public static final long KEY_EVENT_FLAG_ORL = 16L;
        public static final long KEY_EVENT_FLAG_END_OF_FIBER_NOT_FOUND = 32L;
        public static final long KEY_EVENT_FLAG_FIBER_BREAKAGE = 64L;
        public static final long KEY_EVENT_FLAG_TEMPLATE_IS_SHORTER = 128L;
        public long flagOfComparisonWithTemplate;
        public short templateAttenuationCoefficientLeadInFiber;
        public short templateEventLoss;
        public int templateEventReflectance;

        public KeyEventsItem() {
            int i = 0;
            while (i < 6) {
                this.eventCode[i] = 0;
                ++i;
            }
            this.lossMeasurmentTechnique = new byte[2];
            this.lossMeasurmentTechnique[0] = 50;
            this.lossMeasurmentTechnique[1] = 80;
            this.markerLocations = new int[5];
            i = 0;
            while (i < 5) {
                this.markerLocations[i] = 0;
                ++i;
            }
            this.comment = " ";
        }

        KeyEventsItem copy() {
            KeyEventsItem event = new KeyEventsItem();
            event.eventNumber = this.eventNumber;
            event.eventPropagationTime = this.eventPropagationTime;
            event.attenuationCoefficientLeadInFiber = this.attenuationCoefficientLeadInFiber;
            event.eventLoss = this.eventLoss;
            event.eventReflectance = this.eventReflectance;
            event.eventCode = new byte[6];
            int i = 0;
            while (i < 6) {
                event.eventCode[i] = this.eventCode[i];
                ++i;
            }
            event.lossMeasurmentTechnique = new byte[2];
            event.lossMeasurmentTechnique[0] = this.lossMeasurmentTechnique[0];
            event.lossMeasurmentTechnique[1] = this.lossMeasurmentTechnique[1];
            event.markerLocations = new int[5];
            i = 0;
            while (i < 5) {
                event.markerLocations[i] = this.markerLocations[i];
                ++i;
            }
            event.comment = this.comment;
            return event;
        }
    }

    public class LSALineParameters {
        private float private_a;
        private float private_b;

        public LSALineParameters(float a, float b) {
            this.private_a = a;
            this.private_b = b;
        }

        public LSALineParameters() {
            this(0.0f, 0.0f);
        }

        float getA() {
            return this.private_a;
        }

        float getB() {
            return this.private_b;
        }

        void setA(float a) {
            this.private_a = a;
        }

        void setB(float b) {
            this.private_b = b;
        }

        float getY(long x) {
            return this.private_a * (float)x + this.private_b;
        }
    }

    public class Landmark {
        public short landmarkNumber = 1;
        public byte[] landmarkCode = new byte[2];
        public int landmarkLocation;
        public short relatedEventNumber;
        public int[] gpsInformation;
        public short fiberCorrectionFactorLeadInFiber;
        public int sheathMarkerEnteringLandmark;
        public int sheathMarkerLeavingLandmark;
        public byte[] unitsOfSheathMarkerLeavingLandmark;
        public short modeFieldDiameterLeavingLandmark;
        String comment;

        public Landmark() {
            this.landmarkCode[1] = 0;
            this.landmarkCode[0] = 0;
            this.landmarkLocation = 0;
            this.relatedEventNumber = 1;
            this.gpsInformation = new int[2];
            this.gpsInformation[1] = 0;
            this.gpsInformation[0] = 0;
            this.fiberCorrectionFactorLeadInFiber = 0;
            this.sheathMarkerEnteringLandmark = 0;
            this.sheathMarkerLeavingLandmark = 0;
            this.unitsOfSheathMarkerLeavingLandmark = new byte[2];
            this.unitsOfSheathMarkerLeavingLandmark[0] = 70;
            this.unitsOfSheathMarkerLeavingLandmark[1] = 84;
            this.modeFieldDiameterLeavingLandmark = (short)88;
            this.comment = " ";
        }
    }

    public class LnkParams {
        public String blockID = "LnkParams";
        public short totalNumberOfLandmarks = 0;
        public Landmark[] landmarks = null;
        public int size;

        public void createLnkParamsItem(short numberOfLandmarks) {
            if (this.landmarks != null) {
                this.landmarks = null;
            }
            this.landmarks = new Landmark[numberOfLandmarks];
            this.totalNumberOfLandmarks = numberOfLandmarks;
        }
    }

    public class Map {
        public String blockID = null;
        public int revisionNo = 0;
        public int size = 0;
        public short numberOfBlocks = 1;
        public MapItem[] mapItems = null;

        public void createMapItems(short count) {
            this.mapItems = null;
            this.mapItems = new MapItem[count - 1];
            this.numberOfBlocks = count;
        }
    }

    public class MapItem {
        public String id = "";
        public int revisionNo = 0;
        public int size = 0;
    }

    public class OTDRCursor {
        public static final int STATE_FREE = 0;
        public static final int STATE_CAN_DRAG = 1;
        public static final int STATE_DRAG = 2;
        private int dataIndex;
        private boolean shown;
        private int state;

        public OTDRCursor() {
            this.dataIndex = 0;
            this.shown = false;
            this.state = 0;
        }

        public OTDRCursor(boolean isShown) {
            this.dataIndex = 0;
            this.shown = isShown;
            this.state = 0;
        }

        public OTDRCursor(int dIndex, boolean isShown) {
            this.dataIndex = dIndex;
            this.shown = isShown;
            this.state = 0;
        }

        public int getDataIndex() {
            return this.dataIndex;
        }

        public void setDataIndex(int val) {
            if (val < SorFile.this.positiveDistanceIndex) {
                val = SorFile.this.positiveDistanceIndex;
            }
            if (val >= SorFile.this.dataPts.numberOfDataPoints - 1) {
                val = SorFile.this.dataPts.numberOfDataPoints - 1;
            }
            this.dataIndex = val;
        }

        public boolean isShown() {
            return this.shown;
        }

        public void setShown(boolean val) {
            this.shown = val;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int val) {
            this.state = val;
        }
    }

    class RoughEventLimit {
        public int left;
        public int right;

        public RoughEventLimit() {
            this.left = 0;
            this.right = 0;
        }

        public RoughEventLimit(int l, int r) {
            this.left = l;
            this.right = r;
        }
    }

    public class RoughKeyEvents {
        public short numberOfKeyEvents = 0;
        public RoughKeyEventsItem[] events = null;

        public void createKeyEventsItems(short nfKeyEvents) {
            if (this.events != null) {
                this.events = null;
            }
            this.numberOfKeyEvents = nfKeyEvents;
            if (this.numberOfKeyEvents > 0) {
                this.events = new RoughKeyEventsItem[this.numberOfKeyEvents];
                int i = 0;
                while (i < this.numberOfKeyEvents) {
                    this.events[i] = new RoughKeyEventsItem();
                    ++i;
                }
            }
        }

        public void insertEvent(RoughKeyEventsItem event) {
            RoughKeyEventsItem localEvent = new RoughKeyEventsItem(event);
            if (this.numberOfKeyEvents <= 0) {
                this.createKeyEventsItems((short)1);
                this.events[0] = localEvent;
            } else {
                RoughKeyEventsItem[] tmpEvents = new RoughKeyEventsItem[this.numberOfKeyEvents + 1];
                int i = 0;
                while (i < this.numberOfKeyEvents + 1) {
                    tmpEvents[i] = new RoughKeyEventsItem();
                    ++i;
                }
                i = 0;
                int j = 0;
                boolean isEqual = false;
                while (i < this.numberOfKeyEvents) {
                    if (i > 0 && localEvent.eventBeginDataIndex < this.events[i].eventBeginDataIndex && localEvent.eventBeginDataIndex > this.events[i - 1].eventEndDataIndex && localEvent.eventEndDataIndex < this.events[i].eventBeginDataIndex) {
                        tmpEvents[j] = localEvent;
                        ++j;
                    }
                    if (localEvent.eventBeginDataIndex == this.events[i].eventBeginDataIndex) {
                        tmpEvents[j] = localEvent;
                        isEqual = true;
                    } else {
                        tmpEvents[j] = this.events[i];
                    }
                    ++j;
                    ++i;
                }
                if (i != j) {
                    this.numberOfKeyEvents = (short)(this.numberOfKeyEvents + 1);
                }
                if (i == j && !isEqual && localEvent.eventBeginDataIndex > this.events[this.numberOfKeyEvents - 1].eventEndDataIndex) {
                    this.numberOfKeyEvents = (short)(this.numberOfKeyEvents + 1);
                    tmpEvents[this.numberOfKeyEvents - 1] = localEvent;
                }
                this.createKeyEventsItems(this.numberOfKeyEvents);
                i = 0;
                while (i < this.numberOfKeyEvents) {
                    this.events[i] = tmpEvents[i];
                    ++i;
                }
            }
        }

        public void deleteEvent(int eventIndex) {
            if (this.numberOfKeyEvents <= 0) {
                return;
            }
            if (eventIndex < 0 || eventIndex >= this.numberOfKeyEvents) {
                return;
            }
            RoughKeyEventsItem[] tmpEvents = new RoughKeyEventsItem[this.numberOfKeyEvents - 1];
            int i = 0;
            while (i < this.numberOfKeyEvents - 1) {
                tmpEvents[i] = new RoughKeyEventsItem();
                ++i;
            }
            int j = 0;
            i = 0;
            while (i < this.numberOfKeyEvents) {
                if (eventIndex != i) {
                    tmpEvents[j] = this.events[i];
                    ++j;
                }
                ++i;
            }
            this.numberOfKeyEvents = (short)(this.numberOfKeyEvents - 1);
            this.createKeyEventsItems(this.numberOfKeyEvents);
            i = 0;
            while (i < this.numberOfKeyEvents) {
                this.events[i] = tmpEvents[i];
                ++i;
            }
        }
    }

    public class RoughKeyEventsItem {
        public int eventBeginDataIndex;
        public int eventEndDataIndex;
        public float reflectance;
        public float eventLoss;
        public boolean isEndOfFiber;

        public RoughKeyEventsItem() {
            this.eventBeginDataIndex = -1;
            this.eventEndDataIndex = -1;
            this.reflectance = 0.0f;
            this.eventLoss = 0.0f;
            this.isEndOfFiber = false;
        }

        public RoughKeyEventsItem(RoughKeyEventsItem event) {
            this.eventBeginDataIndex = event.eventBeginDataIndex;
            this.eventEndDataIndex = event.eventEndDataIndex;
            this.reflectance = event.reflectance;
            this.eventLoss = event.eventLoss;
            this.isEndOfFiber = event.isEndOfFiber;
        }
    }

    class SVPReferenceParams {
        private static final int RESERVED_SIZE = 256;
        public String blockID = "SVPReferenceParams";
        public int lossDeviation = 0;
        public int reflectanceDeviation = 0;
        public int lossCoefficientDeviation = 0;
        public int fullLossDeviation = 0;
        public byte[] filterCode = new byte[2];
        public byte isLowPower;
        public byte isHighResolution;
        public byte[] reserved;
        public int size;

        public SVPReferenceParams() {
            this.filterCode[0] = 78;
            this.filterCode[1] = 79;
            this.isLowPower = 0;
            this.isHighResolution = 0;
            this.reserved = new byte[256];
            int i = 0;
            while (i < 256) {
                this.reserved[i] = 0;
                ++i;
            }
        }
    }

    public class SpecialProprietary {
        public String blockID;
        public byte[] buffer;
        public int size;
    }

    public class SupParams {
        public String blockID = "SupParams";
        public String supplierName = " ";
        public String otdrMainFrameID = " ";
        public String otdrMainFrameSN = " ";
        public String opticalModuleID = " ";
        public String opticalModuleSN = " ";
        public String softwareRevision = " ";
        public String other = " ";
        public int size;
    }
}

