/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Toolkit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JOptionPane;

public class TL1RTUClient
extends Thread {
    private final int MAX_CTAG_VALUE = 999999;
    private final String okMessage = "OK";
    private final String okLastMessage = "OK_LAST";
    private final String trapMessage = "TRAP";
    private final String deniedMessage = "DENIED";
    private final String errorResponseType = "ER_RESPONSE_TYPE";
    private String responseType;
    static final long WAIT_TIMEOUT = 3000L;
    private MainClass mainClass;
    private OTDRFindDialog otdrFindDialog = null;
    private OTDRProgressDialog otdrProgressDialog = null;
    private String otdrFindDialogText = "";
    boolean connected;
    private OTDRIO otdrIO;
    private CommandQueueElement[] commandQueue;
    private String UID;
    private String SID;
    private int ctagIndex = 0;
    private boolean readyToSendCommand = false;
    private String strtMeasIterParam = null;
    private boolean isSuspended = false;
    private int numberOfIterations = 0;
    private int iterationIndex = 0;

    private void commonConstructorActions() {
        this.connected = false;
        this.commandQueue = new CommandQueueElement[0];
    }

    public TL1RTUClient(MainClass mClass) {
        this.mainClass = mClass;
        this.commonConstructorActions();
    }

    public TL1RTUClient(MainClass mClass, OTDRIO oIO) {
        this.mainClass = mClass;
        this.otdrIO = oIO;
        this.commonConstructorActions();
    }

    public void setIO(OTDRIO oIO) {
        if (this.otdrIO != null) {
            this.otdrIO.disconnect();
        }
        this.otdrIO = null;
        this.otdrIO = oIO;
    }

    public OTDRIO getIO() {
        return this.otdrIO;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void refreshCommand(int index) {
        this.commandQueue[index].command = String.valueOf(this.commandQueue[index].commandBlock) + ":" + this.commandQueue[index].routingBlock + ":" + this.commandQueue[index].accessBlock + ":" + this.commandQueue[index].correlationBlock + ":" + this.commandQueue[index].dataModeBlocks + ";";
    }

    private void removeCommandFromQueue(String commandBlock) {
        CommandQueueElement[] tmpQueue = (CommandQueueElement[])this.commandQueue.clone();
        int nRemovingCommands = 0;
        int i = 0;
        while (i < tmpQueue.length) {
            if (commandBlock == tmpQueue[i].commandBlock) {
                ++nRemovingCommands;
            }
            ++i;
        }
        this.commandQueue = new CommandQueueElement[tmpQueue.length - nRemovingCommands];
        int j = 0;
        i = 0;
        while (i < tmpQueue.length) {
            if (commandBlock != tmpQueue[i].commandBlock) {
                this.commandQueue[j] = tmpQueue[i];
                ++j;
            }
            ++i;
        }
    }

    private void queueCommand(String commandBlock, String routingBlock, String accessBlock, String dataModeBlocks) {
        this.queueCommand(commandBlock, routingBlock, accessBlock, dataModeBlocks, false);
    }

    private void queueCommand(String commandBlock, String routingBlock, String accessBlock, String dataModeBlocks, boolean needToSetOnGet) {
        CommandQueueElement[] tmpQueue = (CommandQueueElement[])this.commandQueue.clone();
        this.commandQueue = null;
        this.commandQueue = new CommandQueueElement[tmpQueue.length + 1];
        int commandIndex = 0;
        while (commandIndex < tmpQueue.length) {
            this.commandQueue[commandIndex] = new CommandQueueElement();
            this.commandQueue[commandIndex] = tmpQueue[commandIndex];
            ++commandIndex;
        }
        this.commandQueue[commandIndex] = new CommandQueueElement();
        this.commandQueue[commandIndex].commandBlock = commandBlock;
        this.commandQueue[commandIndex].routingBlock = routingBlock;
        this.commandQueue[commandIndex].accessBlock = accessBlock;
        this.commandQueue[commandIndex].correlationBlock = String.format("ctag%06d", this.ctagIndex);
        ++this.ctagIndex;
        if (this.ctagIndex > 999999) {
            this.ctagIndex = 0;
        }
        this.commandQueue[commandIndex].dataModeBlocks = dataModeBlocks;
        this.commandQueue[commandIndex].needToSetOnGet = needToSetOnGet;
        this.refreshCommand(commandIndex);
    }

    private byte[] queueByte(byte[] buffer, byte b) {
        byte[] tmpBuffer = (byte[])buffer.clone();
        buffer = null;
        buffer = new byte[tmpBuffer.length + 1];
        int i = 0;
        while (i < tmpBuffer.length) {
            buffer[i] = tmpBuffer[i];
            ++i;
        }
        buffer[tmpBuffer.length] = b;
        return buffer;
    }

    private String findParam(String response) {
        String ret;
        String tmpS = response.toUpperCase();
        this.responseType = -1 != tmpS.indexOf("DENIED") ? "DENIED" : (-1 != tmpS.indexOf("TRAP") ? "TRAP" : (-1 != tmpS.indexOf("OK_LAST") ? "OK_LAST" : (-1 != tmpS.indexOf("OK") ? "OK" : "")));
        if (this.responseType.length() == 0) {
            ret = "ER_RESPONSE_TYPE";
        } else {
            String sBefore = String.valueOf(this.responseType) + "\r\n   ";
            String sAfter = "\r\n;";
            int iBegin = response.lastIndexOf(sBefore) + sBefore.length();
            int iEnd = response.indexOf(sAfter) - 1;
            ret = new String(response.getBytes(), iBegin, iEnd - iBegin + 1);
        }
        return ret;
    }

    private String[] getParamList(String prms) {
        String[] paramList = prms.split("\r\n   ");
        int i = 0;
        while (i < paramList.length) {
            paramList[i] = paramList[i].replace("\r\n", "");
            ++i;
        }
        return paramList;
    }

    private void printParamList(String cap, String[] pL) {
    }

    private void processResponse(String commandBlock, String param, boolean needToSetOnGet) {
        OTDRModuleParameters otdrModuleParameters = this.mainClass.getOTDRModuleParameters();
        if ("GET-SOFT-NAME" == commandBlock) {
            otdrModuleParameters.softName = param;
        } else if ("GET-MEAS-PLS-WL" == commandBlock) {
            otdrModuleParameters.wLList = this.getParamList(param);
            this.printParamList("wLList", otdrModuleParameters.wLList);
        } else if ("GET-MEAS-PLS-LMAX" == commandBlock) {
            otdrModuleParameters.lMaxList = this.getParamList(param);
            this.printParamList("lMaxList", otdrModuleParameters.lMaxList);
        } else if ("GET-MEAS-PLS-RES" == commandBlock) {
            otdrModuleParameters.resList = this.getParamList(param);
            this.printParamList("resList", otdrModuleParameters.resList);
            if (needToSetOnGet && otdrModuleParameters.res != null && !otdrModuleParameters.res.isEmpty()) {
                int resIndex = 0;
                float deltaRes = 240000.0f;
                int i = 0;
                while (i < otdrModuleParameters.resList.length) {
                    float tmpDelta = Math.abs(Float.valueOf(otdrModuleParameters.res).floatValue() - Float.valueOf(otdrModuleParameters.resList[i]).floatValue());
                    if (tmpDelta < deltaRes) {
                        deltaRes = tmpDelta;
                        resIndex = i;
                    }
                    ++i;
                }
                otdrModuleParameters.res = otdrModuleParameters.resList[resIndex];
                this.queueCommand("SET-MEAS-PRM-RES", this.SID, this.UID, otdrModuleParameters.res);
            }
        } else if ("GET-MEAS-PLS-PLS" == commandBlock) {
            otdrModuleParameters.plsList = this.getParamList(param);
            this.printParamList("plsList", otdrModuleParameters.plsList);
            if (needToSetOnGet && otdrModuleParameters.pls != null && !otdrModuleParameters.pls.isEmpty()) {
                int plsIndex = 0;
                int deltaPls = 20000;
                int i = 0;
                while (i < otdrModuleParameters.plsList.length) {
                    int tmpDelta = Math.abs(Long.valueOf(otdrModuleParameters.pls).intValue() - Long.valueOf(otdrModuleParameters.plsList[i]).intValue());
                    if (tmpDelta < deltaPls) {
                        plsIndex = i;
                        deltaPls = tmpDelta;
                    }
                    ++i;
                }
                otdrModuleParameters.pls = otdrModuleParameters.plsList[plsIndex];
                this.queueCommand("SET-MEAS-PRM-PLS", this.SID, this.UID, otdrModuleParameters.pls);
            }
        } else if ("GET-MEAS-PLS-NAVR" == commandBlock) {
            otdrModuleParameters.navrList = this.getParamList(param);
            this.printParamList("navrList", otdrModuleParameters.navrList);
            if (needToSetOnGet && otdrModuleParameters.nAvr != null) {
                int nAvrIndex = 0;
                int delta_n = 1000000;
                int i = 0;
                while (i < otdrModuleParameters.navrList.length) {
                    int tmpDelta = Math.abs(Long.valueOf(otdrModuleParameters.nAvr).intValue() - Long.valueOf(otdrModuleParameters.navrList[i]).intValue());
                    if (tmpDelta < delta_n) {
                        delta_n = tmpDelta;
                        nAvrIndex = i;
                    }
                    ++i;
                }
                otdrModuleParameters.nAvr = otdrModuleParameters.navrList[nAvrIndex];
                this.queueCommand("SET-MEAS-PRM-NAVR", this.SID, this.UID, otdrModuleParameters.nAvr);
            }
        } else if ("GET-MEAS-PLS-TAVR" == commandBlock) {
            otdrModuleParameters.tavrList = this.getParamList(param);
            this.printParamList("tavrList", otdrModuleParameters.tavrList);
            if (needToSetOnGet && otdrModuleParameters.tAvr != null) {
                long dMillims = 3600000L;
                int tAverIndex = 0;
                int i = 0;
                while (i < otdrModuleParameters.tavrList.length) {
                    String tmpTAvr = otdrModuleParameters.tavrList[i];
                    tmpTAvr = tmpTAvr.replace('-', ':');
                    Calendar averTime = Calendar.getInstance();
                    Calendar cmpAverTime = Calendar.getInstance();
                    TimeZone tz = averTime.getTimeZone();
                    tz.setRawOffset(0);
                    averTime.setTimeZone(tz);
                    cmpAverTime.setTimeZone(tz);
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat();
                        if (tmpTAvr.length() <= 5) {
                            formatter.applyPattern("mm:ss");
                        } else {
                            formatter.applyPattern("HH:mm:ss");
                        }
                        cmpAverTime.setTime(formatter.parse(tmpTAvr));
                        if (otdrModuleParameters.tAvr.length() <= 5) {
                            formatter.applyPattern("mm:ss");
                        } else {
                            formatter.applyPattern("HH:mm:ss");
                        }
                        averTime.setTime(formatter.parse(otdrModuleParameters.tAvr.replace('-', ':')));
                        long tAverMillims = averTime.getTimeInMillis();
                        long tmpDMillims = Math.abs(tAverMillims - cmpAverTime.getTimeInMillis());
                        if (dMillims > tmpDMillims) {
                            tAverIndex = i;
                            dMillims = tmpDMillims;
                        }
                    }
                    catch (ParseException pe) {
                        System.out.printf("unparseable date:%s\n", tmpTAvr);
                    }
                    ++i;
                }
                otdrModuleParameters.tAvr = otdrModuleParameters.tavrList[tAverIndex];
                this.queueCommand("SET-MEAS-PRM-TAVR", this.SID, this.UID, otdrModuleParameters.tAvr);
            }
        } else if ("GET-MEAS-PRM-WL" == commandBlock) {
            otdrModuleParameters.wL = param;
        } else if ("GET-MEAS-PRM-LMAX" == commandBlock) {
            otdrModuleParameters.lMax = param;
        } else if ("GET-MEAS-PRM-RES" == commandBlock) {
            otdrModuleParameters.res = param;
        } else if ("GET-MEAS-PRM-PLS" == commandBlock) {
            otdrModuleParameters.pls = param;
        } else if ("GET-MEAS-PRM-NAVR" == commandBlock) {
            otdrModuleParameters.nAvr = param;
        } else if ("GET-MEAS-PRM-TAVR" == commandBlock) {
            otdrModuleParameters.tAvr = param;
        } else if ("GET-MEAS-PRM-BC" == commandBlock) {
            otdrModuleParameters.bC = param;
        } else if ("GET-MEAS-PRM-RI" == commandBlock) {
            otdrModuleParameters.rI = param;
        } else if ("GET-MEAS-PRM-ISTA" == commandBlock) {
            otdrModuleParameters.isTA = param;
        } else if ("GET-MEAS-PRM-ISLP" == commandBlock) {
            otdrModuleParameters.isLP = param;
        } else if ("GET-MEAS-PRM-ISHR" == commandBlock) {
            otdrModuleParameters.isHR = param;
        } else if ("GET-MEAS-PRM-ISFL" == commandBlock) {
            otdrModuleParameters.isFl = param;
        } else if ("CONN-DEV-INIT" == commandBlock) {
            this.SID = param;
            this.queueCommand("GET-MEAS-PLS-WL", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PLS-LMAX", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PLS-RES", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PLS-PLS", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-WL", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-LMAX", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-RES", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-PLS", this.SID, this.UID, "");
            this.mainClass.getOTDRModuleParameters().isTA = "OFF";
            this.queueCommand("SET-MEAS-PRM-ISTA", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isTA);
            this.queueCommand("GET-MEAS-PRM-ISTA", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-NAVR", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-TAVR", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-BC", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-RI", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-ISLP", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-ISHR", this.SID, this.UID, "");
            this.queueCommand("GET-MEAS-PRM-ISFL", this.SID, this.UID, "");
        } else if ("STRT-MEAS-ITER" == commandBlock) {
            this.queueCommand("STEP-MEAS-ITER", this.SID, this.UID, "");
            this.numberOfIterations = (int)Long.valueOf(param).longValue();
            if (this.otdrProgressDialog != null) {
                this.otdrProgressDialog.setMaximum(this.numberOfIterations);
                this.otdrProgressDialog.setProgress(0);
            }
            this.iterationIndex = 0;
            MainClass.QDEBUG("number of iterations = %d\n", this.numberOfIterations);
        } else if ("STEP-MEAS-ITER" == commandBlock) {
            MainClass.QDEBUG("step %d from %d completed\n", ++this.iterationIndex, this.numberOfIterations);
            if (this.otdrProgressDialog != null) {
                this.otdrProgressDialog.setProgress(this.iterationIndex);
            }
            if ("OK_LAST" == this.responseType) {
                this.strtMeasIterParam = null;
                if (this.otdrProgressDialog != null) {
                    this.otdrProgressDialog.setVisible(false);
                }
                this.queueCommand("GET-MEAS-SOR", this.SID, this.UID, "");
            } else {
                this.queueCommand("GET-MEAS-SOR", this.SID, this.UID, "");
            }
        } else if ("GET-MEAS-SOR" == commandBlock) {
            if (this.strtMeasIterParam != null) {
                this.queueCommand("STEP-MEAS-ITER", this.SID, this.UID, "");
            } else {
                if (this.connected) {
                    this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.CONNECTED);
                } else {
                    this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.DISCONNECTED);
                }
                this.mainClass.mainFrame.setCursor(new Cursor(0));
                int sfIndex = this.mainClass.getCurrentSorFileIndex();
                SorFile sorFile = this.mainClass.getSorFile(sfIndex);
                if (sorFile != null) {
                    sorFile.isSVPReferenceParamsPresent = true;
                    if (this.mainClass.getOTDRModuleParameters().isFl.toUpperCase().compareTo("OFF") == 0) {
                        sorFile.svpReferenceParams.filterCode[0] = 78;
                        sorFile.svpReferenceParams.filterCode[1] = 79;
                    } else {
                        sorFile.svpReferenceParams.filterCode[0] = 79;
                        sorFile.svpReferenceParams.filterCode[1] = 78;
                    }
                    sorFile.svpReferenceParams.isLowPower = this.mainClass.getOTDRModuleParameters().isLP.toUpperCase().compareTo("OFF") == 0 ? (byte)0 : 1;
                    sorFile.svpReferenceParams.isHighResolution = this.mainClass.getOTDRModuleParameters().isHR.toUpperCase().compareTo("OFF") == 0 ? (byte)0 : 1;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        } else if ("STOP-MEAS-ITER" == commandBlock) {
            this.queueCommand("GET-MEAS-SOR", this.SID, this.UID, "");
        }
    }

    public void startMeas(boolean isAverage) {
        this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.MEASURING);
        this.setSuspended(true);
        this.strtMeasIterParam = isAverage ? "AVER" : "LIVE";
        this.queueCommand("STRT-MEAS-ITER", this.SID, this.UID, this.strtMeasIterParam);
        this.setSuspended(false);
    }

    public void stopMeas() {
        if (this.strtMeasIterParam == null) {
            return;
        }
        this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.STOPPING_MEASURING);
        this.mainClass.mainFrame.setCursor(new Cursor(3));
        this.setSuspended(true);
        this.queueCommand("STOP-MEAS-ITER", this.SID, this.UID, "FAST");
        this.strtMeasIterParam = null;
        this.setSuspended(false);
    }

    public void setSuspended(boolean to) {
        this.isSuspended = to;
    }

    @Override
    public void run() {
        OTDRModuleParameters otdrModuleParameters = this.mainClass.getOTDRModuleParameters();
        if (this.otdrIO != null) {
            if (!this.otdrIO.connect()) {
                this.connected = false;
            }
        } else {
            this.connected = false;
        }
        if (this.connected) {
            MainClass.QDEBUG("run: connected...\n", new Object[0]);
        }
        if (this.otdrFindDialog != null) {
            this.otdrFindDialog.startTimer();
            this.otdrFindDialogText = this.otdrFindDialog.getLabelText();
        } else {
            this.otdrFindDialogText = "connecting...";
        }
        if (this.connected) {
            this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.CONNECTED);
        } else {
            this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.DISCONNECTED);
        }
        while (this.connected) {
            while (this.isSuspended) {
            }
            if (!this.connected) break;
            if (this.otdrFindDialog != null && this.otdrFindDialog.isVisible() && this.otdrFindDialog.getButtonStateIndex() == 0) {
                if (this.otdrFindDialog.getLabelText() != this.otdrFindDialogText) {
                    this.otdrFindDialog.setLabelText(this.otdrFindDialogText);
                }
                if (otdrModuleParameters.testInit()) {
                    this.otdrFindDialog.setButtonStateIndex(1);
                    String tmpS = this.mainClass.getResourceString("FOUND_OTDR_MODULE");
                    tmpS = String.valueOf(tmpS) + "  \"" + this.SID + "\"";
                    this.otdrFindDialog.setLabelText(tmpS);
                    this.otdrFindDialog.stopTimer();
                    this.otdrFindDialog.setIcon(this.mainClass.loadImageIcon("resources/connect0.gif"));
                }
            }
            while (this.commandQueue == null) {
            }
            if (this.commandQueue.length <= 0 || !this.readyToSendCommand) continue;
            this.readyToSendCommand = false;
            this.sendToServer(this.commandQueue[0].command);
            MainClass.QDEBUG("before getResponseFromServer for %s\n", this.commandQueue[0].command);
            String resp = this.getResponseFromServer();
            if (resp.length() == 0) {
                if (this.connected) {
                    this.disconnect();
                }
                MainClass.QDEBUG("Empty response!!!\n", new Object[0]);
                break;
            }
            MainClass.QDEBUG("after getResponseFromServer =  %s, len = %d\n", resp, resp.length());
            String param = this.findParam(resp);
            if (this.responseType == "DENIED") {
                if (-1 != param.indexOf("ER_SIGNAL")) {
                    if (this.otdrProgressDialog != null) {
                        this.otdrProgressDialog.setVisible(false);
                    }
                    this.mainClass.mainFrame.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this.mainClass.mainFrame, this.mainClass.getResourceString("LIVE_FIBER_ERROR_STRING"), this.mainClass.getResourceString("titleString"), 0);
                    while (this.commandQueue.length > 0) {
                        this.removeCommandFromQueue(this.commandQueue[0].commandBlock);
                    }
                    this.readyToSendCommand = true;
                    this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.CONNECTED);
                    continue;
                }
                if (-1 != param.indexOf("ER_")) {
                    String message = String.format("Error response: %s\n", param);
                    MainClass.QDEBUG(message, new Object[0]);
                    JOptionPane.showMessageDialog(this.mainClass.mainFrame, message, this.mainClass.getResourceString("titleString"), 0);
                    this.disconnect();
                    break;
                }
            }
            if ("GET-MEAS-SOR" == this.commandQueue[0].commandBlock) {
                int fileSize = Math.round(Float.valueOf(param).floatValue());
                byte[] sorBuffer = new byte[fileSize];
                int i = 0;
                while (i < fileSize) {
                    try {
                        sorBuffer[i] = (byte)this.otdrIO.read();
                    }
                    catch (OTDRIO.OTDRIOException e) {
                        MainClass.QDEBUG("OTDRIOException:\n", e.getMessage());
                        this.disconnect();
                        break;
                    }
                    ++i;
                }
                int sfIndex = this.mainClass.getCurrentSorFileIndex();
                SorFile sorFile = this.mainClass.getSorFile(sfIndex);
                if (sorFile != null) {
                    if (!this.mainClass.otdrControlPanel.isRfgChecked(sfIndex)) {
                        this.mainClass.otdrControlPanel.setRfgChecked(sfIndex, true);
                        this.mainClass.otdrControlPanel.updateUI();
                    }
                    sorFile.createFromBuffer(sorBuffer);
                    sorFile.setDefaultMeasureParameters(this.mainClass);
                    this.mainClass.updateAll();
                }
                RfgView rfgView = this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView();
                this.mainClass.otdrWindow.getRfgBackGroundPanel().updateUI();
                rfgView.invalidateView();
                rfgView.updateUI();
                this.mainClass.updateStatusBar();
                this.mainClass.updateOtdrControlPanel();
            }
            this.processResponse(this.commandQueue[0].commandBlock, param, this.commandQueue[0].needToSetOnGet);
            this.removeCommandFromQueue(this.commandQueue[0].commandBlock);
            this.readyToSendCommand = true;
        }
        if (this.otdrProgressDialog != null && this.otdrProgressDialog.isVisible()) {
            this.otdrProgressDialog.setVisible(false);
        }
        if (this.mainClass.getOTDRParametersDialog() != null && this.mainClass.getOTDRParametersDialog().isVisible()) {
            this.mainClass.getOTDRParametersDialog().setVisible(false);
        }
        if (this.otdrFindDialog != null && this.otdrFindDialog.isVisible()) {
            this.otdrFindDialog.setVisible(false);
        }
        if (this.otdrIO != null) {
            this.otdrIO.disconnect();
        }
        MainClass.QDEBUG("thread exited...\n", new Object[0]);
        if (this.connected) {
            this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.CONNECTED);
        } else {
            this.mainClass.updateMesauringMenuAndToolBar(MainClass.InstrumentState.DISCONNECTED);
        }
    }

    public void connect() {
        this.setDaemon(true);
        this.setPriority(5);
        this.connected = true;
        this.start();
        this.SID = "";
        this.UID = "RTUAdmin";
        this.queueCommand("ACT-USER", this.SID, this.UID, "unchanged");
        this.queueCommand("GET-PROT-REV", this.SID, this.UID, "");
        this.queueCommand("GET-PROT-VER", this.SID, this.UID, "");
        this.queueCommand("GET-SOFT-NAME", this.SID, this.UID, "");
        this.queueCommand("GET-SOFT-VER", this.SID, this.UID, "");
        this.queueCommand("GET-FULL-VER", this.SID, this.UID, "");
        this.queueCommand("CONN-DEV-INIT", this.SID, this.UID, "SPI:/dev/svpdev/spi0:2250000");
        this.readyToSendCommand = true;
    }

    public void disconnect() {
        this.connected = false;
        this.setSuspended(false);
        MainClass.QDEBUG("connected = false\n", new Object[0]);
    }

    private String getResponseFromServer() {
        byte[] buffer = new byte[]{};
        while (true) {
            int ib = -1;
            if (!this.connected) break;
            try {
                ib = this.otdrIO.read();
            }
            catch (OTDRIO.OTDRIOException e) {
                MainClass.QDEBUG("OTDRIOException:\n", e.getMessage());
                this.disconnect();
                break;
            }
            if (-1 == ib) continue;
            byte b = (byte)ib;
            buffer = this.queueByte(buffer, b);
            if (59 == b) break;
        }
        String resp = new String(buffer, 0, buffer.length);
        return resp;
    }

    private void sendToServer(String cmd) {
        MainClass.QDEBUG(String.valueOf(cmd) + "\n", new Object[0]);
        cmd = String.valueOf(cmd) + "\n";
        byte[] b = cmd.getBytes();
        int i = 0;
        while (i < b.length) {
            try {
                this.otdrIO.write(b[i]);
            }
            catch (OTDRIO.OTDRIOException e) {
                MainClass.QDEBUG("OTDRIOException:\n", e.getMessage());
                this.disconnect();
                break;
            }
            ++i;
        }
    }

    public void setOTDRFindDialog(OTDRFindDialog to) {
        this.otdrFindDialog = to;
    }

    public void setOTDRProgressDialog(OTDRProgressDialog to) {
        this.otdrProgressDialog = to;
    }

    public int nCommands() {
        if (this.commandQueue == null) {
            return 0;
        }
        if (this.commandQueue.length == 0) {
            return 0;
        }
        return this.commandQueue.length;
    }

    public void reconnectOTDR() {
        this.setSuspended(true);
        this.queueCommand("DISC-DEV", this.SID, this.UID, "");
        this.queueCommand("CONN-DEV-INIT", this.SID, this.UID, "SPI:/dev/svpdev/spi0:2250000");
        this.setSuspended(false);
        while (!this.mainClass.getOTDRModuleParameters().testInit()) {
            if (!this.isConnected()) break;
        }
    }

    public void waitForCompleteCommands() {
        long startTime;
        long tmpTime = startTime = System.currentTimeMillis();
        while (this.nCommands() > 0 && this.isConnected() && 3000L > (tmpTime = System.currentTimeMillis()) - startTime) {
        }
        MainClass.QDEBUG("waitForCompleteCommands: elapsed %d ms, nCommands=%d\n", tmpTime - startTime, this.nCommands());
        if (3000L <= tmpTime - startTime) {
            System.out.println("TL1RTUClient error: WAIT_TIMEOUT !!!");
        }
    }

    public int setMeasuringParametersAccordingSorFile(SorFile sorFile) {
        String tmpS;
        OTDRModuleParameters otdrModuleParameters = this.mainClass.getOTDRModuleParameters();
        int ret = 0;
        boolean deviceInited = otdrModuleParameters.testInit();
        MainClass.QDEBUG("++++++++++++++STARTING setMeasuringParametersAccordingSorFile +++++++++++++++++++++++++\n", new Object[0]);
        if (!deviceInited) {
            return -1;
        }
        if (sorFile == null) {
            return -2;
        }
        if (!sorFile.isDataPtsPresent) {
            return -3;
        }
        if (!this.connected) {
            return -4;
        }
        this.setSuspended(true);
        deviceInited = false;
        int i = 0;
        while (i < otdrModuleParameters.wLList.length) {
            otdrModuleParameters.wL = tmpS = otdrModuleParameters.wLList[i];
            tmpS = tmpS.replace("SM ", "");
            tmpS = tmpS.replace("\r", "");
            if (Long.parseLong(tmpS = tmpS.replace("\n", "")) == (long)sorFile.genParams.nominalWaveLength) {
                MainClass.QDEBUG("WL found: %s\n", otdrModuleParameters.wL);
                break;
            }
            ++i;
        }
        this.queueCommand("SET-MEAS-PRM-WL", this.SID, this.UID, otdrModuleParameters.wL);
        float fLMax = (long)sorFile.fxdParams.acquisitionRangeDistance != 0L ? (float)sorFile.fxdParams.acquisitionRangeDistance / 10.0f * sorFile.fxdParams.distanceMultiplier : (float)sorFile.recalcDistance(sorFile.getTimeIndex(sorFile.fxdParams.acquisitionRange));
        fLMax = (float)Math.round(fLMax * 10.0f) / 10.0f;
        otdrModuleParameters.lMax = null;
        i = 0;
        while (i < otdrModuleParameters.lMaxList.length) {
            tmpS = otdrModuleParameters.lMaxList[i];
            if ((double)Math.abs(Float.valueOf(tmpS).floatValue() - fLMax) < 1.0E-4) {
                otdrModuleParameters.lMax = tmpS;
                MainClass.QDEBUG("lMax found: %s == %f\n", otdrModuleParameters.lMax, Float.valueOf(fLMax));
                break;
            }
            ++i;
        }
        if (otdrModuleParameters.lMax == null) {
            int lMaxIndex = 0;
            float delta_km = 1000.0f;
            i = 0;
            while (i < otdrModuleParameters.lMaxList.length) {
                float tmpF = Float.valueOf(otdrModuleParameters.lMaxList[i]).floatValue();
                float tmp_delta_km = tmpF - fLMax;
                if (tmp_delta_km > 0.0f && tmp_delta_km < delta_km) {
                    lMaxIndex = i;
                    delta_km = tmp_delta_km;
                }
                ++i;
            }
            otdrModuleParameters.lMax = otdrModuleParameters.lMaxList[lMaxIndex];
            MainClass.QDEBUG("lMax found: %s nearest biggest to  %f\n", otdrModuleParameters.lMax, Float.valueOf(fLMax));
        }
        this.queueCommand("SET-MEAS-PRM-LMAX", this.SID, this.UID, otdrModuleParameters.lMax);
        if (sorFile.fxdParams.averagingTime != 0) {
            int averSeconds = sorFile.fxdParams.averagingTime / 10;
            Calendar averTime = Calendar.getInstance();
            TimeZone tz = averTime.getTimeZone();
            tz.setRawOffset(0);
            averTime.setTimeZone(tz);
            averTime.setTimeInMillis(averSeconds * 1000);
            otdrModuleParameters.isTA = "ON";
            int hours = averTime.get(10);
            SimpleDateFormat formatter = hours > 0 ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat("mm:ss");
            otdrModuleParameters.tAvr = formatter.format(averTime.getTime());
            otdrModuleParameters.tAvr = otdrModuleParameters.tAvr.replace(':', '-');
            MainClass.QDEBUG("averSeconds = %d = %s\n", averSeconds, otdrModuleParameters.tAvr);
        } else if (sorFile.fxdParams.numberOfAverages != 0) {
            long lNAvr = otdrModuleParameters.softName.toUpperCase().contains("IIT") ? (long)(sorFile.fxdParams.numberOfAverages / 4096) : (long)sorFile.fxdParams.numberOfAverages;
            if (0L == lNAvr) {
                lNAvr = 1L;
            }
            otdrModuleParameters.nAvr = String.format("%d", lNAvr);
            otdrModuleParameters.isTA = "OFF";
        }
        this.queueCommand("SET-MEAS-PRM-ISTA", this.SID, this.UID, otdrModuleParameters.isTA);
        if (otdrModuleParameters.isTA.toUpperCase().compareTo("ON") == 0) {
            this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "", true);
        } else {
            this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "", true);
        }
        otdrModuleParameters.rI = String.format("%1.5f", (double)sorFile.fxdParams.groupIndex / 100000.0);
        otdrModuleParameters.rI = otdrModuleParameters.rI.replace(',', '.');
        this.queueCommand("SET-MEAS-PRM-RI", this.SID, this.UID, otdrModuleParameters.rI);
        if (sorFile.fxdParams.totalNumberOfPulseWidthsUsed > 0) {
            this.queueCommand("GET-MEAS-PLS-PLS", this.SID, this.UID, "", true);
            otdrModuleParameters.pls = String.format("%d", sorFile.fxdParams.pulseWidthsUsed[0]);
            double dDL = 1000.0 * sorFile.recalcDistance(sorFile.positiveDistanceIndex, sorFile.positiveDistanceIndex + 1);
            dDL = (double)Math.round(dDL * 100.0) / 100.0;
            otdrModuleParameters.res = String.format("%.2f", Float.valueOf((float)dDL));
            otdrModuleParameters.res = otdrModuleParameters.res.replace(',', '.');
            this.queueCommand("GET-MEAS-PLS-RES", this.SID, this.UID, "", true);
        }
        otdrModuleParameters.bC = String.format("%.1f", Float.valueOf(-((float)sorFile.fxdParams.backscatterCoefficient) / 10.0f));
        otdrModuleParameters.bC = otdrModuleParameters.bC.replace(',', '.');
        this.queueCommand("SET-MEAS-PRM-BC", this.SID, this.UID, otdrModuleParameters.bC);
        if (sorFile.isSVPReferenceParamsPresent) {
            String filter = new String(sorFile.svpReferenceParams.filterCode);
            otdrModuleParameters.isFl = filter.toUpperCase().compareTo("NO") == 0 ? "OFF" : "ON";
            otdrModuleParameters.isLP = sorFile.svpReferenceParams.isLowPower == 0 ? "OFF" : "ON";
            otdrModuleParameters.isHR = sorFile.svpReferenceParams.isHighResolution == 0 ? "OFF" : "ON";
            this.queueCommand("SET-MEAS-PRM-ISFL", this.SID, this.UID, otdrModuleParameters.isFl);
            this.queueCommand("SET-MEAS-PRM-ISLP", this.SID, this.UID, otdrModuleParameters.isLP);
            this.queueCommand("SET-MEAS-PRM-ISHR", this.SID, this.UID, otdrModuleParameters.isHR);
        }
        MainClass.QDEBUG("++++++++++++++FINISHING setMeasuringParametersAccordingSorFile +++++++++++++++++++++++++\n", new Object[0]);
        MainClass.QDEBUG("ret = %d\n", ret);
        this.setSuspended(false);
        this.waitForCompleteCommands();
        return ret;
    }

    public void queueSetAllPrm() {
        MainClass.QDEBUG("----------------------------------queueSetAllPrm----------------------------------\n", new Object[0]);
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-WL", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().wL);
        this.queueCommand("SET-MEAS-PRM-LMAX", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().lMax);
        this.queueCommand("SET-MEAS-PRM-RES", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().res);
        this.queueCommand("SET-MEAS-PRM-PLS", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().pls);
        this.queueCommand("SET-MEAS-PRM-ISTA", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isTA);
        if (this.mainClass.getOTDRModuleParameters().isTA.compareTo("ON") == 0) {
            this.queueCommand("SET-MEAS-PRM-TAVR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().tAvr);
        } else {
            this.queueCommand("SET-MEAS-PRM-NAVR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().nAvr);
        }
        this.queueCommand("SET-MEAS-PRM-BC", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().bC);
        this.queueCommand("SET-MEAS-PRM-RI", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().rI);
        this.queueCommand("SET-MEAS-PRM-ISLP", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isLP);
        this.queueCommand("SET-MEAS-PRM-ISHR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isHR);
        this.queueCommand("SET-MEAS-PRM-ISFL", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isFl);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeWL() {
        this.queueSetAllPrm();
    }

    public void changeLMax() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-LMAX", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().lMax);
        this.queueCommand("GET-MEAS-PLS-RES", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PLS-PLS", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-RES", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-PLS", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-NAVR", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeRes() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-RES", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().res);
        this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-NAVR", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changePls() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-PLS", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().pls);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeNAvr() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-NAVR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().nAvr);
        this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-TAVR", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeTAvr() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-TAVR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().tAvr);
        this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-NAVR", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeIsTAvr() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-ISTA", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isTA);
        this.queueCommand("GET-MEAS-PLS-NAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PLS-TAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-NAVR", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-TAVR", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeRI() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-RI", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().rI);
        this.queueCommand("GET-MEAS-PLS-RES", this.SID, this.UID, "");
        this.queueCommand("GET-MEAS-PRM-RES", this.SID, this.UID, "");
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeBC() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-BC", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().bC);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeLP() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-ISLP", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isLP);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeHR() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-ISHR", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isHR);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    public void changeFL() {
        this.setSuspended(true);
        this.queueCommand("SET-MEAS-PRM-ISFL", this.SID, this.UID, this.mainClass.getOTDRModuleParameters().isFl);
        this.setSuspended(false);
        this.waitForCompleteCommands();
    }

    private class CommandQueueElement {
        String command = null;
        String commandBlock = null;
        String routingBlock = null;
        String accessBlock = null;
        String correlationBlock = null;
        String dataModeBlocks = null;
        boolean needToSetOnGet = false;
    }
}

